/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.registry;

import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.registry.MidnightItems;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.IItemTier;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;

public class MidnightItemTiers {
    public static final IItemTier SHADOWROOT = new Builder().withHarvestLevel(0).withMaxUses(59).withEfficiency(2.0f).withAttackDamage(0.0f).withEnchantability(14).withRepairMaterial(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{MidnightBlocks.SHADOWROOT_PLANKS})).build();
    public static final IItemTier NIGHTSTONE = new Builder().withHarvestLevel(1).withMaxUses(150).withEfficiency(4.0f).withAttackDamage(1.0f).withEnchantability(5).withRepairMaterial(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{MidnightBlocks.NIGHTSTONE})).build();
    public static final IItemTier EBONITE = new Builder().withHarvestLevel(2).withMaxUses(350).withEfficiency(6.0f).withAttackDamage(2.0f).withEnchantability(8).withRepairMaterial(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{MidnightItems.EBONITE})).build();
    public static final IItemTier NAGRILITE = new Builder().withHarvestLevel(3).withMaxUses(850).withEfficiency(3.0f).withAttackDamage(3.0f).withEnchantability(10).withRepairMaterial(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{MidnightItems.NAGRILITE_INGOT})).build();
    public static final IItemTier TENEBRUM = new Builder().withHarvestLevel(3).withMaxUses(1561).withEfficiency(10.0f).withAttackDamage(4.0f).withEnchantability(10).withRepairMaterial(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{MidnightItems.TENEBRUM_INGOT})).build();

    private static class Builder {
        private int maxUses;
        private float efficiency;
        private float attackDamage;
        private int harvestLevel;
        private int enchantability;
        private Supplier<Ingredient> repairMaterial;

        private Builder() {
        }

        public Builder withMaxUses(int maxUses) {
            this.maxUses = maxUses;
            return this;
        }

        public Builder withEfficiency(float efficiency) {
            this.efficiency = efficiency;
            return this;
        }

        public Builder withAttackDamage(float attackDamage) {
            this.attackDamage = attackDamage;
            return this;
        }

        public Builder withHarvestLevel(int harvestLevel) {
            this.harvestLevel = harvestLevel;
            return this;
        }

        public Builder withEnchantability(int enchantability) {
            this.enchantability = enchantability;
            return this;
        }

        public Builder withRepairMaterial(Supplier<Ingredient> repairMaterial) {
            this.repairMaterial = repairMaterial;
            return this;
        }

        public IItemTier build() {
            return new IItemTier(){
                private Ingredient repairMaterial;

                public int func_200926_a() {
                    return maxUses;
                }

                public float func_200928_b() {
                    return efficiency;
                }

                public float func_200929_c() {
                    return attackDamage;
                }

                public int func_200925_d() {
                    return harvestLevel;
                }

                public int func_200927_e() {
                    return enchantability;
                }

                @Nonnull
                public Ingredient func_200924_f() {
                    if (this.repairMaterial == null) {
                        this.repairMaterial = (Ingredient)repairMaterial.get();
                    }
                    return this.repairMaterial;
                }
            };
        }
    }
}

