/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class EntityUtil {
    private static final Map<Class<? extends LivingEntity>, Stance> STANCES = new HashMap<Class<? extends LivingEntity>, Stance>();

    public static void register() {
        EntityUtil.registerStance(SpiderEntity.class, Stance.QUADRUPEDAL);
        EntityUtil.registerStance(CaveSpiderEntity.class, Stance.QUADRUPEDAL);
    }

    public static void registerStance(Class<? extends LivingEntity> entity, Stance stance) {
        STANCES.put(entity, stance);
    }

    public static Stance getStance(LivingEntity entity) {
        Stance registeredStance = STANCES.get(entity.getClass());
        if (registeredStance != null) {
            return registeredStance;
        }
        return EntityUtil.guessStance(entity);
    }

    private static Stance guessStance(LivingEntity entity) {
        if (entity instanceof AnimalEntity) {
            return Stance.QUADRUPEDAL;
        }
        if (entity instanceof MonsterEntity) {
            return Stance.BIPEDAL;
        }
        float height = Math.max(entity.func_213302_cg(), entity.func_70047_e());
        return height > entity.func_213311_cf() ? Stance.BIPEDAL : Stance.QUADRUPEDAL;
    }

    public static boolean isCoveredBy(LivingEntity entity, IArmorMaterial material) {
        for (ItemStack armorStack : entity.func_184193_aE()) {
            if (armorStack.func_190926_b()) {
                return false;
            }
            Item armorItem = armorStack.func_77973_b();
            if (!(armorItem instanceof ArmorItem) || material == ((ArmorItem)armorItem).func_200880_d()) continue;
            return false;
        }
        return true;
    }

    public static enum Stance {
        BIPEDAL,
        QUADRUPEDAL,
        NONE;

    }
}

