/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class LayeredSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private final int minSurfaceLayer;
    private final int maxSurfaceLayer;
    private int maxY = 255;

    public LayeredSurfaceBuilder(Function<Dynamic<?>, ? extends SurfaceBuilderConfig> deserialize, int minSurfaceLayer, int maxSurfaceLayer) {
        super(deserialize);
        this.minSurfaceLayer = minSurfaceLayer;
        this.maxSurfaceLayer = maxSurfaceLayer;
    }

    public LayeredSurfaceBuilder withMaxY(int maxY) {
        this.maxY = maxY;
        return this;
    }

    public void buildSurface(Random random, IChunk chunk, Biome biome, int x, int z, int maxY, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        BlockState top = config.func_204108_a();
        BlockState under = config.func_204109_b();
        BlockState underWater = config.func_204110_c();
        int depth = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        int currentDepth = -1;
        int localX = x & 0xF;
        int localZ = z & 0xF;
        boolean wet = false;
        int surfaceLayer = 0;
        for (int localY = Math.min(this.maxY, maxY); localY >= 0; --localY) {
            BlockPos pos = new BlockPos(localX, localY, localZ);
            BlockState state = chunk.func_180495_p(pos);
            Material material = state.func_185904_a();
            if (material == Material.field_151586_h) {
                wet = true;
            } else if (material == Material.field_151579_a) {
                wet = false;
            }
            if (material != Material.field_151576_e) {
                currentDepth = -1;
                continue;
            }
            if (currentDepth >= depth) {
                wet = false;
                if (surfaceLayer++ <= this.maxSurfaceLayer) continue;
                break;
            }
            ++currentDepth;
            if (surfaceLayer < this.minSurfaceLayer || surfaceLayer > this.maxSurfaceLayer) continue;
            if (currentDepth == 0) {
                chunk.func_177436_a(pos, wet ? underWater : top, false);
                continue;
            }
            chunk.func_177436_a(pos, wet ? underWater : under, false);
        }
    }
}

