/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public abstract class BoulderFeature
extends Feature<NoFeatureConfig> {
    protected BoulderFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> deserialize) {
        super(deserialize);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos origin, NoFeatureConfig config) {
        float baseRadius = this.getRadius(random);
        origin = origin.func_177981_b(MathHelper.func_76141_d((float)(baseRadius / 2.0f)));
        this.generateBlob(world, random, origin, baseRadius);
        for (int i = 0; i < 2; ++i) {
            int offsetX = random.nextInt(5) - 2;
            int offsetY = -random.nextInt(2);
            int offsetZ = random.nextInt(5) - 2;
            BlockPos center = origin.func_177982_a(offsetX, offsetY, offsetZ);
            float radius = baseRadius + random.nextFloat() * 0.5f;
            this.generateBlob(world, random, center, radius);
        }
        return true;
    }

    private void generateBlob(IWorld world, Random random, BlockPos origin, float radius) {
        float radiusSquare = radius * radius;
        int radiusCeil = MathHelper.func_76123_f((float)radius);
        BlockPos minPos = origin.func_177982_a(-radiusCeil, -radiusCeil, -radiusCeil);
        BlockPos maxPos = origin.func_177982_a(radiusCeil, radiusCeil, radiusCeil);
        BlockPos.func_218281_b((BlockPos)minPos, (BlockPos)maxPos).forEach(pos -> {
            double distSquare = pos.func_177951_i((Vec3i)origin);
            if (distSquare <= (double)radiusSquare) {
                this.func_202278_a((IWorldWriter)world, (BlockPos)pos, this.getStateForPlacement(world, origin, (BlockPos)pos, distSquare, radiusSquare, random));
            }
        });
    }

    protected abstract float getRadius(Random var1);

    protected abstract BlockState getStateForPlacement(IWorld var1, BlockPos var2, BlockPos var3, double var4, float var6, Random var7);
}

