/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature.placement;

import com.mojang.datafixers.Dynamic;
import com.mushroom.midnight.common.world.feature.placement.SurfacePlacementLevel;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;

public class DragonNestPlacement
extends Placement<NoPlacementConfig> {
    public DragonNestPlacement(Function<Dynamic<?>, ? extends NoPlacementConfig> deserialize) {
        super(deserialize);
    }

    public Stream<BlockPos> getPositions(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, NoPlacementConfig config, BlockPos origin) {
        int chunkZ;
        int chunkX = origin.func_177958_n() >> 4;
        IChunk chunk = world.func_217348_a(chunkX, chunkZ = origin.func_177952_p() >> 4, ChunkStatus.field_222607_c);
        LongSet references = chunk.func_201578_b("midnight:molten_crater");
        if (references.isEmpty()) {
            return Stream.empty();
        }
        return IntStream.range(0, 64).mapToObj(i -> {
            int z;
            int x = random.nextInt(16);
            int maxY = SurfacePlacementLevel.INSTANCE.getSurfacePos(world, Heightmap.Type.MOTION_BLOCKING, origin.func_177982_a(x, 0, z = random.nextInt(16))).func_177956_o() + 32;
            int y = random.nextInt(maxY);
            if (!SurfacePlacementLevel.INSTANCE.containsY(world, y)) {
                return null;
            }
            return origin.func_177982_a(x, y, z);
        }).filter(Objects::nonNull);
    }
}

