/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature.structure;

import com.mojang.datafixers.Dynamic;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.world.feature.structure.WellPieces;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.ScatteredStructure;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class WellStructure
extends ScatteredStructure<NoFeatureConfig> {
    public static final String NAME = "midnight:well";

    public WellStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> deserializer) {
        super(deserializer);
    }

    protected int func_202382_c() {
        return 499831872;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return NAME;
    }

    public int func_202367_b() {
        return 2;
    }

    public boolean func_225558_a_(BiomeManager biomeMgr, ChunkGenerator<?> chunkGen, Random rand, int cx, int cz, Biome biome) {
        int config = (Integer)MidnightConfig.worldgen.wellStructureRarity.get();
        if (config == 0) {
            return false;
        }
        ChunkPos chunkPos = this.func_211744_a(chunkGen, rand, cx, cz, 0, 0);
        rand.setSeed((long)(chunkPos.field_77276_a ^ chunkPos.field_77275_b << 4) ^ chunkGen.func_202089_c());
        return cx == chunkPos.field_77276_a && cz == chunkPos.field_77275_b && chunkGen.func_202094_a(biome, (Structure)this) && rand.nextInt(config) != 0;
    }

    @Nullable
    public BlockPos func_211405_a(World worldIn, ChunkGenerator<? extends GenerationSettings> chunkGenerator, BlockPos pos, int radius, boolean skipExistingChunks) {
        return null;
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structure, int x, int z, MutableBoundingBox box, int refCount, long seed) {
            super(structure, x, z, box, refCount, seed);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManager, int cx, int cz, Biome biome) {
            int x = cx * 16;
            int z = cz * 16;
            BlockPos blockpos = new BlockPos(x, 90, z);
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            WellPieces.addWellPieces(templateManager, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
        }
    }
}

