/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.rift;

import com.google.common.collect.Lists;
import com.mushroom.midnight.common.block.DoubleMalignantFlowerBlock;
import com.mushroom.midnight.common.block.MossBlock;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.registry.MidnightItems;
import com.mushroom.midnight.common.registry.MidnightSounds;
import com.mushroom.midnight.common.world.noise.INoiseSampler;
import com.mushroom.midnight.common.world.noise.PerlinNoiseSampler;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="midnight")
public class EntranceRiftGenerator {
    private static final INoiseSampler WARP_NOISE = new PerlinNoiseSampler(new Random(8555034668646880878L));
    private static final INoiseSampler SPIRE_WARP_NOISE = new PerlinNoiseSampler(new Random(8555034668646880878L));
    private static final int OUTER_RADIUS = 2;
    private static final double PORTAL_RADIUS = 3.0;
    private static final Direction[] VERTICAL_DIRECTIONS = new Direction[]{Direction.UP, Direction.DOWN};
    private static final Block[] VINES = new Block[]{MidnightBlocks.MALIGNANT_RED_HANGING_VINES, MidnightBlocks.MALIGNANT_RED_BRIDGING_VINES};
    private static final Block[] SHORT_FLOWERS = new Block[]{MidnightBlocks.MALIGNANT_FOXGLOVE, MidnightBlocks.MALIGNANT_HEMLOCK, MidnightBlocks.MALIGNANT_MANDRAKE};
    protected final IWorld world;

    public EntranceRiftGenerator(IWorld world) {
        this.world = world;
        WARP_NOISE.setFrequency(0.1);
        WARP_NOISE.setAmplitude(3.0);
        SPIRE_WARP_NOISE.setFrequency(0.5);
        SPIRE_WARP_NOISE.setAmplitude(0.9);
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickItem event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        event.getPlayer().func_184609_a(event.getHand());
        if (((Boolean)MidnightConfig.logic.riftsFromDarkPearls.get()).booleanValue() && event.getItemStack().func_77973_b() == MidnightItems.DARK_PEARL) {
            Vec3d target;
            PlayerEntity player = event.getPlayer();
            Vec3d lookVec = player.func_70676_i(1.0f);
            Vec3d origin = player.func_174824_e(1.0f);
            BlockRayTraceResult result = world.func_217299_a(new RayTraceContext(origin, target = origin.func_178787_e(lookVec.func_186678_a(64.0)), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                new EntranceRiftGenerator((IWorld)world).generate(result.func_216350_a(), new Random());
                world.func_184133_a(null, result.func_216350_a(), MidnightSounds.EGG_CRACKED, SoundCategory.BLOCKS, 3.0f, 1.0f);
            }
        }
    }

    public void generate(BlockPos origin, Random random) {
        int craterRadius = random.nextInt(3) + 7;
        int radius = craterRadius + 2;
        CoverMask coverMask = new CoverMask(radius + 6);
        this.generateCrater(random, origin, craterRadius, radius, coverMask);
        this.generateTendrils(random, origin, radius, coverMask);
        this.generateSpires(random, origin, (float)craterRadius + 1.5f);
        this.decorateRift(random, origin, radius + 4);
    }

    private void generateCrater(Random random, BlockPos origin, int craterRadius, int radius, CoverMask coverMask) {
        DistanceField distanceField = this.generateDistanceField(origin.func_177958_n(), origin.func_177952_p(), radius + 2);
        int totalDepth = craterRadius / 2;
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int z = -radius; z <= radius; ++z) {
            for (int x = -radius; x <= radius; ++x) {
                mutablePos.func_181079_c(x + origin.func_177958_n(), origin.func_177956_o(), z + origin.func_177952_p());
                float distance = distanceField.get(x, z);
                if (distance > (float)radius) continue;
                int depth = this.computeDepth(distance, craterRadius, totalDepth);
                while (mutablePos.func_177956_o() > origin.func_177956_o() - depth) {
                    this.carveBlock((BlockPos)mutablePos);
                    mutablePos.func_189536_c(Direction.DOWN);
                }
                BlockState surfaceState = this.computeSurfaceState(distance, radius, random);
                mutablePos.func_185336_p(origin.func_177956_o() - depth);
                this.setBlockState((BlockPos)mutablePos, surfaceState);
                if (depth > 0) {
                    for (int y = mutablePos.func_177956_o() + 1; y <= origin.func_177956_o() + 7; ++y) {
                        BlockPos blockPosAboveBlock = mutablePos.func_177982_a(0, y - mutablePos.func_177956_o(), 0);
                        BlockState blockStateAboveBlock = this.world.func_180495_p(blockPosAboveBlock);
                        if (blockStateAboveBlock == MidnightBlocks.RIFT_PORTAL.func_176223_P() || blockStateAboveBlock == MidnightBlocks.GLOWING_MALIGNANT_RED_PLANT_BLOCK.func_176223_P() || blockStateAboveBlock == MidnightBlocks.MALIGNANT_RED_PLANT_BLOCK.func_176223_P() || blockStateAboveBlock == MidnightBlocks.MALIGNANT_BLOODROOT.func_176223_P() || blockStateAboveBlock.func_185904_a() == Material.field_151579_a) continue;
                        this.setBlockState(blockPosAboveBlock, Blocks.field_150350_a.func_176223_P());
                    }
                }
                coverMask.put(x, z);
            }
        }
    }

    private BlockState computeSurfaceState(double distance, double radius, Random random) {
        if (distance < 3.0) {
            return MidnightBlocks.RIFT_PORTAL.func_176223_P();
        }
        double distanceFromEdge = radius - distance;
        double glowChance = distanceFromEdge / radius * 0.5;
        if ((double)random.nextFloat() < glowChance) {
            return MidnightBlocks.GLOWING_MALIGNANT_RED_PLANT_BLOCK.func_176223_P();
        }
        return MidnightBlocks.MALIGNANT_RED_PLANT_BLOCK.func_176223_P();
    }

    private DistanceField generateDistanceField(int originX, int originZ, int radius) {
        DistanceField field = new DistanceField(radius);
        for (int z = -radius; z <= radius; ++z) {
            for (int x = -radius; x <= radius; ++x) {
                int distanceSq = x * x + z * z;
                double warp = WARP_NOISE.get(originX + x, originZ + z);
                double distance = Math.sqrt(distanceSq) + warp;
                field.put(x, z, (float)distance);
            }
        }
        return field;
    }

    private int computeDepth(double distance, int craterRadius, int totalDepth) {
        int depth = MathHelper.func_76143_f((double)((1.0 - distance / (double)craterRadius) * (double)totalDepth));
        depth = MathHelper.func_76125_a((int)depth, (int)0, (int)(totalDepth - 1));
        return depth;
    }

    private void generateTendrils(Random random, BlockPos origin, int radius, CoverMask coverMask) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        float angle = 0.0f;
        float angleStep = 15.0f;
        float distance = (float)radius + 3.0f;
        while (angle < 360.0f - angleStep) {
            double angleRad = Math.toRadians(angle += angleStep);
            int x = MathHelper.func_76128_c((double)(Math.sin(angleRad) * (double)distance));
            int z = MathHelper.func_76128_c((double)(Math.cos(angleRad) * (double)distance));
            x += random.nextInt(3) - random.nextInt(3);
            z += random.nextInt(3) - random.nextInt(3);
            while (!coverMask.has(x, z) && coverMask.contains(x, z)) {
                mutablePos.func_181079_c(origin.func_177958_n() + x, origin.func_177956_o(), origin.func_177952_p() + z);
                this.setBlockState((BlockPos)mutablePos, MidnightBlocks.MALIGNANT_RED_PLANT_BLOCK.func_176223_P());
                coverMask.put(x, z);
                Direction.Axis axis = this.chooseTendrilAxis(random, x, z);
                if (axis == Direction.Axis.X) {
                    x -= MathHelper.func_219802_k((double)x);
                    continue;
                }
                z -= MathHelper.func_219802_k((double)z);
            }
        }
    }

    private Direction.Axis chooseTendrilAxis(Random random, int x, int z) {
        if (x == 0) {
            return Direction.Axis.Z;
        }
        if (z == 0) {
            return Direction.Axis.X;
        }
        return random.nextBoolean() ? Direction.Axis.X : Direction.Axis.Z;
    }

    private void generateSpires(Random random, BlockPos origin, float spireDistance) {
        float angle = random.nextFloat() * 90.0f;
        for (int i = 0; i < 4; ++i) {
            this.generateSpire(random, origin, spireDistance, angle);
            angle += 90.0f;
        }
    }

    private void generateSpire(Random random, BlockPos origin, float spireDistance, float angle) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        double angleRad = Math.toRadians(angle);
        double stepX = Math.sin(angleRad);
        double stepZ = Math.cos(angleRad);
        double x = (double)origin.func_177958_n() + stepX * (double)spireDistance;
        double z = (double)origin.func_177952_p() + stepZ * (double)spireDistance;
        int y = origin.func_177956_o();
        for (float radius = 3.0f + random.nextFloat() * 0.5f; radius >= 1.0f; radius *= 0.835f) {
            int maxRadius = MathHelper.func_76123_f((float)radius);
            for (int layerZ = -maxRadius; layerZ <= maxRadius; ++layerZ) {
                for (int layerX = -maxRadius; layerX <= maxRadius; ++layerX) {
                    mutablePos.func_189532_c(x + (double)layerX, (double)y, z + (double)layerZ);
                    double distance = Math.sqrt(layerX * layerX + layerZ * layerZ);
                    distance += SPIRE_WARP_NOISE.get(mutablePos.func_177958_n(), mutablePos.func_177956_o(), mutablePos.func_177952_p());
                    if (!(distance <= (double)radius)) continue;
                    this.setBlockState((BlockPos)mutablePos, MidnightBlocks.MALIGNANT_RED_PLANT_BLOCK.func_176223_P());
                }
            }
            x -= stepX * (double)(1.5f / radius);
            z -= stepZ * (double)(1.5f / radius);
            ++y;
        }
    }

    private void decorateRift(Random random, BlockPos origin, int radius) {
        Decorator decorator = new Decorator(this.world, origin, random, radius);
        decorator.scatter(32, 16, pos -> {
            for (Direction direction : EntranceRiftGenerator.shuffledDirections(random)) {
                BlockState state = (BlockState)MidnightBlocks.MALIGNANT_RED_PLANT_SURFACE.func_176223_P().func_206870_a((IProperty)MossBlock.FACING, (Comparable)direction);
                if (!state.func_196955_c((IWorldReader)this.world, pos) || this.world.func_180495_p(pos.func_177977_b()).func_177230_c().equals(Blocks.field_201940_ji) && this.world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150357_h)) continue;
                this.setBlockState((BlockPos)pos, state);
                break;
            }
        });
        decorator.scatter(24, 16, pos -> {
            for (Direction direction : EntranceRiftGenerator.shuffledDirections(random)) {
                Block block = SHORT_FLOWERS[random.nextInt(SHORT_FLOWERS.length)];
                BlockState state = block.func_176223_P();
                if (!state.func_196955_c((IWorldReader)this.world, pos)) continue;
                this.setBlockState((BlockPos)pos, state);
                break;
            }
        });
        decorator.scatter(8, 6, pos -> {
            for (Direction direction : VERTICAL_DIRECTIONS) {
                BlockState state = (BlockState)MidnightBlocks.MALIGNANT_BLOODROOT.func_176223_P().func_206870_a((IProperty)DoubleMalignantFlowerBlock.FACING, (Comparable)direction);
                if (!state.func_196955_c((IWorldReader)this.world, pos) || !this.world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150350_a)) continue;
                DoubleMalignantFlowerBlock.placeAt(this.world, pos, state, 2);
                break;
            }
        });
        decorator.scatter(16, 16, pos -> {
            Block block = VINES[random.nextInt(VINES.length)];
            BlockState state = block.func_176223_P();
            if (state.func_196955_c((IWorldReader)this.world, pos)) {
                this.setBlockState((BlockPos)pos, state);
            }
        });
    }

    private void carveBlock(BlockPos pos) {
        if (this.world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        this.setBlockState(pos, Blocks.field_150350_a.func_176223_P());
    }

    private void setBlockState(BlockPos pos, BlockState state) {
        if (this.world.func_180495_p(pos).func_177230_c() == Blocks.field_150357_h) {
            return;
        }
        this.world.func_180501_a(pos, state, 3);
    }

    private static Collection<Direction> shuffledDirections(Random random) {
        ArrayList directions = Lists.newArrayList((Object[])Direction.values());
        Collections.shuffle(directions, random);
        return directions;
    }

    private static class Decorator {
        private final IWorld world;
        private final BlockPos origin;
        private final Random random;
        private final int radius;
        private final BlockPos.Mutable mutablePos = new BlockPos.Mutable();

        private Decorator(IWorld world, BlockPos origin, Random random, int radius) {
            this.world = world;
            this.origin = origin;
            this.random = random;
            this.radius = radius;
        }

        void scatter(int count, int size, Consumer<BlockPos> consumer) {
            for (int i = 0; i < count; ++i) {
                int centerX = this.origin.func_177958_n() + this.random.nextInt(this.radius) - this.random.nextInt(this.radius);
                int centerY = this.origin.func_177956_o() + this.random.nextInt(5) - this.random.nextInt(3);
                int centerZ = this.origin.func_177952_p() + this.random.nextInt(this.radius) - this.random.nextInt(this.radius);
                for (int j = 0; j < size; ++j) {
                    this.mutablePos.func_181079_c(centerX + this.random.nextInt(4) - this.random.nextInt(4), centerY + this.random.nextInt(3) - this.random.nextInt(3), centerZ + this.random.nextInt(4) - this.random.nextInt(4));
                    if (!this.world.func_175623_d((BlockPos)this.mutablePos)) continue;
                    consumer.accept((BlockPos)this.mutablePos);
                }
            }
        }
    }

    private static abstract class CircleField {
        final int radius;
        final int diameter;

        CircleField(int radius) {
            this.radius = radius;
            this.diameter = radius * 2 + 1;
        }

        public boolean contains(int x, int z) {
            return x >= -this.radius && z >= -this.radius && x <= this.radius && z <= this.radius;
        }

        int index(int x, int z) {
            return x + this.radius + (z + this.radius) * this.diameter;
        }
    }

    private static class CoverMask
    extends CircleField {
        private final BitSet bitSet;

        CoverMask(int radius) {
            super(radius);
            this.bitSet = new BitSet(this.diameter * this.diameter);
        }

        void put(int x, int z) {
            if (this.contains(x, z)) {
                this.bitSet.set(this.index(x, z));
            }
        }

        boolean has(int x, int z) {
            if (!this.contains(x, z)) {
                return false;
            }
            return this.bitSet.get(this.index(x, z));
        }
    }

    private static class DistanceField
    extends CircleField {
        private final float[] field;

        DistanceField(int radius) {
            super(radius);
            this.field = new float[this.diameter * this.diameter];
        }

        void put(int x, int z, float distance) {
            if (this.contains(x, z)) {
                this.field[this.index((int)x, (int)z)] = distance;
            }
        }

        float get(int x, int z) {
            if (!this.contains(x, z)) {
                return this.radius;
            }
            return this.field[this.index(x, z)];
        }
    }
}

