/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.ISelectiveVariantTypes;
import its_meow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobPathing;
import its_meow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobPathingWithTypesAirBreathing;
import its_meow.betteranimalsplus.init.ModEntities;
import its_meow.betteranimalsplus.init.ModLootTables;
import java.util.Set;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.DolphinLookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreatheAirGoal;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.BiomeDictionary;

public class EntityWhale
extends EntityWaterMobPathingWithTypesAirBreathing
implements ISelectiveVariantTypes<EntityWaterMobPathing> {
    public int attacksLeft = 0;
    public float lastBodyRotation = 0.0f;

    public EntityWhale(World world) {
        super((EntityType<? extends EntityWaterMobPathingWithTypesAirBreathing>)ModEntities.WHALE.entityType, world);
        this.field_70749_g = new DolphinLookController((MobEntity)this, 10);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new BreatheAirGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new FindWaterGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new WhaleMeleeAttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 10));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]){

            public boolean func_75250_a() {
                return EntityWhale.this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && super.func_75250_a();
            }
        });
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_205212_bc;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_205211_bb;
    }

    private boolean isNarwhal() {
        return "narwhal".equals(this.getVariantNameOrEmpty());
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)(this.isNarwhal() ? this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() : 1.0));
        if (flag) {
            if (!this.isNarwhal()) {
                if (this.attacksLeft > 0) {
                    --this.attacksLeft;
                }
                if (entityIn instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)entityIn;
                    int ticks = 0;
                    if (this.field_70170_p.func_175659_aa() == Difficulty.EASY) {
                        ticks = 50;
                    } else if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                        ticks = 100;
                    } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                        ticks = 140;
                    }
                    player.func_195064_c(new EffectInstance(Effects.field_76421_d, ticks, 1, false, false));
                    player.func_195064_c(new EffectInstance(Effects.field_76431_k, ticks + 40, 1, false, false));
                }
            }
            Vec3d pos = this.func_174791_d();
            Vec3d targetPos = entityIn.func_174791_d();
            ((LivingEntity)entityIn).func_70653_a((Entity)this, this.isNarwhal() ? 0.8f : 2.0f, pos.field_72450_a - targetPos.field_72450_a, pos.field_72449_c - targetPos.field_72449_c);
        }
        return flag;
    }

    @Override
    public String[] getTypesFor(Biome biome, Set<BiomeDictionary.Type> types) {
        if (biome == Biomes.field_203616_V || biome == Biomes.field_203619_Y) {
            return new String[]{"bottlenose", "pilot"};
        }
        if (biome == Biomes.field_203620_Z || biome == Biomes.field_76776_l) {
            return new String[]{"narwhal", "beluga"};
        }
        if (biome == Biomes.field_203618_X || biome == Biomes.field_150575_M || biome == Biomes.field_203617_W) {
            return new String[]{"cuviers", "pilot"};
        }
        return new String[]{"cuviers", "pilot", "false_killer"};
    }

    protected ResourceLocation func_184647_J() {
        return ModLootTables.WHALE;
    }

    @Override
    public EntityTypeContainer<?> getContainer() {
        return ModEntities.WHALE;
    }

    public static class WhaleMeleeAttackGoal
    extends MeleeAttackGoal {
        private EntityWhale whale;

        public WhaleMeleeAttackGoal(EntityWhale whale) {
            super((CreatureEntity)whale, (double)1.2f, true);
            this.whale = whale;
        }

        public void func_75249_e() {
            if (!this.whale.isNarwhal()) {
                this.whale.attacksLeft = 1;
            }
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            return (this.whale.isNarwhal() || this.whale.attacksLeft > 0) && super.func_75253_b();
        }

        protected void func_190102_a(LivingEntity p_190102_1_, double p_190102_2_) {
            if (this.whale.attacksLeft > 0 || this.whale.isNarwhal()) {
                super.func_190102_a(p_190102_1_, p_190102_2_);
            } else {
                this.func_75251_c();
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            if (this.whale.attacksLeft <= 0 && !this.whale.isNarwhal()) {
                this.field_75441_b.func_70624_b(null);
            }
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return this.field_75441_b.func_213311_cf() * this.field_75441_b.func_213311_cf() + attackTarget.func_213311_cf();
        }
    }

    public static class WhaleMoveHelper
    extends MovementController {
        private final EntityWhale whale;

        public WhaleMoveHelper(EntityWhale whale) {
            super((MobEntity)whale);
            this.whale = whale;
        }

        public void func_75641_c() {
            if (this.whale.func_70090_H()) {
                this.whale.func_213317_d(this.whale.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.whale.func_70661_as().func_75500_f()) {
                double d2;
                double d1;
                double d0 = this.field_75646_b - this.whale.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = this.field_75647_c - this.whale.func_226278_cu_()) * d1 + (d2 = this.field_75644_d - this.whale.func_226281_cx_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                } else {
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.whale.field_70761_aq = this.whale.field_70177_z = this.func_75639_a(this.whale.field_70177_z, f, 10.0f);
                    this.whale.field_70759_as = this.whale.field_70177_z;
                    float f1 = (float)(this.field_75645_e * this.whale.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    if (this.whale.func_70090_H()) {
                        this.whale.func_70659_e(f1 * 0.02f);
                        float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
                        f2 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f2), (float)-85.0f, (float)85.0f);
                        this.whale.field_70125_A = this.func_75639_a(this.whale.field_70125_A, f2, 5.0f);
                        float f3 = MathHelper.func_76134_b((float)(this.whale.field_70125_A * ((float)Math.PI / 180)));
                        float f4 = MathHelper.func_76126_a((float)(this.whale.field_70125_A * ((float)Math.PI / 180)));
                        this.whale.field_191988_bg = f3 * f1;
                        this.whale.field_70701_bs = -f4 * f1;
                    } else {
                        this.whale.func_70659_e(f1 * 0.1f);
                    }
                }
            } else {
                this.whale.func_70659_e(0.0f);
                this.whale.func_184646_p(0.0f);
                this.whale.func_70657_f(0.0f);
                this.whale.func_191989_p(0.0f);
            }
        }
    }
}

