/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.card;

import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.util.Card;
import net.minecraft.nbt.CompoundNBT;

public class LogicCardWhite
extends LogicBase {
    public boolean[] hold = new boolean[5];
    public Card[] cards_field = new Card[5];
    private int ticker = 0;
    private int movestate = 0;

    public LogicCardWhite(int table) {
        super(table);
    }

    @Override
    public void start2() {
        for (int i = 0; i < 5; ++i) {
            this.cards_field[i] = new Card(this.RANDOM, 0, 20 + 5 * i);
            this.hold[i] = false;
        }
        this.ticker = 0;
        this.movestate = 0;
    }

    @Override
    public void command(int action) {
        if (action == 5 && this.turnstate == 2) {
            this.turnstate = 3;
            this.movestate = 1;
            for (int i = 0; i < 5; ++i) {
                if (this.hold[i]) continue;
                this.cards_field[i].hidden = !this.cards_field[i].hidden;
            }
        } else {
            this.hold[action] = !this.hold[action];
        }
    }

    @Override
    public void updateMotion() {
        if (this.turnstate == 2) {
            for (int i = 0; i < 5; ++i) {
                this.cards_field[i].update();
            }
        }
    }

    @Override
    public void updateLogic() {
        switch (this.movestate) {
            case 0: {
                break;
            }
            case 1: {
                int i;
                this.ticker += 2;
                for (i = 0; i < 5; ++i) {
                    if (this.hold[i]) continue;
                    this.cards_field[i].shiftY -= 2;
                }
                if (this.ticker < 30) break;
                for (i = 0; i < 5; ++i) {
                    if (this.hold[i]) continue;
                    int sX = this.cards_field[i].shiftX;
                    int sY = this.cards_field[i].shiftY;
                    this.cards_field[i] = new Card(this.RANDOM.nextInt(13), this.RANDOM.nextInt(4), sX, sY);
                }
                this.movestate = 2;
                break;
            }
            case 2: {
                this.ticker -= 2;
                for (int i = 0; i < 5; ++i) {
                    if (this.hold[i]) continue;
                    this.cards_field[i].shiftY += 2;
                }
                if (this.ticker > 0) break;
                this.movestate = 3;
                break;
            }
            case 3: {
                this.ticker += 2;
                this.cards_field[0].shiftX += 4;
                this.cards_field[1].shiftX += 2;
                this.cards_field[3].shiftX -= 2;
                this.cards_field[4].shiftX -= 4;
                if (this.ticker != 44) break;
                this.sort();
                this.movestate = 4;
                break;
            }
            case 4: {
                this.ticker -= 2;
                this.cards_field[0].shiftX -= 4;
                this.cards_field[1].shiftX -= 2;
                this.cards_field[3].shiftX += 2;
                this.cards_field[4].shiftX += 4;
                if (this.ticker != 0) break;
                this.result();
                this.turnstate = 4;
                this.movestate = 0;
            }
        }
    }

    @Override
    public void load2(CompoundNBT compound) {
        this.cards_field = this.loadCardArray(compound, 0);
        this.hold[0] = compound.func_74767_n("hold0");
        this.hold[1] = compound.func_74767_n("hold1");
        this.hold[2] = compound.func_74767_n("hold2");
        this.hold[3] = compound.func_74767_n("hold3");
        this.hold[4] = compound.func_74767_n("hold4");
        this.ticker = compound.func_74762_e("ticker");
        this.movestate = compound.func_74762_e("movestate");
    }

    @Override
    public CompoundNBT save2(CompoundNBT compound) {
        this.saveCardArray(compound, 0, this.cards_field);
        compound.func_74757_a("hold0", this.hold[0]);
        compound.func_74757_a("hold1", this.hold[1]);
        compound.func_74757_a("hold2", this.hold[2]);
        compound.func_74757_a("hold3", this.hold[3]);
        compound.func_74757_a("hold4", this.hold[4]);
        compound.func_74768_a("ticker", this.ticker);
        compound.func_74768_a("movestate", this.movestate);
        return compound;
    }

    private void sort() {
        Card[] card = new Card[]{this.cards_field[0], this.cards_field[1], this.cards_field[2], this.cards_field[3], this.cards_field[4]};
        Card z = new Card(-1, -1);
        if (card[0].sortedNumber() > card[4].sortedNumber()) {
            z.set(card[0]);
            card[0].set(card[1]);
            card[1].set(card[2]);
            card[2].set(card[3]);
            card[3].set(card[4]);
            card[4].set(z);
        }
        if (card[0].sortedNumber() > card[3].sortedNumber()) {
            z.set(card[0]);
            card[0].set(card[1]);
            card[1].set(card[2]);
            card[2].set(card[3]);
            card[3].set(z);
        }
        if (card[0].sortedNumber() > card[2].sortedNumber()) {
            z.set(card[0]);
            card[0].set(card[1]);
            card[1].set(card[2]);
            card[2].set(z);
        }
        if (card[0].sortedNumber() > card[1].sortedNumber()) {
            z.set(card[0]);
            card[0].set(card[1]);
            card[1].set(z);
        }
        if (card[1].sortedNumber() > card[4].sortedNumber()) {
            z.set(card[1]);
            card[1].set(card[2]);
            card[2].set(card[3]);
            card[3].set(card[4]);
            card[4].set(z);
        }
        if (card[1].sortedNumber() > card[3].sortedNumber()) {
            z.set(card[1]);
            card[1].set(card[2]);
            card[2].set(card[3]);
            card[3].set(z);
        }
        if (card[1].sortedNumber() > card[2].sortedNumber()) {
            z.set(card[1]);
            card[1].set(card[2]);
            card[2].set(z);
        }
        if (card[2].sortedNumber() > card[4].sortedNumber()) {
            z.set(card[2]);
            card[2].set(card[3]);
            card[3].set(card[4]);
            card[4].set(z);
        }
        if (card[2].sortedNumber() > card[3].sortedNumber()) {
            z.set(card[2]);
            card[2].set(card[3]);
            card[3].set(z);
        }
        if (card[3].sortedNumber() > card[4].sortedNumber()) {
            z.set(card[3]);
            card[3].set(card[4]);
            card[4].set(z);
        }
        this.cards_field[0].set(card[0]);
        this.cards_field[1].set(card[1]);
        this.cards_field[2].set(card[2]);
        this.cards_field[3].set(card[3]);
        this.cards_field[4].set(card[4]);
        this.cards_field[0].shiftX = 88;
        this.cards_field[1].shiftX = 44;
        this.cards_field[2].shiftX = 0;
        this.cards_field[3].shiftX = -44;
        this.cards_field[4].shiftX = -88;
    }

    private void result() {
        if (this.cards_field[0].number == this.cards_field[1].number && this.cards_field[0].number == this.cards_field[2].number && this.cards_field[0].number == this.cards_field[3].number && this.cards_field[0].number == this.cards_field[4].number) {
            this.hand = "5 of a Kind";
            this.reward[0] = 20;
        } else if (this.cards_field[0].number == 9 && this.cards_field[1].number == 10 && this.cards_field[2].number == 11 && this.cards_field[3].number == 12 && this.cards_field[4].number == 0 && this.cards_field[0].suit == this.cards_field[1].suit && this.cards_field[0].suit == this.cards_field[2].suit && this.cards_field[0].suit == this.cards_field[3].suit && this.cards_field[0].suit == this.cards_field[4].suit) {
            this.hand = "ROYAL FLUSH!!";
            this.reward[0] = 16;
        } else if (this.cards_field[0].number <= 9 && this.cards_field[0].number + 1 == this.cards_field[1].number && this.cards_field[0].number + 2 == this.cards_field[2].number && this.cards_field[0].number + 3 == this.cards_field[3].number && this.cards_field[0].number + 4 == this.cards_field[4].number && this.cards_field[0].suit == this.cards_field[1].suit && this.cards_field[0].suit == this.cards_field[2].suit && this.cards_field[0].suit == this.cards_field[3].suit && this.cards_field[0].suit == this.cards_field[4].suit) {
            this.hand = "Straight Flush";
            this.reward[0] = 12;
        } else if (this.cards_field[0].number == this.cards_field[1].number && this.cards_field[0].number == this.cards_field[2].number && this.cards_field[0].number == this.cards_field[3].number && this.cards_field[0].number != this.cards_field[4].number) {
            this.hand = "4 of a Kind";
            this.reward[0] = 10;
        } else if (this.cards_field[1].number == this.cards_field[2].number && this.cards_field[1].number == this.cards_field[3].number && this.cards_field[1].number == this.cards_field[4].number && this.cards_field[1].number != this.cards_field[0].number) {
            this.hand = "4 of a Kind";
            this.reward[0] = 10;
        } else if (this.cards_field[0].number == this.cards_field[1].number && this.cards_field[0].number == this.cards_field[2].number && this.cards_field[0].number != this.cards_field[3].number && this.cards_field[3].number == this.cards_field[4].number) {
            this.hand = "Full House";
            this.reward[0] = 8;
        } else if (this.cards_field[0].number == this.cards_field[1].number && this.cards_field[0].number != this.cards_field[2].number && this.cards_field[2].number == this.cards_field[3].number && this.cards_field[2].number == this.cards_field[4].number) {
            this.hand = "Full House";
            this.reward[0] = 8;
        } else if (this.cards_field[0].suit == this.cards_field[1].suit && this.cards_field[0].suit == this.cards_field[2].suit && this.cards_field[0].suit == this.cards_field[3].suit && this.cards_field[0].suit == this.cards_field[4].suit) {
            this.hand = "Flush";
            this.reward[0] = 7;
        } else if (this.cards_field[0].number <= 9 && this.cards_field[0].number + 1 == this.cards_field[1].number && this.cards_field[0].number + 2 == this.cards_field[2].number && this.cards_field[0].number + 3 == this.cards_field[3].number && this.cards_field[0].number + 4 == this.cards_field[4].number) {
            this.hand = "Straight";
            this.reward[0] = 6;
        } else if (this.cards_field[0].number == this.cards_field[1].number && this.cards_field[0].number == this.cards_field[2].number && this.cards_field[0].number != this.cards_field[3].number && this.cards_field[0].number != this.cards_field[4].number) {
            this.hand = "3 of a Kind";
            this.reward[0] = 4;
        } else if (this.cards_field[1].number == this.cards_field[2].number && this.cards_field[1].number == this.cards_field[3].number && this.cards_field[1].number != this.cards_field[0].number && this.cards_field[1].number != this.cards_field[4].number) {
            this.hand = "3 of a Kind";
            this.reward[0] = 4;
        } else if (this.cards_field[2].number == this.cards_field[3].number && this.cards_field[2].number == this.cards_field[4].number && this.cards_field[2].number != this.cards_field[0].number && this.cards_field[2].number != this.cards_field[1].number) {
            this.hand = "3 of a Kind";
            this.reward[0] = 4;
        } else if (this.cards_field[0].number == this.cards_field[1].number && this.cards_field[2].number == this.cards_field[3].number) {
            this.hand = "Two Pair";
            this.reward[0] = 2;
        } else if (this.cards_field[0].number == this.cards_field[1].number && this.cards_field[3].number == this.cards_field[4].number) {
            this.hand = "Two Pair";
            this.reward[0] = 2;
        } else if (this.cards_field[1].number == this.cards_field[2].number && this.cards_field[3].number == this.cards_field[4].number) {
            this.hand = "Two Pair";
            this.reward[0] = 2;
        } else if ((this.cards_field[0].number >= 10 || this.cards_field[0].number == 0) && this.cards_field[0].number == this.cards_field[1].number) {
            this.hand = "Jacks or Better";
            this.reward[0] = 1;
        } else if ((this.cards_field[1].number >= 10 || this.cards_field[1].number == 0) && this.cards_field[1].number == this.cards_field[2].number) {
            this.hand = "Jacks or Better";
            this.reward[0] = 1;
        } else if ((this.cards_field[2].number >= 10 || this.cards_field[2].number == 0) && this.cards_field[2].number == this.cards_field[3].number) {
            this.hand = "Jacks or Better";
            this.reward[0] = 1;
        } else if ((this.cards_field[3].number >= 10 || this.cards_field[3].number == 0) && this.cards_field[3].number == this.cards_field[4].number) {
            this.hand = "Jacks or Better";
            this.reward[0] = 1;
        }
    }

    @Override
    public boolean hasHighscore() {
        return false;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 14;
    }
}

