/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.network;

import java.util.function.Supplier;
import mod.casinocraft.tileentities.TileEntityBoard;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageBoardClient {
    final int betLow;
    final int betHigh;
    final boolean transferIn;
    final boolean transferOut;
    final boolean isCreative;
    final int x;
    final int y;
    final int z;

    public MessageBoardClient(int bet_low, int bet_high, boolean transfer_in, boolean transfer_out, boolean is_creative, BlockPos pos) {
        this.betLow = bet_low;
        this.betHigh = bet_high;
        this.transferIn = transfer_in;
        this.transferOut = transfer_out;
        this.isCreative = is_creative;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public static void encode(MessageBoardClient msg, PacketBuffer buf) {
        buf.writeInt(msg.betLow);
        buf.writeInt(msg.betHigh);
        buf.writeBoolean(msg.transferIn);
        buf.writeBoolean(msg.transferOut);
        buf.writeBoolean(msg.isCreative);
        buf.writeInt(msg.x);
        buf.writeInt(msg.y);
        buf.writeInt(msg.z);
    }

    public static MessageBoardClient decode(PacketBuffer buf) {
        int _betLow = buf.readInt();
        int _betHigh = buf.readInt();
        boolean _transferIn = buf.readBoolean();
        boolean _transferOut = buf.readBoolean();
        boolean _isCreative = buf.readBoolean();
        int _x = buf.readInt();
        int _y = buf.readInt();
        int _z = buf.readInt();
        return new MessageBoardClient(_betLow, _betHigh, _transferIn, _transferOut, _isCreative, new BlockPos(_x, _y, _z));
    }

    public static class Handler {
        public static void handle(MessageBoardClient message, Supplier<NetworkEvent.Context> context) {
            BlockPos pos = new BlockPos(message.x, message.y, message.z);
            TileEntityBoard te = (TileEntityBoard)Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
            context.get().enqueueWork(() -> {
                te.bet_low = message.betLow;
                te.bet_high = message.betHigh;
                te.transfer_in = message.transferIn;
                te.transfer_out = message.transferOut;
                te.isCreative = message.isCreative;
            });
            context.get().setPacketHandled(true);
        }
    }
}

