/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.mgui.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;

public class GuiElement
extends AbstractGui {
    protected int x;
    protected int y;
    protected GuiAttachment attachmentPoint = GuiAttachment.topLeft;
    protected GuiAttachment attachmentAnchor = GuiAttachment.topLeft;
    protected int width;
    protected int height;
    protected float opacity = 1.0f;
    protected boolean hasFocus = false;
    protected boolean isVisible = true;
    protected boolean shouldRemove = false;
    protected ArrayList<GuiElement> elements;
    protected Set<KeyframeAnimation> activeAnimations;

    public GuiElement(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.elements = new ArrayList();
        this.activeAnimations = new HashSet<KeyframeAnimation>();
    }

    public void draw(MatrixStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        this.calculateFocusState(refX, refY, mouseX, mouseY);
        this.drawChildren(matrixStack, refX + this.x, refY + this.y, screenWidth, screenHeight, mouseX, mouseY, opacity * this.opacity);
    }

    public void updateAnimations() {
        this.activeAnimations.removeIf(keyframeAnimation -> !keyframeAnimation.isActive());
        this.activeAnimations.forEach(KeyframeAnimation::preDraw);
    }

    protected void drawChildren(MatrixStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        this.elements.removeIf(GuiElement::shouldRemove);
        this.elements.stream().filter(GuiElement::isVisible).forEach(element -> {
            element.updateAnimations();
            element.draw(matrixStack, refX + GuiElement.getXOffset(this, element.attachmentAnchor) - GuiElement.getXOffset(element, element.attachmentPoint), refY + GuiElement.getYOffset(this, element.attachmentAnchor) - GuiElement.getYOffset(element, element.attachmentPoint), screenWidth, screenHeight, mouseX, mouseY, opacity);
        });
    }

    protected static int getXOffset(GuiElement element, GuiAttachment attachment) {
        switch (attachment) {
            case topLeft: 
            case middleLeft: 
            case bottomLeft: {
                return 0;
            }
            case topCenter: 
            case middleCenter: 
            case bottomCenter: {
                return element.getWidth() / 2;
            }
            case topRight: 
            case middleRight: 
            case bottomRight: {
                return element.getWidth();
            }
        }
        return 0;
    }

    protected static int getYOffset(GuiElement element, GuiAttachment attachment) {
        switch (attachment) {
            case topLeft: 
            case topCenter: 
            case topRight: {
                return 0;
            }
            case middleLeft: 
            case middleCenter: 
            case middleRight: {
                return element.getHeight() / 2;
            }
            case bottomLeft: 
            case bottomCenter: 
            case bottomRight: {
                return element.getHeight();
            }
        }
        return 0;
    }

    public boolean onClick(int x, int y) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (!this.elements.get(i).isVisible() || !this.elements.get(i).onClick(x, y)) continue;
            return true;
        }
        return false;
    }

    public void mouseReleased(int x, int y) {
        this.elements.forEach(element -> element.mouseReleased(x, y));
    }

    protected void calculateFocusState(int refX, int refY, int mouseX, int mouseY) {
        boolean gainFocus;
        boolean bl = gainFocus = mouseX >= this.getX() + refX && mouseX < this.getX() + refX + this.getWidth() && mouseY >= this.getY() + refY && mouseY < this.getY() + refY + this.getHeight();
        if (gainFocus != this.hasFocus) {
            this.hasFocus = gainFocus;
            if (this.hasFocus) {
                this.onFocus();
            } else {
                this.onBlur();
            }
        }
    }

    protected void onFocus() {
    }

    protected void onBlur() {
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public GuiElement setAttachmentPoint(GuiAttachment attachment) {
        this.attachmentPoint = attachment;
        return this;
    }

    public GuiElement setAttachmentAnchor(GuiAttachment attachment) {
        this.attachmentAnchor = attachment;
        return this;
    }

    public GuiElement setAttachment(GuiAttachment attachment) {
        this.attachmentPoint = attachment;
        this.attachmentAnchor = attachment;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setVisible(boolean visible) {
        if (this.isVisible != visible) {
            if (visible) {
                this.onShow();
            } else if (!this.onHide()) {
                return;
            }
            this.isVisible = visible;
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    protected void onShow() {
    }

    protected boolean onHide() {
        this.hasFocus = false;
        return true;
    }

    public GuiElement setOpacity(float opacity) {
        this.opacity = opacity;
        return this;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void addAnimation(KeyframeAnimation animation) {
        this.activeAnimations.add(animation);
    }

    public void removeAnimation(KeyframeAnimation animation) {
        this.activeAnimations.remove(animation);
    }

    public void remove() {
        this.shouldRemove = true;
    }

    public boolean shouldRemove() {
        return this.shouldRemove;
    }

    public void addChild(GuiElement child) {
        this.elements.add(child);
    }

    public void clearChildren() {
        this.elements.clear();
    }

    public int getNumChildren() {
        return this.elements.size();
    }

    public GuiElement getChild(int index) {
        if (index >= 0 && index < this.elements.size()) {
            return this.elements.get(index);
        }
        return null;
    }

    public List<GuiElement> getChildren() {
        return Collections.unmodifiableList(this.elements);
    }

    public <T> List<T> getChildren(Class<T> type) {
        return this.elements.stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }

    public List<String> getTooltipLines() {
        if (this.isVisible()) {
            return this.elements.stream().map(GuiElement::getTooltipLines).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    protected static void drawRect(MatrixStack matrixStack, int left, int top, int right, int bottom, int color, float opacity) {
        GuiElement.fill((Matrix4f)matrixStack.func_227866_c_().func_227870_a_(), (int)left, (int)top, (int)right, (int)bottom, (int)GuiElement.colorWithOpacity(color, opacity));
    }

    protected static void drawTexture(MatrixStack matrixStack, ResourceLocation textureLocation, int x, int y, int width, int height, int u, int v, int color, float opacity) {
        RenderSystem.pushMatrix();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(textureLocation);
        RenderSystem.color4f((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)opacity);
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), (float)x, (float)(y + height), 0.0f).func_225583_a_((float)u / 256.0f, (float)(v + height) / 256.0f).func_181675_d();
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), (float)(x + width), (float)(y + height), 0.0f).func_225583_a_((float)(u + width) / 256.0f, (float)(v + height) / 256.0f).func_181675_d();
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), (float)(x + width), (float)y, 0.0f).func_225583_a_((float)(u + width) / 256.0f, (float)v / 256.0f).func_181675_d();
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), (float)x, (float)y, 0.0f).func_225583_a_((float)u / 256.0f, (float)v / 256.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.popMatrix();
    }

    protected static int colorWithOpacity(int color, float opacity) {
        return GuiElement.colorWithOpacity(color, Math.round(opacity * 255.0f));
    }

    protected static int colorWithOpacity(int color, int opacity) {
        return color & 0xFFFFFF | opacity * (color >> 24 == 0 ? 255 : color >> 24 & 0xFF) / 255 << 24;
    }
}

