/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.tile;

import codechicken.enderstorage.config.EnderStorageConfig;
import codechicken.enderstorage.init.ModContent;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.misc.EnderDyeButton;
import codechicken.enderstorage.storage.EnderItemStorage;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEnderChest
extends TileFrequencyOwner {
    public double a_lidAngle;
    public double b_lidAngle;
    public int c_numOpen;
    public int rotation;
    private LazyOptional<IItemHandler> itemHandler = LazyOptional.empty();
    public static EnderDyeButton[] buttons = new EnderDyeButton[3];

    public TileEnderChest() {
        super(ModContent.tileEnderChestType);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!(this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 20L != 0L && this.c_numOpen == this.getStorage().getNumOpen())) {
            this.c_numOpen = this.getStorage().getNumOpen();
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 1, this.c_numOpen);
            this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
        this.b_lidAngle = this.a_lidAngle;
        this.a_lidAngle = MathHelper.approachLinear((double)this.a_lidAngle, (double)(this.c_numOpen > 0 ? 1.0 : 0.0), (double)0.1);
        if (this.b_lidAngle >= 0.5 && this.a_lidAngle < 0.5) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), EnderStorageConfig.useVanillaEnderChestSounds ? SoundEvents.field_187519_aI : SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        } else if (this.b_lidAngle == 0.0 && this.a_lidAngle > 0.0) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), EnderStorageConfig.useVanillaEnderChestSounds ? SoundEvents.field_187520_aJ : SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.c_numOpen = type;
            return true;
        }
        return false;
    }

    public double getRadianLidAngle(float frame) {
        double a = MathHelper.interpolate((double)this.b_lidAngle, (double)this.a_lidAngle, (double)frame);
        a = 1.0 - a;
        a = 1.0 - a * a * a;
        return a * 3.141593 * -0.5;
    }

    @Override
    public EnderItemStorage getStorage() {
        return EnderStorageManager.instance(this.field_145850_b.field_72995_K).getStorage(this.frequency, EnderItemStorage.TYPE);
    }

    @Override
    public void onFrequencySet() {
        this.itemHandler.invalidate();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this.getStorage()));
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.itemHandler.invalidate();
    }

    @Override
    public void writeToPacket(MCDataOutput packet) {
        super.writeToPacket(packet);
        packet.writeByte(this.rotation);
    }

    @Override
    public void readFromPacket(MCDataInput packet) {
        super.readFromPacket(packet);
        this.rotation = packet.readUByte() & 3;
    }

    @Override
    public void onPlaced(LivingEntity entity) {
        this.rotation = entity != null ? (int)Math.floor((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5) & 3 : 0;
        this.onFrequencySet();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("rot", (byte)this.rotation);
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.rotation = tag.func_74771_c("rot") & 3;
    }

    @Override
    public boolean activate(PlayerEntity player, int subHit, Hand hand) {
        this.getStorage().openContainer((ServerPlayerEntity)player, (ITextComponent)new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a(), new Object[0]));
        return true;
    }

    @Override
    public boolean rotate() {
        if (!this.field_145850_b.field_72995_K) {
            this.rotation = (this.rotation + 1) % 4;
            PacketCustom.sendToChunk((IPacket)this.func_189518_D_(), (World)this.field_145850_b, (int)(this.field_174879_c.func_177958_n() >> 4), (int)(this.field_174879_c.func_177952_p() >> 4));
        }
        return true;
    }

    @Override
    public int comparatorInput() {
        return (Integer)this.itemHandler.map(ItemHandlerHelper::calcRedstoneFromInventory).orElse((Object)0);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    static {
        for (int i = 0; i < 3; ++i) {
            TileEnderChest.buttons[i] = new EnderDyeButton(i);
        }
    }
}

