/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.ruins.common;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class RuinVennCriterion {
    private static final Logger LOGGER = LogManager.getLogger();
    private Node root_node_;

    public static RuinVennCriterion parseExpression(@Nonnull String expression, boolean strict_validation, @Nonnull Collection<String> valid_elements) {
        Objects.requireNonNull(expression, "'expression' must not be null");
        Objects.requireNonNull(valid_elements, "'valid_elements' must not be null");
        return new ExpressionParser().parse(expression, strict_validation, valid_elements);
    }

    public static RuinVennCriterion parseExpression(@Nonnull String expression) {
        Objects.requireNonNull(expression, "'expression' must not be null");
        return new ExpressionParser().parse(expression, false, null);
    }

    public boolean isSatisfiedBy(@Nonnull Collection<String> elements) {
        Objects.requireNonNull(elements, "'elements' must not be null");
        return this.root_node_ != null && this.root_node_.isSatisfiedBy(elements);
    }

    public boolean isSatisfiedBy(@Nonnull String element) {
        Objects.requireNonNull(element, "'element' must not be null");
        HashSet<String> elements = new HashSet<String>();
        elements.add(element);
        return this.isSatisfiedBy(elements);
    }

    public boolean isEmpty() {
        return this.root_node_ == null;
    }

    private RuinVennCriterion(Node root_node) {
        this.root_node_ = root_node;
    }

    private static class ExpressionParser {
        private Deque<Node> nodes_ = new ArrayDeque<Node>();
        private Deque<Operator> operators_ = new ArrayDeque<Operator>();
        private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s*+(?:#.*+)?+");
        private static final Pattern ELEMENT_PATTERN = Pattern.compile("(?:(\\w++)|\"((?:[^\\\\\"]++|\\\\[tbnrf'\"\\\\])*+)\")");
        private static final Pattern OPERATOR_PATTERN = Pattern.compile("([(),+-])");

        public RuinVennCriterion parse(String expression, boolean strict_validation, Collection<String> valid_elements) {
            Object operator;
            LOGGER.debug("parsing Venn criterion expression '{}'", (Object)expression);
            if (valid_elements != null) {
                LOGGER.debug("strict element validation enforcement '{}'", (Object)strict_validation);
                LOGGER.debug("element validation against collection '{}'", valid_elements);
            } else {
                LOGGER.debug("no element validation");
            }
            Node root_node = null;
            LOGGER.debug("starting expression parser state machine");
            State state = State.EXPECT_ELEMENT;
            Matcher matcher = WHITESPACE_PATTERN.matcher(expression);
            int start = 0;
            int end = expression.length();
            boolean warning_throttle = false;
            matcher.region(start, end).lookingAt();
            while ((start = matcher.end()) < end) {
                LOGGER.debug("looking for next expression field in state '{}' at index {}", (Object)state, (Object)matcher.start());
                block0 : switch (state) {
                    case EXPECT_ELEMENT: {
                        if (matcher.region(start, end).usePattern(ELEMENT_PATTERN).lookingAt()) {
                            start = matcher.end();
                            String element = matcher.group(1) != null ? matcher.group(1) : ExpressionParser.unescape(matcher.group(2));
                            LOGGER.debug("encountered element '{}'", (Object)element);
                            if (valid_elements != null && !valid_elements.contains(element)) {
                                if (strict_validation) {
                                    throw new RuntimeException(String.format("invalid element '%s' encountered", element));
                                }
                                if (!warning_throttle) {
                                    LOGGER.warn("invalid element '{}' encountered in criterion expression '{}'", (Object)element, (Object)expression);
                                    warning_throttle = true;
                                }
                            }
                            LOGGER.debug("pushing element '{}' onto node stack", (Object)element);
                            this.nodes_.push(new ElementNode(element));
                            state = State.EXPECT_OPERATOR;
                            break;
                        }
                        if (matcher.region(start, end).usePattern(OPERATOR_PATTERN).lookingAt()) {
                            start = matcher.end();
                            operator = matcher.group(1);
                            LOGGER.debug("encountered operator symbol '{}'", operator);
                            switch (operator) {
                                case "+": {
                                    LOGGER.debug("ignoring unary + operator symbol (no-op)");
                                    break block0;
                                }
                                case "-": {
                                    this.pushOperator(Operator.ABSOLUTE_COMPLEMENT);
                                    break block0;
                                }
                                case "(": {
                                    LOGGER.debug("pushing subexpression onto operator stack");
                                    this.operators_.push(Operator.SUBEXPRESSION_START);
                                    break block0;
                                }
                            }
                            throw new RuntimeException(String.format("element expected, invalid operator '%s' encountered", operator));
                        }
                        throw new RuntimeException("element expected, unrecognized characters encountered");
                    }
                    case EXPECT_OPERATOR: {
                        if (matcher.region(start, end).usePattern(OPERATOR_PATTERN).lookingAt()) {
                            start = matcher.end();
                            operator = matcher.group(1);
                            LOGGER.debug("encountered operator symbol '{}'", operator);
                            switch (operator) {
                                case ",": {
                                    this.pushOperator(Operator.UNION);
                                    state = State.EXPECT_ELEMENT;
                                    break block0;
                                }
                                case "+": {
                                    this.pushOperator(Operator.INTERSECTION);
                                    state = State.EXPECT_ELEMENT;
                                    break block0;
                                }
                                case "-": {
                                    this.pushOperator(Operator.RELATIVE_COMPLEMENT);
                                    state = State.EXPECT_ELEMENT;
                                    break block0;
                                }
                                case ")": {
                                    LOGGER.debug("popping subexpression from operator stack");
                                    while (!this.operators_.isEmpty() && this.operators_.peek() != Operator.SUBEXPRESSION_START) {
                                        this.processOperator(this.operators_.pop());
                                    }
                                    if (this.operators_.isEmpty()) {
                                        throw new RuntimeException("unbalanced right parenthesis in expression");
                                    }
                                    this.operators_.pop();
                                    break block0;
                                }
                            }
                            throw new RuntimeException(String.format("invalid operator '%s' encountered", operator));
                        }
                        throw new RuntimeException("operator expected, unrecognized characters encountered");
                    }
                    default: {
                        throw new AssertionError((Object)String.format("unrecognized parser state '%s'", new Object[]{state}));
                    }
                }
                matcher.region(start, end).usePattern(WHITESPACE_PATTERN).lookingAt();
            }
            LOGGER.debug("end of expression encountered while in state '{}'", (Object)state);
            switch (state) {
                case EXPECT_ELEMENT: {
                    if (!this.nodes_.isEmpty() || !this.operators_.isEmpty()) {
                        throw new RuntimeException("expression incomplete");
                    }
                    LOGGER.debug("creating degenerate (empty) criteron object");
                    break;
                }
                case EXPECT_OPERATOR: {
                    LOGGER.debug("popping all operators from stack");
                    while (!this.operators_.isEmpty()) {
                        operator = this.operators_.pop();
                        if (operator == Operator.SUBEXPRESSION_START) {
                            throw new RuntimeException("unbalanced left parenthesis in expression");
                        }
                        this.processOperator((Operator)((Object)operator));
                    }
                    if (this.nodes_.isEmpty()) {
                        throw new AssertionError((Object)"no nodes remaining on final stack");
                    }
                    if (this.nodes_.size() > 1) {
                        throw new AssertionError((Object)"unresolved nodes remaining on final stack");
                    }
                    LOGGER.debug("creating criteron object from fully resolved node tree");
                    root_node = this.nodes_.pop();
                    break;
                }
                default: {
                    throw new AssertionError((Object)String.format("unrecognized parser end state '%s'", new Object[]{state}));
                }
            }
            return new RuinVennCriterion(root_node);
        }

        private void pushOperator(Operator operator) {
            LOGGER.debug("pushing operator '{}' onto operator stack", (Object)operator);
            while (!this.operators_.isEmpty() && this.operators_.peek().precedes(operator)) {
                LOGGER.debug("removing higher precedence operator from stack");
                this.processOperator(this.operators_.pop());
            }
            this.operators_.push(operator);
        }

        private void processOperator(Operator operator) {
            LOGGER.debug("processing operator '{}'", (Object)operator);
            switch (operator) {
                case ABSOLUTE_COMPLEMENT: {
                    if (this.nodes_.size() < 1) {
                        throw new AssertionError((Object)String.format("insufficient operands for unary operator '%s'", operator.toString()));
                    }
                    Node node = this.nodes_.pop();
                    this.nodes_.push(new ComplementNode(node));
                    break;
                }
                case INTERSECTION: {
                    if (this.nodes_.size() < 2) {
                        throw new AssertionError((Object)String.format("insufficient operands for binary operator '%s'", operator.toString()));
                    }
                    Node right_node = this.nodes_.pop();
                    Node left_node = this.nodes_.pop();
                    this.nodes_.push(new IntersectionNode(left_node, right_node));
                    break;
                }
                case RELATIVE_COMPLEMENT: {
                    if (this.nodes_.size() < 2) {
                        throw new AssertionError((Object)String.format("insufficient operands for binary operator '%s'", operator.toString()));
                    }
                    Node right_node = this.nodes_.pop();
                    Node left_node = this.nodes_.pop();
                    this.nodes_.push(new IntersectionNode(left_node, new ComplementNode(right_node)));
                    break;
                }
                case UNION: {
                    if (this.nodes_.size() < 2) {
                        throw new AssertionError((Object)String.format("insufficient operands for binary operator '%s'", operator.toString()));
                    }
                    Node right_node = this.nodes_.pop();
                    Node left_node = this.nodes_.pop();
                    this.nodes_.push(new UnionNode(left_node, right_node));
                    break;
                }
                default: {
                    throw new AssertionError((Object)String.format("no processing defined for operator '%s'", operator.toString()));
                }
            }
        }

        private static String unescape(String string) {
            return StringEscapeUtils.unescapeJava((String)string);
        }

        private static enum State {
            EXPECT_ELEMENT,
            EXPECT_OPERATOR;

        }

        private static enum Operator {
            ABSOLUTE_COMPLEMENT(Precedence.COMPLEMENT),
            INTERSECTION(Precedence.INTERSECTION),
            RELATIVE_COMPLEMENT(Precedence.INTERSECTION),
            UNION(Precedence.UNION),
            SUBEXPRESSION_START(Precedence.NONE);

            private final Precedence precedence_;

            public boolean precedes(Operator other_operator) {
                return this.precedence_.precedes(other_operator.precedence_);
            }

            private Operator(Precedence precedence) {
                this.precedence_ = precedence;
            }

            private static enum Precedence {
                COMPLEMENT(3, false),
                INTERSECTION(14, true),
                UNION(15, true),
                NONE(Integer.MAX_VALUE, false);

                private final int level_;
                private final boolean left_associative_;

                public boolean precedes(Precedence other_precedence) {
                    return this.level_ < other_precedence.level_ || this.level_ == other_precedence.level_ && this.left_associative_;
                }

                private Precedence(int level, boolean left_associative) {
                    this.level_ = level;
                    this.left_associative_ = left_associative;
                }
            }
        }
    }

    private static class UnionNode
    implements Node {
        private final Node left_node_;
        private final Node right_node_;

        public UnionNode(Node left_node, Node right_node) {
            this.left_node_ = left_node;
            this.right_node_ = right_node;
        }

        @Override
        public boolean isSatisfiedBy(Collection<String> elements) {
            return this.left_node_.isSatisfiedBy(elements) || this.right_node_.isSatisfiedBy(elements);
        }
    }

    private static class IntersectionNode
    implements Node {
        private final Node left_node_;
        private final Node right_node_;

        public IntersectionNode(Node left_node, Node right_node) {
            this.left_node_ = left_node;
            this.right_node_ = right_node;
        }

        @Override
        public boolean isSatisfiedBy(Collection<String> elements) {
            return this.left_node_.isSatisfiedBy(elements) && this.right_node_.isSatisfiedBy(elements);
        }
    }

    private static class ComplementNode
    implements Node {
        private final Node node_;

        public ComplementNode(Node node) {
            this.node_ = node;
        }

        @Override
        public boolean isSatisfiedBy(Collection<String> elements) {
            return !this.node_.isSatisfiedBy(elements);
        }
    }

    private static class ElementNode
    implements Node {
        private final String element_;

        public ElementNode(String element) {
            this.element_ = element;
        }

        @Override
        public boolean isSatisfiedBy(Collection<String> elements) {
            return elements.contains(this.element_);
        }
    }

    private static interface Node {
        public boolean isSatisfiedBy(Collection<String> var1);
    }
}

