/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects.mirror;

import com.mcwfurnitures.kikoz.init.TileEntityInit;
import com.mcwfurnitures.kikoz.objects.FurnitureBase;
import com.mcwfurnitures.kikoz.storage.FurnitureTileEntity;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class FurnitureMirror
extends FurnitureBase {
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.field_208142_aq;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final VoxelShape PART_BASE_Z = Stream.of(Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public FurnitureMirror(Block.Properties properties) {
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(HINGE, (Comparable)DoorHingeSide.LEFT)).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(HINGE, (Comparable)this.getHingeSide(context))).func_206870_a((IProperty)HorizontalBlock.field_185512_D, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING))).func_177231_a(HINGE);
    }

    private DoorHingeSide getHingeSide(BlockItemUseContext p_208073_1_) {
        boolean flag1;
        World iblockreader = p_208073_1_.func_195991_k();
        BlockPos blockpos = p_208073_1_.func_195995_a();
        Direction direction = p_208073_1_.func_195992_f();
        BlockPos blockpos1 = blockpos.func_177984_a();
        Direction direction1 = direction.func_176735_f();
        BlockPos blockpos2 = blockpos.func_177972_a(direction1);
        BlockState blockstate = iblockreader.func_180495_p(blockpos2);
        BlockPos blockpos3 = blockpos1.func_177972_a(direction1);
        BlockState blockstate1 = iblockreader.func_180495_p(blockpos3);
        Direction direction2 = direction.func_176746_e();
        BlockPos blockpos4 = blockpos.func_177972_a(direction2);
        BlockState blockstate2 = iblockreader.func_180495_p(blockpos4);
        BlockPos blockpos5 = blockpos1.func_177972_a(direction2);
        BlockState blockstate3 = iblockreader.func_180495_p(blockpos5);
        int i = (blockstate.func_224756_o((IBlockReader)iblockreader, blockpos2) ? -1 : 0) + (blockstate1.func_224756_o((IBlockReader)iblockreader, blockpos3) ? -1 : 0) + (blockstate2.func_224756_o((IBlockReader)iblockreader, blockpos4) ? 1 : 0) + (blockstate3.func_224756_o((IBlockReader)iblockreader, blockpos5) ? 1 : 0);
        boolean flag = blockstate.func_177230_c() == this;
        boolean bl = flag1 = blockstate2.func_177230_c() == this;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.func_82601_c();
                int k = direction.func_82599_e();
                Vec3d vector3d = p_208073_1_.func_221532_j();
                double d0 = vector3d.field_72450_a - (double)blockpos.func_177958_n();
                double d1 = vector3d.field_72449_c - (double)blockpos.func_177952_p();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        return direction.func_176740_k() == Direction.Axis.X ? PART_BASE_Z : PART_BASE_Z;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)TileEntityInit.EXAMPLE_CHEST.get()).func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult result) {
        TileEntity tile;
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof FurnitureTileEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((FurnitureTileEntity)tile), (BlockPos)pos);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te;
        if (state.func_177230_c() != newState.func_177230_c() && (te = worldIn.func_175625_s(pos)) instanceof FurnitureTileEntity) {
            InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, ((FurnitureTileEntity)te).func_190576_q());
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, HINGE, WATERLOGGED});
    }
}

