/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.builders.ItemBuilder;
import com.simibubi.create.repack.registrate.providers.ProviderType;
import com.simibubi.create.repack.registrate.util.nullness.NonNullFunction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.ResourceLocation;

public class AllTags {
    private static final CreateRegistrate REGISTRATE = (CreateRegistrate)Create.registrate().itemGroup(() -> Create.baseCreativeTab);

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, ItemBuilder<BlockItem, BlockBuilder<T, P>>> tagBlockAndItem(String tagName) {
        return b -> b.tag(AllTags.forgeBlockTag(tagName)).item().tag(AllTags.forgeItemTag(tagName));
    }

    public static Tag<Block> forgeBlockTag(String name) {
        return AllTags.forgeTag(BlockTags.func_199896_a(), name);
    }

    public static Tag<Item> forgeItemTag(String name) {
        return AllTags.forgeTag(ItemTags.func_199903_a(), name);
    }

    public static Tag<Fluid> forgeFluidTag(String name) {
        return AllTags.forgeTag(FluidTags.func_226157_a_(), name);
    }

    public static <T> Tag<T> forgeTag(TagCollection<T> collection, String name) {
        return AllTags.tag(collection, "forge", name);
    }

    public static <T> Tag<T> tag(TagCollection<T> collection, String domain, String name) {
        return collection.func_199915_b(new ResourceLocation(domain, name));
    }

    public static void register() {
        AllItemTags.CREATE_INGOTS.includeIn(AllItemTags.BEACON_PAYMENT);
        AllItemTags.CREATE_INGOTS.includeIn(AllItemTags.INGOTS);
        AllItemTags.UPRIGHT_ON_BELT.add(Items.field_151069_bo, Items.field_151068_bn, Items.field_185155_bH, Items.field_185156_bI);
        AllBlockTags.WINDMILL_SAILS.includeAll((Tag<Block>)BlockTags.field_199897_a);
        AllBlockTags.BRITTLE.includeAll((Tag<Block>)BlockTags.field_200029_f);
        AllBlockTags.BRITTLE.add(Blocks.field_150457_bL, Blocks.field_222431_lT, Blocks.field_150375_by);
        AllBlockTags.FAN_TRANSPARENT.includeAll((Tag<Block>)BlockTags.field_219748_G);
        AllBlockTags.FAN_TRANSPARENT.add(Blocks.field_150411_aY);
        AllBlockTags.FAN_HEATERS.add(Blocks.field_196814_hQ, Blocks.field_222433_lV, Blocks.field_150353_l, Blocks.field_150480_ab);
    }

    public static enum AllBlockTags {
        WINDMILL_SAILS,
        FAN_HEATERS,
        WINDOWABLE,
        NON_MOVABLE,
        BRITTLE,
        SEATS,
        SAILS,
        VALVE_HANDLES,
        FAN_TRANSPARENT,
        SAFE_NBT;

        public Tag<Block> tag;

        private AllBlockTags() {
            this(NameSpace.MOD, "");
        }

        private AllBlockTags(NameSpace namespace) {
            this(namespace, "");
        }

        private AllBlockTags(NameSpace namespace, String path) {
            this.tag = new BlockTags.Wrapper(new ResourceLocation(namespace.id, (path.isEmpty() ? "" : path + "/") + Lang.asId(this.name())));
        }

        public boolean matches(BlockState block) {
            return this.tag.func_199685_a_((Object)block.func_177230_c());
        }

        public void includeIn(AllBlockTags parent) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.func_200426_a(parent.tag).func_200574_a(this.tag));
        }

        public void includeAll(Tag<Block> child) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.func_200426_a(this.tag).func_200574_a(child));
        }

        public void add(Block ... values) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.func_200426_a(this.tag).func_200573_a((Object[])values));
        }
    }

    public static enum AllFluidTags {
        NO_INFINITE_DRAINING;

        public Tag<Fluid> tag;

        private AllFluidTags() {
            this(NameSpace.MOD, "");
        }

        private AllFluidTags(NameSpace namespace) {
            this(namespace, "");
        }

        private AllFluidTags(NameSpace namespace, String path) {
            this.tag = new FluidTags.Wrapper(new ResourceLocation(namespace.id, (path.isEmpty() ? "" : path + "/") + Lang.asId(this.name())));
        }

        public boolean matches(Fluid fluid) {
            return fluid != null && fluid.func_207185_a(this.tag);
        }
    }

    public static enum AllItemTags {
        CRUSHED_ORES(NameSpace.MOD),
        SEATS(NameSpace.MOD),
        VALVE_HANDLES(NameSpace.MOD),
        UPRIGHT_ON_BELT(NameSpace.MOD),
        CREATE_INGOTS(NameSpace.MOD),
        BEACON_PAYMENT(NameSpace.FORGE),
        INGOTS(NameSpace.FORGE),
        NUGGETS(NameSpace.FORGE),
        PLATES(NameSpace.FORGE),
        COBBLESTONE(NameSpace.FORGE);

        public Tag<Item> tag;

        private AllItemTags(NameSpace namespace) {
            this(namespace, "");
        }

        private AllItemTags(NameSpace namespace, String path) {
            this.tag = new ItemTags.Wrapper(new ResourceLocation(namespace.id, (path.isEmpty() ? "" : path + "/") + Lang.asId(this.name())));
        }

        public boolean matches(ItemStack stack) {
            return this.tag.func_199685_a_((Object)stack.func_77973_b());
        }

        public void add(Item ... values) {
            REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.func_200426_a(this.tag).func_200573_a((Object[])values));
        }

        public void includeIn(AllItemTags parent) {
            REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.func_200426_a(parent.tag).func_200574_a(this.tag));
        }
    }

    public static enum NameSpace {
        MOD("create"),
        FORGE("forge"),
        MC("minecraft");

        String id;

        private NameSpace(String id) {
            this.id = id;
        }
    }
}

