/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei;

import com.google.common.base.Predicates;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.compat.jei.FilterGhostIngredientHandler;
import com.simibubi.create.compat.jei.SlotMover;
import com.simibubi.create.compat.jei.category.BlockCuttingCategory;
import com.simibubi.create.compat.jei.category.BlockzapperUpgradeCategory;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.CrushingCategory;
import com.simibubi.create.compat.jei.category.FanBlastingCategory;
import com.simibubi.create.compat.jei.category.FanSmokingCategory;
import com.simibubi.create.compat.jei.category.FanWashingCategory;
import com.simibubi.create.compat.jei.category.ItemDrainCategory;
import com.simibubi.create.compat.jei.category.MechanicalCraftingCategory;
import com.simibubi.create.compat.jei.category.MillingCategory;
import com.simibubi.create.compat.jei.category.MixingCategory;
import com.simibubi.create.compat.jei.category.MysteriousItemConversionCategory;
import com.simibubi.create.compat.jei.category.PackingCategory;
import com.simibubi.create.compat.jei.category.PolishingCategory;
import com.simibubi.create.compat.jei.category.PressingCategory;
import com.simibubi.create.compat.jei.category.ProcessingViaFanCategory;
import com.simibubi.create.compat.jei.category.SawingCategory;
import com.simibubi.create.compat.jei.category.SpoutCategory;
import com.simibubi.create.content.contraptions.components.press.MechanicalPressTileEntity;
import com.simibubi.create.content.contraptions.fluids.recipe.PotionMixingRecipeManager;
import com.simibubi.create.content.contraptions.processing.BasinRecipe;
import com.simibubi.create.content.logistics.block.inventories.AdjustableCrateScreen;
import com.simibubi.create.content.logistics.item.filter.AbstractFilterScreen;
import com.simibubi.create.content.schematics.block.SchematicannonScreen;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CRecipes;
import com.simibubi.create.foundation.config.ConfigBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class CreateJEI
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("create", "jei_plugin");
    public IIngredientManager ingredientManager;
    final List<CreateRecipeCategory<?>> ALL = new ArrayList();
    final CreateRecipeCategory<?> milling = this.register("milling", MillingCategory::new).recipes(AllRecipeTypes.MILLING).catalyst(AllBlocks.MILLSTONE::get).build();
    final CreateRecipeCategory<?> crushing = this.register("crushing", CrushingCategory::new).recipes(AllRecipeTypes.CRUSHING).recipesExcluding(AllRecipeTypes.MILLING::getType, AllRecipeTypes.CRUSHING::getType).catalyst(AllBlocks.CRUSHING_WHEEL::get).build();
    final CreateRecipeCategory<?> pressing = this.register("pressing", PressingCategory::new).recipes(AllRecipeTypes.PRESSING).catalyst(AllBlocks.MECHANICAL_PRESS::get).build();
    final CreateRecipeCategory<?> washing = this.register("fan_washing", FanWashingCategory::new).recipes(AllRecipeTypes.SPLASHING).catalystStack(ProcessingViaFanCategory.getFan("fan_washing")).build();
    final CreateRecipeCategory<?> smoking = this.register("fan_smoking", FanSmokingCategory::new).recipes(() -> IRecipeType.field_222152_d).catalystStack(ProcessingViaFanCategory.getFan("fan_smoking")).build();
    final CreateRecipeCategory<?> blasting = this.register("fan_blasting", FanBlastingCategory::new).recipesExcluding(() -> IRecipeType.field_222150_b, () -> IRecipeType.field_222152_d).catalystStack(ProcessingViaFanCategory.getFan("fan_blasting")).build();
    final CreateRecipeCategory<?> blockzapper;
    final CreateRecipeCategory<?> mixing;
    final CreateRecipeCategory<?> autoShapeless;
    final CreateRecipeCategory<?> brewing;
    final CreateRecipeCategory<?> sawing;
    final CreateRecipeCategory<?> blockCutting;
    final CreateRecipeCategory<?> packing;
    final CreateRecipeCategory<?> autoSquare;
    final CreateRecipeCategory<?> polishing;
    final CreateRecipeCategory<?> mysteryConversion;
    final CreateRecipeCategory<?> spoutFilling;
    final CreateRecipeCategory<?> draining;
    final CreateRecipeCategory<?> autoShaped;
    final CreateRecipeCategory<?> mechanicalCrafting;

    public CreateJEI() {
        this.blockzapper = this.register("blockzapper_upgrade", BlockzapperUpgradeCategory::new).recipes(AllRecipeTypes.BLOCKZAPPER_UPGRADE.serializer.getRegistryName()).catalyst(AllItems.BLOCKZAPPER::get).build();
        this.mixing = this.register("mixing", MixingCategory::standard).recipes(AllRecipeTypes.MIXING::getType).catalyst(AllBlocks.MECHANICAL_MIXER::get).catalyst(AllBlocks.BASIN::get).build();
        this.autoShapeless = this.register("automatic_shapeless", MixingCategory::autoShapeless).recipes(r -> r.func_199559_b() == IRecipeSerializer.field_222158_b && r.func_192400_c().size() > 1 && !MechanicalPressTileEntity.canCompress((NonNullList<Ingredient>)r.func_192400_c()), BasinRecipe::convertShapeless).catalyst(AllBlocks.MECHANICAL_MIXER::get).catalyst(AllBlocks.BASIN::get).enableWhen(c -> c.allowShapelessInMixer).build();
        this.brewing = this.register("automatic_brewing", MixingCategory::autoBrewing).recipeList(PotionMixingRecipeManager::getAllBrewingRecipes).catalyst(AllBlocks.MECHANICAL_MIXER::get).catalyst(AllBlocks.BASIN::get).build();
        this.sawing = this.register("sawing", SawingCategory::new).recipes(AllRecipeTypes.CUTTING).catalyst(AllBlocks.MECHANICAL_SAW::get).build();
        this.blockCutting = this.register("block_cutting", BlockCuttingCategory::new).recipeList(() -> BlockCuttingCategory.CondensedBlockCuttingRecipe.condenseRecipes(CreateJEI.findRecipesByType(IRecipeType.field_222154_f))).catalyst(AllBlocks.MECHANICAL_SAW::get).enableWhen(c -> c.allowStonecuttingOnSaw).build();
        this.packing = this.register("packing", PackingCategory::standard).recipes(AllRecipeTypes.COMPACTING).catalyst(AllBlocks.MECHANICAL_PRESS::get).catalyst(AllBlocks.BASIN::get).build();
        this.autoSquare = this.register("automatic_packing", PackingCategory::autoSquare).recipes(r -> r instanceof ICraftingRecipe && MechanicalPressTileEntity.canCompress((NonNullList<Ingredient>)r.func_192400_c()), BasinRecipe::convertShapeless).catalyst(AllBlocks.MECHANICAL_PRESS::get).catalyst(AllBlocks.BASIN::get).enableWhen(c -> c.allowShapedSquareInPress).build();
        this.polishing = this.register("sandpaper_polishing", PolishingCategory::new).recipes(AllRecipeTypes.SANDPAPER_POLISHING).catalyst(AllItems.SAND_PAPER::get).catalyst(AllItems.RED_SAND_PAPER::get).build();
        this.mysteryConversion = this.register("mystery_conversion", MysteriousItemConversionCategory::new).recipeList(MysteriousItemConversionCategory::getRecipes).build();
        this.spoutFilling = this.register("spout_filling", SpoutCategory::new).recipes(AllRecipeTypes.FILLING).recipeList(() -> SpoutCategory.getRecipes(this.ingredientManager)).catalyst(AllBlocks.SPOUT::get).build();
        this.draining = this.register("draining", ItemDrainCategory::new).recipeList(() -> ItemDrainCategory.getRecipes(this.ingredientManager)).recipes(AllRecipeTypes.EMPTYING).catalyst(AllBlocks.ITEM_DRAIN::get).build();
        this.autoShaped = this.register("automatic_shaped", MechanicalCraftingCategory::new).recipes(r -> r.func_199559_b() == IRecipeSerializer.field_222158_b && r.func_192400_c().size() == 1).recipes(r -> r.func_222127_g() == IRecipeType.field_222149_a && r.func_222127_g() != AllRecipeTypes.MECHANICAL_CRAFTING.type && r instanceof ShapedRecipe).catalyst(AllBlocks.MECHANICAL_CRAFTER::get).enableWhen(c -> c.allowRegularCraftingInCrafter).build();
        this.mechanicalCrafting = this.register("mechanical_crafting", MechanicalCraftingCategory::new).recipes(AllRecipeTypes.MECHANICAL_CRAFTING).catalyst(AllBlocks.MECHANICAL_CRAFTER::get).build();
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    private <T extends IRecipe<?>> CategoryBuilder<T> register(String name, Supplier<CreateRecipeCategory<T>> supplier) {
        return new CategoryBuilder<T>(name, supplier);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{(Item)AllItems.BLOCKZAPPER.get()});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.ALL.forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        this.ALL.forEach(c -> c.recipes.forEach(s -> registration.addRecipes((Collection)s.get(), c.getUid())));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.ALL.forEach(c -> c.recipeCatalysts.forEach(s -> registration.addRecipeCatalyst(s.get(), new ResourceLocation[]{c.getUid()})));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(AdjustableCrateScreen.class, new SlotMover());
        registration.addGuiContainerHandler(SchematicannonScreen.class, new SlotMover());
        registration.addGhostIngredientHandler(AbstractFilterScreen.class, new FilterGhostIngredientHandler());
    }

    static List<IRecipe<?>> findRecipesByType(IRecipeType<?> type) {
        return CreateJEI.findRecipes(r -> r.func_222127_g() == type);
    }

    static List<IRecipe<?>> findRecipes(Predicate<IRecipe<?>> predicate) {
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(predicate).collect(Collectors.toList());
    }

    static List<IRecipe<?>> findRecipesByTypeExcluding(IRecipeType<?> type, IRecipeType<?> excludingType) {
        List<IRecipe<?>> byType = CreateJEI.findRecipes(r -> r.func_222127_g() == type);
        List<IRecipe<?>> byExcludingType = CreateJEI.findRecipes(r -> r.func_222127_g() == excludingType);
        byType.removeIf(recipe -> {
            for (IRecipe r : byExcludingType) {
                ItemStack[] matchingStacks = ((Ingredient)recipe.func_192400_c().get(0)).func_193365_a();
                if (matchingStacks.length == 0) {
                    return true;
                }
                if (!((Ingredient)r.func_192400_c().get(0)).test(matchingStacks[0])) continue;
                return true;
            }
            return false;
        });
        return byType;
    }

    private class CategoryBuilder<T extends IRecipe<?>> {
        CreateRecipeCategory<T> category;
        private Predicate<CRecipes> pred;

        CategoryBuilder(String name, Supplier<CreateRecipeCategory<T>> category) {
            this.category = category.get();
            this.category.setCategoryId(name);
            this.pred = Predicates.alwaysTrue();
        }

        CategoryBuilder<T> catalyst(Supplier<IItemProvider> supplier) {
            return this.catalystStack(() -> new ItemStack((IItemProvider)((IItemProvider)supplier.get()).func_199767_j()));
        }

        CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.category.recipeCatalysts.add(supplier);
            return this;
        }

        CategoryBuilder<T> recipes(AllRecipeTypes recipeTypeEntry) {
            return this.recipes(recipeTypeEntry::getType);
        }

        CategoryBuilder<T> recipes(Supplier<IRecipeType<T>> recipeType) {
            return this.recipes((IRecipe<?> r) -> r.func_222127_g() == recipeType.get());
        }

        CategoryBuilder<T> recipes(ResourceLocation serializer) {
            return this.recipes((IRecipe<?> r) -> r.func_199559_b().getRegistryName().equals((Object)serializer));
        }

        CategoryBuilder<T> recipes(Predicate<IRecipe<?>> pred) {
            return this.recipeList(() -> CreateJEI.findRecipes(pred));
        }

        CategoryBuilder<T> recipes(Predicate<IRecipe<?>> pred, Function<IRecipe<?>, T> converter) {
            return this.recipeList(() -> CreateJEI.findRecipes(pred), converter);
        }

        CategoryBuilder<T> recipeList(Supplier<List<? extends IRecipe<?>>> list) {
            return this.recipeList(list, null);
        }

        CategoryBuilder<T> recipeList(Supplier<List<? extends IRecipe<?>>> list, Function<IRecipe<?>, T> converter) {
            this.category.recipes.add(() -> {
                if (!this.pred.test(AllConfigs.SERVER.recipes)) {
                    return Collections.emptyList();
                }
                if (converter != null) {
                    return ((List)list.get()).stream().map(converter).collect(Collectors.toList());
                }
                return (List)list.get();
            });
            return this;
        }

        CategoryBuilder<T> recipesExcluding(Supplier<IRecipeType<? extends T>> recipeType, Supplier<IRecipeType<? extends T>> excluded) {
            this.category.recipes.add(() -> {
                if (!this.pred.test(AllConfigs.SERVER.recipes)) {
                    return Collections.emptyList();
                }
                return CreateJEI.findRecipesByTypeExcluding((IRecipeType)recipeType.get(), (IRecipeType)excluded.get());
            });
            return this;
        }

        CategoryBuilder<T> enableWhen(Function<CRecipes, ConfigBase.ConfigBool> configValue) {
            this.pred = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((CRecipes)c)).get();
            return this;
        }

        CreateRecipeCategory<T> build() {
            CreateJEI.this.ALL.add(this.category);
            return this.category;
        }
    }
}

