/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.actors.PortableStorageInterfaceBlock;
import com.simibubi.create.content.contraptions.components.actors.PortableStorageInterfaceTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class PortableStorageInterfaceRenderer
extends SafeTileEntityRenderer<PortableStorageInterfaceTileEntity> {
    public PortableStorageInterfaceRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(PortableStorageInterfaceTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        BlockState blockState = te.func_195044_w();
        float progress = te.getExtensionDistance(partialTicks);
        IVertexBuilder vb = buffer.getBuffer(RenderType.func_228639_c_());
        PortableStorageInterfaceRenderer.render(blockState, progress, te.isConnected(), sbb -> sbb.light(light).renderInto(ms, vb), ms);
    }

    public static void renderInContraption(MovementContext context, MatrixStack ms, MatrixStack msLocal, IRenderTypeBuffer buffer) {
        BlockState blockState = context.state;
        PortableStorageInterfaceTileEntity te = PortableStorageInterfaceRenderer.getTargetPSI(context);
        IVertexBuilder vb = buffer.getBuffer(RenderType.func_228639_c_());
        float renderPartialTicks = Minecraft.func_71410_x().func_184121_ak();
        float progress = 0.0f;
        boolean lit = false;
        if (te != null) {
            progress = te.getExtensionDistance(renderPartialTicks);
            lit = te.isConnected();
        }
        PortableStorageInterfaceRenderer.render(blockState, progress, lit, sbb -> sbb.light(msLocal.func_227866_c_().func_227870_a_()).renderInto(ms, vb), ms, msLocal);
    }

    protected static PortableStorageInterfaceTileEntity getTargetPSI(MovementContext context) {
        String _workingPos_ = "WorkingPos";
        if (!context.contraption.stalled || !context.data.func_74764_b(_workingPos_)) {
            return null;
        }
        BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)context.data.func_74775_l(_workingPos_));
        TileEntity tileEntity = context.world.func_175625_s(pos);
        if (!(tileEntity instanceof PortableStorageInterfaceTileEntity)) {
            return null;
        }
        PortableStorageInterfaceTileEntity psi = (PortableStorageInterfaceTileEntity)tileEntity;
        if (!psi.isTransferring()) {
            return null;
        }
        return psi;
    }

    private static void render(BlockState blockState, float progress, boolean lit, Consumer<SuperByteBuffer> drawCallback, MatrixStack ... matrixStacks) {
        for (MatrixStack ms : matrixStacks) {
            ms.func_227860_a_();
        }
        SuperByteBuffer middle = PortableStorageInterfaceRenderer.getMiddleForState(blockState, lit).renderOn(blockState);
        SuperByteBuffer top = PortableStorageInterfaceRenderer.getTopForState(blockState).renderOn(blockState);
        Direction facing = (Direction)blockState.func_177229_b((IProperty)PortableStorageInterfaceBlock.field_176387_N);
        for (MatrixStack ms : matrixStacks) {
            MatrixStacker.of(ms).centre().rotateY(AngleHelper.horizontalAngle(facing)).rotateX(facing == Direction.UP ? 0.0 : (facing == Direction.DOWN ? 180.0 : 90.0)).unCentre();
        }
        for (MatrixStack ms : matrixStacks) {
            ms.func_227861_a_(0.0, (double)(progress / 2.0f), 0.0);
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, 0.375, 0.0);
        }
        drawCallback.accept(middle);
        for (MatrixStack ms : matrixStacks) {
            ms.func_227865_b_();
            ms.func_227861_a_(0.0, (double)(progress / 2.0f), 0.0);
        }
        drawCallback.accept(top);
        for (MatrixStack ms : matrixStacks) {
            ms.func_227865_b_();
        }
    }

    static AllBlockPartials getMiddleForState(BlockState state, boolean lit) {
        if (AllBlocks.PORTABLE_FLUID_INTERFACE.has(state)) {
            return lit ? AllBlockPartials.PORTABLE_FLUID_INTERFACE_MIDDLE_POWERED : AllBlockPartials.PORTABLE_FLUID_INTERFACE_MIDDLE;
        }
        return lit ? AllBlockPartials.PORTABLE_STORAGE_INTERFACE_MIDDLE_POWERED : AllBlockPartials.PORTABLE_STORAGE_INTERFACE_MIDDLE;
    }

    static AllBlockPartials getTopForState(BlockState state) {
        if (AllBlocks.PORTABLE_FLUID_INTERFACE.has(state)) {
            return AllBlockPartials.PORTABLE_FLUID_INTERFACE_TOP;
        }
        return AllBlockPartials.PORTABLE_STORAGE_INTERFACE_TOP;
    }
}

