/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors.dispenser;

import com.simibubi.create.content.contraptions.components.actors.dispenser.MovedDefaultDispenseItemBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.SimplePos;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public abstract class MovedProjectileDispenserBehaviour
extends MovedDefaultDispenseItemBehaviour {
    @Override
    protected ItemStack dispenseStack(ItemStack itemStack, MovementContext context, BlockPos pos, Vec3d facing) {
        double z;
        double y;
        double x = (double)pos.func_177958_n() + facing.field_72450_a * 0.7 + 0.5;
        IProjectile iprojectile = this.getProjectileEntity(context.world, x, y = (double)pos.func_177956_o() + facing.field_72448_b * 0.7 + 0.5, z = (double)pos.func_177952_p() + facing.field_72449_c * 0.7 + 0.5, itemStack.func_77946_l());
        if (iprojectile == null) {
            return itemStack;
        }
        Vec3d effectiveMovementVec = facing.func_186678_a((double)this.getProjectileVelocity()).func_178787_e(context.motion);
        iprojectile.func_70186_c(effectiveMovementVec.field_72450_a, effectiveMovementVec.field_72448_b, effectiveMovementVec.field_72449_c, (float)effectiveMovementVec.func_72433_c(), this.getProjectileInaccuracy());
        context.world.func_217376_c((Entity)iprojectile);
        itemStack.func_190918_g(1);
        return itemStack;
    }

    @Override
    protected void playDispenseSound(IWorld world, BlockPos pos) {
        world.func_217379_c(1002, pos, 0);
    }

    @Nullable
    protected abstract IProjectile getProjectileEntity(World var1, double var2, double var4, double var6, ItemStack var8);

    protected float getProjectileInaccuracy() {
        return 6.0f;
    }

    protected float getProjectileVelocity() {
        return 1.1f;
    }

    public static MovedProjectileDispenserBehaviour of(final ProjectileDispenseBehavior vanillaBehaviour) {
        return new MovedProjectileDispenserBehaviour(){

            @Override
            protected IProjectile getProjectileEntity(World world, double x, double y, double z, ItemStack itemStack) {
                try {
                    return (IProjectile)MovedProjectileDispenserBehaviour.getProjectileEntityLookup().invoke((Object)vanillaBehaviour, world, new SimplePos(x, y, z), itemStack);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }

            @Override
            protected float getProjectileInaccuracy() {
                try {
                    return ((Float)MovedProjectileDispenserBehaviour.getProjectileInaccuracyLookup().invoke((Object)vanillaBehaviour, new Object[0])).floatValue();
                }
                catch (Throwable throwable) {
                    return super.getProjectileInaccuracy();
                }
            }

            @Override
            protected float getProjectileVelocity() {
                try {
                    return ((Float)MovedProjectileDispenserBehaviour.getProjectileVelocityLookup().invoke((Object)vanillaBehaviour, new Object[0])).floatValue();
                }
                catch (Throwable throwable) {
                    return super.getProjectileVelocity();
                }
            }
        };
    }

    private static Method getProjectileEntityLookup() {
        Method getProjectileEntity = ObfuscationReflectionHelper.findMethod(ProjectileDispenseBehavior.class, (String)"func_82499_a", (Class[])new Class[]{World.class, IPosition.class, ItemStack.class});
        getProjectileEntity.setAccessible(true);
        return getProjectileEntity;
    }

    private static Method getProjectileInaccuracyLookup() {
        Method getProjectileInaccuracy = ObfuscationReflectionHelper.findMethod(ProjectileDispenseBehavior.class, (String)"func_82498_a", (Class[])new Class[0]);
        getProjectileInaccuracy.setAccessible(true);
        return getProjectileInaccuracy;
    }

    private static Method getProjectileVelocityLookup() {
        Method getProjectileVelocity = ObfuscationReflectionHelper.findMethod(ProjectileDispenseBehavior.class, (String)"func_82500_b", (Class[])new Class[0]);
        getProjectileVelocity.setAccessible(true);
        return getProjectileVelocity;
    }
}

