/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crank;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.crank.HandCrankBlock;
import com.simibubi.create.foundation.utility.DyeHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
public class ValveHandleBlock
extends HandCrankBlock {
    private final boolean inCreativeTab;

    public static ValveHandleBlock copper(Block.Properties properties) {
        return new ValveHandleBlock(properties, true);
    }

    public static ValveHandleBlock dyed(Block.Properties properties) {
        return new ValveHandleBlock(properties, false);
    }

    private ValveHandleBlock(Block.Properties properties, boolean inCreativeTab) {
        super(properties);
        this.inCreativeTab = inCreativeTab;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(handIn);
        for (DyeColor color : DyeColor.values()) {
            if (!heldItem.func_77973_b().func_206844_a(DyeHelper.getTagOfDye(color))) continue;
            if (worldIn.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            BlockState newState = (BlockState)AllBlocks.DYED_VALVE_HANDLES[color.ordinal()].getDefaultState().func_206870_a((IProperty)FACING, state.func_177229_b((IProperty)FACING));
            if (newState != state) {
                worldIn.func_175656_a(pos, newState);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> p_149666_2_) {
        if (group != ItemGroup.field_78027_g && !this.inCreativeTab) {
            return;
        }
        super.func_149666_a(group, p_149666_2_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AllBlockPartials getRenderedHandle() {
        return null;
    }

    @Override
    public int getRotationSpeed() {
        return 16;
    }
}

