/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntityRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.AllContraptionTypes;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.foundation.utility.MatrixStacker;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class OrientedContraptionEntityRenderer
extends AbstractContraptionEntityRenderer<OrientedContraptionEntity> {
    public OrientedContraptionEntityRenderer(EntityRendererManager p_i46179_1_) {
        super(p_i46179_1_);
    }

    @Override
    public boolean shouldRender(OrientedContraptionEntity entity, ClippingHelperImpl p_225626_2_, double p_225626_3_, double p_225626_5_, double p_225626_7_) {
        if (!super.shouldRender(entity, p_225626_2_, p_225626_3_, p_225626_5_, p_225626_7_)) {
            return false;
        }
        return entity.getContraption().getType() != AllContraptionTypes.MOUNTED || entity.func_184187_bx() != null;
    }

    @Override
    protected void transform(OrientedContraptionEntity entity, float partialTicks, MatrixStack[] matrixStacks) {
        float angleInitialYaw = entity.getInitialYaw();
        float angleYaw = entity.func_195046_g(partialTicks);
        float anglePitch = entity.func_195050_f(partialTicks);
        for (MatrixStack stack : matrixStacks) {
            stack.func_227861_a_(-0.5, 0.0, -0.5);
        }
        Entity ridingEntity = entity.func_184187_bx();
        if (ridingEntity instanceof AbstractMinecartEntity) {
            this.repositionOnCart(partialTicks, matrixStacks, ridingEntity);
        }
        if (ridingEntity instanceof AbstractContraptionEntity) {
            if (ridingEntity.func_184187_bx() instanceof AbstractMinecartEntity) {
                this.repositionOnCart(partialTicks, matrixStacks, ridingEntity.func_184187_bx());
            } else {
                this.repositionOnContraption(entity, partialTicks, matrixStacks, ridingEntity);
            }
        }
        for (MatrixStack stack : matrixStacks) {
            MatrixStacker.of(stack).nudge(entity.func_145782_y()).centre().rotateY(angleYaw).rotateZ(anglePitch).rotateY(angleInitialYaw).unCentre();
        }
    }

    private void repositionOnContraption(OrientedContraptionEntity entity, float partialTicks, MatrixStack[] matrixStacks, Entity ridingEntity) {
        AbstractContraptionEntity parent = (AbstractContraptionEntity)ridingEntity;
        Vec3d passengerPosition = parent.getPassengerPosition(entity, partialTicks);
        double x = passengerPosition.field_72450_a - MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70142_S, (double)entity.func_226277_ct_());
        double y = passengerPosition.field_72448_b - MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70137_T, (double)entity.func_226278_cu_());
        double z = passengerPosition.field_72449_c - MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70136_U, (double)entity.func_226281_cx_());
        for (MatrixStack stack : matrixStacks) {
            stack.func_227861_a_(x, y, z);
        }
    }

    private void repositionOnCart(float partialTicks, MatrixStack[] matrixStacks, Entity ridingEntity) {
        double cartZ;
        double cartY;
        AbstractMinecartEntity cart = (AbstractMinecartEntity)ridingEntity;
        double cartX = MathHelper.func_219803_d((double)partialTicks, (double)cart.field_70142_S, (double)cart.func_226277_ct_());
        Vec3d cartPos = cart.func_70489_a(cartX, cartY = MathHelper.func_219803_d((double)partialTicks, (double)cart.field_70137_T, (double)cart.func_226278_cu_()), cartZ = MathHelper.func_219803_d((double)partialTicks, (double)cart.field_70136_U, (double)cart.func_226281_cx_()));
        if (cartPos != null) {
            Vec3d cartPosFront = cart.func_70495_a(cartX, cartY, cartZ, (double)0.3f);
            Vec3d cartPosBack = cart.func_70495_a(cartX, cartY, cartZ, (double)-0.3f);
            if (cartPosFront == null) {
                cartPosFront = cartPos;
            }
            if (cartPosBack == null) {
                cartPosBack = cartPos;
            }
            cartX = cartPos.field_72450_a - cartX;
            cartY = (cartPosFront.field_72448_b + cartPosBack.field_72448_b) / 2.0 - cartY;
            cartZ = cartPos.field_72449_c - cartZ;
            for (MatrixStack stack : matrixStacks) {
                stack.func_227861_a_(cartX, cartY, cartZ);
            }
        }
    }
}

