/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.IControlContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.IBearingTileEntity;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class MechanicalBearingTileEntity
extends GeneratingKineticTileEntity
implements IBearingTileEntity {
    protected ScrollOptionBehaviour<IControlContraption.RotationMode> movementMode;
    protected ControlledContraptionEntity movedContraption;
    protected float angle;
    protected boolean running;
    protected boolean assembleNextTick;
    protected float clientAngleDiff;

    public MechanicalBearingTileEntity(TileEntityType<? extends MechanicalBearingTileEntity> type) {
        super(type);
        this.setLazyTickRate(3);
    }

    @Override
    public boolean isWoodenTop() {
        return false;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.movementMode = new ScrollOptionBehaviour<IControlContraption.RotationMode>(IControlContraption.RotationMode.class, Lang.translate("contraptions.movement_mode", new Object[0]), this, this.getMovementModeSlot());
        this.movementMode.requiresWrench();
        behaviours.add(this.movementMode);
    }

    @Override
    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            this.disassemble();
        }
        super.func_145843_s();
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74757_a("Running", this.running);
        compound.func_74776_a("Angle", this.angle);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundNBT compound, boolean clientPacket) {
        float angleBefore = this.angle;
        this.running = compound.func_74767_n("Running");
        this.angle = compound.func_74760_g("Angle");
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.running) {
            this.clientAngleDiff = AngleHelper.getShortestAngleDiff(angleBefore, this.angle);
            this.angle = angleBefore;
        } else {
            this.movedContraption = null;
        }
    }

    @Override
    public float getInterpolatedAngle(float partialTicks) {
        if (this.movedContraption == null || this.movedContraption.isStalled() || !this.running) {
            partialTicks = 0.0f;
        }
        return MathHelper.func_219799_g((float)partialTicks, (float)this.angle, (float)(this.angle + this.getAngularSpeed()));
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.assembleNextTick = true;
    }

    public float getAngularSpeed() {
        float speed = (this.isWindmill() ? this.getGeneratedSpeed() : this.getSpeed()) * 3.0f / 10.0f;
        if (this.getSpeed() == 0.0f) {
            speed = 0.0f;
        }
        if (this.field_145850_b.field_72995_K) {
            speed *= ServerSpeedProvider.get();
            speed += this.clientAngleDiff / 3.0f;
        }
        return speed;
    }

    protected boolean isWindmill() {
        return false;
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.field_174879_c;
    }

    public void assemble() {
        if (!(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BearingBlock)) {
            return;
        }
        Direction direction = (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        BearingContraption contraption = new BearingContraption(this.isWindmill(), direction);
        if (!contraption.assemble(this.field_145850_b, this.field_174879_c)) {
            return;
        }
        if (this.isWindmill()) {
            AllTriggers.triggerForNearbyPlayers(AllTriggers.WINDMILL, this.field_145850_b, this.field_174879_c, 5);
        }
        if (contraption.getSailBlocks() >= 128) {
            AllTriggers.triggerForNearbyPlayers(AllTriggers.MAXED_WINDMILL, this.field_145850_b, this.field_174879_c, 5);
        }
        contraption.removeBlocksFromWorld(this.field_145850_b, BlockPos.field_177992_a);
        this.movedContraption = ControlledContraptionEntity.create(this.field_145850_b, this, contraption);
        BlockPos anchor = this.field_174879_c.func_177972_a(direction);
        this.movedContraption.func_70107_b(anchor.func_177958_n(), anchor.func_177956_o(), anchor.func_177952_p());
        this.movedContraption.setRotationAxis(direction.func_176740_k());
        this.field_145850_b.func_217376_c((Entity)this.movedContraption);
        this.running = true;
        this.angle = 0.0f;
        this.sendData();
        this.updateGeneratedRotation();
    }

    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        this.angle = 0.0f;
        if (this.isWindmill()) {
            this.applyRotation();
        }
        if (this.movedContraption != null) {
            this.movedContraption.disassemble();
        }
        this.movedContraption = null;
        this.running = false;
        this.updateGeneratedRotation();
        this.assembleNextTick = false;
        this.sendData();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.clientAngleDiff /= 2.0f;
        }
        if (!this.field_145850_b.field_72995_K && this.assembleNextTick) {
            this.assembleNextTick = false;
            if (this.running) {
                boolean canDisassemble;
                boolean bl = canDisassemble = this.movementMode.get() == IControlContraption.RotationMode.ROTATE_PLACE || this.isNearInitialAngle() && this.movementMode.get() == IControlContraption.RotationMode.ROTATE_PLACE_RETURNED;
                if (this.speed == 0.0f && (canDisassemble || this.movedContraption == null || this.movedContraption.getContraption().getBlocks().isEmpty())) {
                    if (this.movedContraption != null) {
                        this.movedContraption.getContraption().stop(this.field_145850_b);
                    }
                    this.disassemble();
                }
                return;
            }
            if (this.speed == 0.0f && !this.isWindmill()) {
                return;
            }
            this.assemble();
            return;
        }
        if (!this.running) {
            return;
        }
        if (this.movedContraption == null || !this.movedContraption.isStalled()) {
            float angularSpeed = this.getAngularSpeed();
            float newAngle = this.angle + angularSpeed;
            this.angle = newAngle % 360.0f;
        }
        this.applyRotation();
    }

    public boolean isNearInitialAngle() {
        return Math.abs(this.angle) < 45.0f || Math.abs(this.angle) > 315.0f;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.movedContraption != null && !this.field_145850_b.field_72995_K) {
            this.sendData();
        }
    }

    protected void applyRotation() {
        if (this.movedContraption == null) {
            return;
        }
        this.movedContraption.setAngle(this.angle);
        BlockState blockState = this.func_195044_w();
        if (blockState.func_196959_b((IProperty)BlockStateProperties.field_208155_H)) {
            this.movedContraption.setRotationAxis(((Direction)blockState.func_177229_b((IProperty)BlockStateProperties.field_208155_H)).func_176740_k());
        }
    }

    @Override
    public void attach(ControlledContraptionEntity contraption) {
        BlockState blockState = this.func_195044_w();
        if (!(contraption.getContraption() instanceof BearingContraption)) {
            return;
        }
        if (!blockState.func_196959_b((IProperty)BlockStateProperties.field_208155_H)) {
            return;
        }
        this.movedContraption = contraption;
        this.func_70296_d();
        BlockPos anchor = this.field_174879_c.func_177972_a((Direction)blockState.func_177229_b((IProperty)BlockStateProperties.field_208155_H));
        this.movedContraption.func_70107_b(anchor.func_177958_n(), anchor.func_177956_o(), anchor.func_177952_p());
        if (!this.field_145850_b.field_72995_K) {
            this.running = true;
            this.sendData();
        }
    }

    @Override
    public void onStall() {
        if (!this.field_145850_b.field_72995_K) {
            this.sendData();
        }
    }

    @Override
    public boolean isValid() {
        return !this.func_145837_r();
    }

    @Override
    public void collided() {
    }

    @Override
    public boolean isAttachedTo(AbstractContraptionEntity contraption) {
        return this.movedContraption == contraption;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean addToTooltip(List<String> tooltip, boolean isPlayerSneaking) {
        if (super.addToTooltip(tooltip, isPlayerSneaking)) {
            return true;
        }
        if (isPlayerSneaking) {
            return false;
        }
        if (!this.isWindmill() && this.getSpeed() == 0.0f) {
            return false;
        }
        if (this.running) {
            return false;
        }
        BlockState state = this.func_195044_w();
        if (!(state.func_177230_c() instanceof BearingBlock)) {
            return false;
        }
        BlockState attachedState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a((Direction)state.func_177229_b((IProperty)BearingBlock.FACING)));
        if (attachedState.func_185904_a().func_76222_j()) {
            return false;
        }
        TooltipHelper.addHint(tooltip, "hint.empty_bearing", new Object[0]);
        return true;
    }
}

