/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.glue;

import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.components.structureMovement.BlockMovementTraits;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.GlueEffectPacket;
import com.simibubi.create.content.schematics.ISpecialEntityItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.BlockFace;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.Validate;

public class SuperGlueEntity
extends Entity
implements IEntityAdditionalSpawnData,
ISpecialEntityItemRequirement {
    private int validationTimer;
    protected BlockPos hangingPosition;
    protected Direction facingDirection = Direction.SOUTH;

    public SuperGlueEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public SuperGlueEntity(World world, BlockPos pos, Direction direction) {
        this(AllEntityTypes.SUPER_GLUE.get(), world);
        this.hangingPosition = pos;
        this.facingDirection = direction;
        this.updateFacingWithBoundingBox();
    }

    protected void func_70088_a() {
    }

    public int getWidthPixels() {
        return 12;
    }

    public int getHeightPixels() {
        return 12;
    }

    public void onBroken(@Nullable Entity breaker) {
        this.func_184185_a(SoundEvents.field_187900_fz, 1.0f, 1.0f);
        if (this.onValidSurface()) {
            AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new GlueEffectPacket(this.getHangingPosition(), this.getFacingDirection().func_176734_d(), false));
            this.func_184185_a(AllSoundEvents.SLIME_ADDED.get(), 0.5f, 0.5f);
        }
    }

    public void playPlaceSound() {
        this.func_184185_a(AllSoundEvents.SLIME_ADDED.get(), 0.5f, 0.75f);
    }

    protected void updateFacingWithBoundingBox() {
        Validate.notNull((Object)this.getFacingDirection());
        if (this.getFacingDirection().func_176740_k().func_176722_c()) {
            this.field_70125_A = 0.0f;
            this.field_70177_z = this.getFacingDirection().func_176736_b() * 90;
        } else {
            this.field_70125_A = -90 * this.getFacingDirection().func_176743_c().func_179524_a();
            this.field_70177_z = 0.0f;
        }
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.updateBoundingBox();
    }

    protected void updateBoundingBox() {
        if (this.getFacingDirection() != null) {
            double offset = 0.49609375;
            double x = (double)this.hangingPosition.func_177958_n() + 0.5 - (double)this.facingDirection.func_82601_c() * offset;
            double y = (double)this.hangingPosition.func_177956_o() + 0.5 - (double)this.facingDirection.func_96559_d() * offset;
            double z = (double)this.hangingPosition.func_177952_p() + 0.5 - (double)this.facingDirection.func_82599_e() * offset;
            this.func_226288_n_(x, y, z);
            double w = this.getWidthPixels();
            double h = this.getHeightPixels();
            double l = this.getWidthPixels();
            Direction.Axis axis = this.getFacingDirection().func_176740_k();
            double depth = 1.9921875;
            switch (axis) {
                case X: {
                    w = depth;
                    break;
                }
                case Y: {
                    h = depth;
                    break;
                }
                case Z: {
                    l = depth;
                }
            }
            this.func_174826_a(new AxisAlignedBB(x - (w /= 32.0), y - (h /= 32.0), z - (l /= 32.0), x + w, y + h, z + l));
        }
    }

    public void func_70071_h_() {
        if (this.validationTimer++ == 10 && !this.field_70170_p.field_72995_K) {
            this.validationTimer = 0;
            if (this.func_70089_S() && !this.onValidSurface()) {
                this.func_70106_y();
                this.onBroken(null);
            }
        }
    }

    public boolean isVisible() {
        if (!this.func_70089_S()) {
            return false;
        }
        BlockPos pos = this.hangingPosition;
        BlockPos pos2 = pos.func_177972_a(this.getFacingDirection().func_176734_d());
        return SuperGlueEntity.isValidFace(this.field_70170_p, pos2, this.getFacingDirection()) != SuperGlueEntity.isValidFace(this.field_70170_p, pos, this.getFacingDirection().func_176734_d());
    }

    public boolean onValidSurface() {
        BlockPos pos = this.hangingPosition;
        BlockPos pos2 = this.hangingPosition.func_177972_a(this.getFacingDirection().func_176734_d());
        if (!this.field_70170_p.isAreaLoaded(pos, 0) || !this.field_70170_p.isAreaLoaded(pos2, 0)) {
            return true;
        }
        if (!SuperGlueEntity.isValidFace(this.field_70170_p, pos2, this.getFacingDirection()) && !SuperGlueEntity.isValidFace(this.field_70170_p, pos, this.getFacingDirection().func_176734_d())) {
            return false;
        }
        return this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), e -> e instanceof SuperGlueEntity).isEmpty();
    }

    public static boolean isValidFace(World world, BlockPos pos, Direction direction) {
        BlockState state = world.func_180495_p(pos);
        if (BlockMovementTraits.isBlockAttachedTowards((IBlockReader)world, pos, state, direction)) {
            return true;
        }
        if (!BlockMovementTraits.movementNecessary(world, pos)) {
            return false;
        }
        return !BlockMovementTraits.notSupportive(state, direction);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_85031_j(Entity entity) {
        return entity instanceof PlayerEntity ? this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)entity)), 0.0f) : false;
    }

    public Direction func_174811_aO() {
        return this.getFacingDirection();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.func_70089_S() && !this.field_70170_p.field_72995_K && this.isVisible()) {
            this.func_70106_y();
            this.func_70018_K();
            this.onBroken(source.func_76346_g());
        }
        return true;
    }

    public void func_213315_a(MoverType typeIn, Vec3d pos) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && pos.func_189985_c() > 0.0) {
            this.func_70106_y();
            this.onBroken(null);
        }
    }

    public void func_70024_g(double x, double y, double z) {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && x * x + y * y + z * z > 0.0) {
            this.func_70106_y();
            this.onBroken(null);
        }
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return 0.0f;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return AllItems.SUPER_GLUE.asStack();
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.triggerPlaceBlock(player, hand));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void triggerPlaceBlock(PlayerEntity player, Hand hand) {
        BlockFace hangingFace;
        if (!(player instanceof ClientPlayerEntity)) {
            return;
        }
        if (!(player.field_70170_p instanceof ClientWorld)) {
            return;
        }
        ClientPlayerEntity cPlayer = (ClientPlayerEntity)player;
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult ray = cPlayer.func_213324_a((double)mc.field_71442_b.func_78757_d(), mc.func_184121_ak(), false);
        if (!(ray instanceof BlockRayTraceResult)) {
            return;
        }
        if (ray.func_216346_c() == RayTraceResult.Type.MISS) {
            return;
        }
        BlockRayTraceResult blockRay = (BlockRayTraceResult)ray;
        BlockFace rayFace = new BlockFace(blockRay.func_216350_a(), blockRay.func_216354_b());
        if (!rayFace.isEquivalent(hangingFace = new BlockFace(this.getHangingPosition(), this.getFacingDirection().func_176734_d()))) {
            return;
        }
        int n = 0;
        Hand[] handArray = Hand.values();
        int n2 = handArray.length;
        if (n < n2) {
            Hand handIn = handArray[n];
            ItemStack itemstack = cPlayer.func_184586_b(handIn);
            int countBefore = itemstack.func_190916_E();
            ActionResultType actionResultType = mc.field_71442_b.func_217292_a(cPlayer, (ClientWorld)cPlayer.field_70170_p, handIn, blockRay);
            if (actionResultType != ActionResultType.SUCCESS) {
                return;
            }
            cPlayer.func_184609_a(handIn);
            if (!itemstack.func_190926_b() && (itemstack.func_190916_E() != countBefore || mc.field_71442_b.func_78758_h())) {
                mc.field_71460_t.field_78516_c.func_187460_a(handIn);
            }
            return;
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74774_a("Facing", (byte)this.getFacingDirection().func_176745_a());
        BlockPos blockpos = this.getHangingPosition();
        compound.func_74768_a("TileX", blockpos.func_177958_n());
        compound.func_74768_a("TileY", blockpos.func_177956_o());
        compound.func_74768_a("TileZ", blockpos.func_177952_p());
    }

    public void func_70037_a(CompoundNBT compound) {
        this.hangingPosition = new BlockPos(compound.func_74762_e("TileX"), compound.func_74762_e("TileY"), compound.func_74762_e("TileZ"));
        this.facingDirection = Direction.func_82600_a((int)compound.func_74771_c("Facing"));
        this.updateFacingWithBoundingBox();
    }

    public ItemEntity func_70099_a(ItemStack stack, float yOffset) {
        float xOffset = (float)this.getFacingDirection().func_82601_c() * 0.15f;
        float zOffset = (float)this.getFacingDirection().func_82599_e() * 0.15f;
        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + (double)xOffset, this.func_226278_cu_() + (double)yOffset, this.func_226281_cx_() + (double)zOffset, stack);
        itementity.func_174869_p();
        this.field_70170_p.func_217376_c((Entity)itementity);
        return itementity;
    }

    protected boolean func_142008_O() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        this.hangingPosition = new BlockPos(x, y, z);
        this.updateBoundingBox();
        this.field_70160_al = true;
    }

    public float func_184229_a(Rotation transformRotation) {
        if (this.getFacingDirection().func_176740_k() != Direction.Axis.Y) {
            switch (transformRotation) {
                case CLOCKWISE_180: {
                    this.facingDirection = this.facingDirection.func_176734_d();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.facingDirection = this.facingDirection.func_176735_f();
                    break;
                }
                case CLOCKWISE_90: {
                    this.facingDirection = this.facingDirection.func_176746_e();
                }
            }
        }
        float f = MathHelper.func_76142_g((float)this.field_70177_z);
        switch (transformRotation) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 90.0f;
            }
            case CLOCKWISE_90: {
                return f + 270.0f;
            }
        }
        return f;
    }

    public BlockPos getHangingPosition() {
        return this.hangingPosition;
    }

    public float func_184217_a(Mirror transformMirror) {
        return this.func_184229_a(transformMirror.func_185800_a(this.getFacingDirection()));
    }

    public Direction getAttachedDirection(BlockPos pos) {
        return !pos.equals((Object)this.hangingPosition) ? this.getFacingDirection() : this.getFacingDirection().func_176734_d();
    }

    public void func_70077_a(LightningBoltEntity lightningBolt) {
    }

    public void func_213323_x_() {
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        CompoundNBT compound = new CompoundNBT();
        this.func_213281_b(compound);
        buffer.func_150786_a(compound);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.func_70037_a(additionalData.func_150793_b());
    }

    public Direction getFacingDirection() {
        return this.facingDirection;
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return new ItemRequirement(ItemRequirement.ItemUseType.DAMAGE, (Item)AllItems.SUPER_GLUE.get());
    }

    public boolean func_145773_az() {
        return true;
    }
}

