/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.fluids.actors.SpoutTileEntity;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;

public class SpoutRenderer
extends SafeTileEntityRenderer<SpoutTileEntity> {
    static final AllBlockPartials[] BITS = new AllBlockPartials[]{AllBlockPartials.SPOUT_TOP, AllBlockPartials.SPOUT_MIDDLE, AllBlockPartials.SPOUT_BOTTOM};

    public SpoutRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(SpoutTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        SmartFluidTankBehaviour tank = te.tank;
        if (tank == null) {
            return;
        }
        SmartFluidTankBehaviour.TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        float level = primaryTank.getFluidLevel().getValue(partialTicks);
        if (!fluidStack.isEmpty() && level != 0.0f) {
            float min = 0.15625f;
            float max = min + 0.6875f;
            float yOffset = 0.6875f * level;
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, (double)yOffset, 0.0);
            FluidRenderer.renderTiledFluidBB(fluidStack, min, min - yOffset, min, max, min, max, buffer, ms, light, false);
            ms.func_227865_b_();
        }
        int processingTicks = te.processingTicks;
        float processingPT = (float)te.processingTicks - partialTicks;
        float processingProgress = 1.0f - (processingPT - 5.0f) / 10.0f;
        processingProgress = MathHelper.func_76131_a((float)processingProgress, (float)0.0f, (float)1.0f);
        float radius = 0.0f;
        if (processingTicks != -1) {
            radius = (float)(Math.pow(2.0f * processingProgress - 1.0f, 2.0) - 1.0);
            AxisAlignedBB bb = new AxisAlignedBB(0.5, 0.5, 0.5, 0.5, -1.2, 0.5).func_186662_g((double)(radius / 32.0f));
            FluidRenderer.renderTiledFluidBB(fluidStack, (float)bb.field_72340_a, (float)bb.field_72338_b, (float)bb.field_72339_c, (float)bb.field_72336_d, (float)bb.field_72337_e, (float)bb.field_72334_f, buffer, ms, light, true);
        }
        float squeeze = radius;
        if (processingPT < 0.0f) {
            squeeze = 0.0f;
        } else if (processingPT < 2.0f) {
            squeeze = MathHelper.func_219799_g((float)(processingPT / 2.0f), (float)0.0f, (float)-1.0f);
        } else if (processingPT < 10.0f) {
            squeeze = -1.0f;
        }
        ms.func_227860_a_();
        for (AllBlockPartials bit : BITS) {
            bit.renderOn(te.func_195044_w()).light(light).renderInto(ms, buffer.getBuffer(RenderType.func_228639_c_()));
            ms.func_227861_a_(0.0, (double)(-3.0f * squeeze / 32.0f), 0.0);
        }
        ms.func_227865_b_();
    }
}

