/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.tank;

import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.function.Consumer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CreativeFluidTankTileEntity
extends FluidTankTileEntity {
    public CreativeFluidTankTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    protected SmartFluidTank createInventory() {
        return new CreativeSmartFluidTank(CreativeFluidTankTileEntity.getCapacityMultiplier(), this::onFluidStackChanged);
    }

    public static class CreativeSmartFluidTank
    extends SmartFluidTank {
        public CreativeSmartFluidTank(int capacity, Consumer<FluidStack> updateCallback) {
            super(capacity, updateCallback);
        }

        public int getFluidAmount() {
            return this.getFluid().isEmpty() ? 0 : this.getTankCapacity(0);
        }

        public void setContainedFluid(FluidStack fluidStack) {
            this.fluid = fluidStack.copy();
            if (!fluidStack.isEmpty()) {
                this.fluid.setAmount(this.getTankCapacity(0));
            }
            this.onContentsChanged();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return resource.getAmount();
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return super.drain(resource, IFluidHandler.FluidAction.SIMULATE);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return super.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
        }
    }
}

