/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.contraptions.processing.BasinBlock;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.tileEntity.renderer.SmartTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class BasinRenderer
extends SmartTileEntityRenderer<BasinTileEntity> {
    public BasinRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(BasinTileEntity basin, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        super.renderSafe(basin, partialTicks, ms, buffer, light, overlay);
        float fluidLevel = this.renderFluids(basin, partialTicks, ms, buffer, light, overlay);
        float level = MathHelper.func_76131_a((float)(fluidLevel - 0.3f), (float)0.125f, (float)0.6f);
        ms.func_227860_a_();
        BlockPos pos = basin.func_174877_v();
        ms.func_227861_a_(0.5, (double)0.2f, 0.5);
        MatrixStacker.of(ms).rotateY(basin.ingredientRotation.getValue(partialTicks));
        Random r = new Random(pos.hashCode());
        Vec3d baseVector = new Vec3d(0.125, (double)level, 0.0);
        IItemHandlerModifiable inv = (IItemHandlerModifiable)basin.itemCapability.orElse((Object)new ItemStackHandler());
        int itemCount = 0;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            if (inv.getStackInSlot(slot).func_190926_b()) continue;
            ++itemCount;
        }
        if (itemCount == 1) {
            baseVector = new Vec3d(0.0, (double)level, 0.0);
        }
        float anglePartition = 360.0f / (float)itemCount;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            ms.func_227860_a_();
            if (fluidLevel > 0.0f) {
                ms.func_227861_a_(0.0, (double)((MathHelper.func_76126_a((float)(AnimationTickHolder.getRenderTick() / 12.0f + anglePartition * (float)itemCount)) + 1.5f) * 1.0f / 32.0f), 0.0);
            }
            Vec3d itemPosition = VecHelper.rotate(baseVector, anglePartition * (float)itemCount, Direction.Axis.Y);
            ms.func_227861_a_(itemPosition.field_72450_a, itemPosition.field_72448_b, itemPosition.field_72449_c);
            MatrixStacker.of(ms).rotateY(anglePartition * (float)itemCount + 35.0f).rotateX(65.0);
            for (int i = 0; i <= stack.func_190916_E() / 8; ++i) {
                ms.func_227860_a_();
                Vec3d vec = VecHelper.offsetRandomly(Vec3d.field_186680_a, r, 0.0625f);
                ms.func_227861_a_(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                this.renderItem(ms, buffer, light, overlay, stack);
                ms.func_227865_b_();
            }
            ms.func_227865_b_();
            --itemCount;
        }
        ms.func_227865_b_();
        BlockState blockState = basin.func_195044_w();
        if (!(blockState.func_177230_c() instanceof BasinBlock)) {
            return;
        }
        Direction direction = (Direction)blockState.func_177229_b((IProperty)BasinBlock.FACING);
        if (direction == Direction.DOWN) {
            return;
        }
        Vec3d directionVec = new Vec3d(direction.func_176730_m());
        Vec3d outVec = VecHelper.getCenterOf((Vec3i)BlockPos.field_177992_a).func_178787_e(directionVec.func_186678_a(0.55).func_178786_a(0.0, 0.5, 0.0));
        boolean outToBasin = basin.func_145831_w().func_180495_p(basin.func_174877_v().func_177972_a(direction)).func_177230_c() instanceof BasinBlock;
        for (IntAttached<ItemStack> intAttached : basin.visualizedOutputItems) {
            float progress = 1.0f - ((float)((Integer)intAttached.getFirst()).intValue() - partialTicks) / 10.0f;
            if (!outToBasin && progress > 0.35f) continue;
            ms.func_227860_a_();
            MatrixStacker.of(ms).translate(outVec).translate(new Vec3d(0.0, (double)Math.max(-0.55f, -(progress * progress * 2.0f)), 0.0)).translate(directionVec.func_186678_a((double)(progress * 0.5f))).rotateY(AngleHelper.horizontalAngle(direction)).rotateX(progress * 180.0f);
            this.renderItem(ms, buffer, light, overlay, intAttached.getValue());
            ms.func_227865_b_();
        }
    }

    protected void renderItem(MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay, ItemStack stack) {
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.GROUND, light, overlay, ms, buffer);
    }

    protected float renderFluids(BasinTileEntity basin, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        SmartFluidTankBehaviour inputFluids = basin.getBehaviour(SmartFluidTankBehaviour.INPUT);
        SmartFluidTankBehaviour outputFluids = basin.getBehaviour(SmartFluidTankBehaviour.OUTPUT);
        SmartFluidTankBehaviour[] tanks = new SmartFluidTankBehaviour[]{inputFluids, outputFluids};
        float totalUnits = basin.getTotalFluidUnits(partialTicks);
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        float fluidLevel = MathHelper.func_76131_a((float)(totalUnits / 2000.0f), (float)0.0f, (float)1.0f);
        float xMin = 0.125f;
        float xMax = 0.125f;
        float yMin = 0.125f;
        float yMax = 0.125f + 0.75f * fluidLevel;
        float zMin = 0.125f;
        float zMax = 0.875f;
        for (SmartFluidTankBehaviour behaviour : tanks) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                float units;
                FluidStack renderedFluid = tankSegment.getRenderedFluid();
                if (renderedFluid.isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
                float partial = MathHelper.func_76131_a((float)(units / totalUnits), (float)0.0f, (float)1.0f);
                FluidRenderer.renderTiledFluidBB(renderedFluid, xMin, 0.125f, 0.125f, xMax += partial * 12.0f / 16.0f, yMax, 0.875f, buffer, ms, light, false);
                xMin = xMax;
            }
        }
        return yMax;
    }
}

