/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing.burner;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlazeBurnerBlockItem
extends BlockItem {
    private final boolean capturedBlaze;

    public static BlazeBurnerBlockItem empty(Item.Properties properties) {
        return new BlazeBurnerBlockItem((Block)AllBlocks.BLAZE_BURNER.get(), properties, false);
    }

    public static BlazeBurnerBlockItem withBlaze(Block block, Item.Properties properties) {
        return new BlazeBurnerBlockItem(block, properties, true);
    }

    public void func_195946_a(Map<Block, Item> p_195946_1_, Item p_195946_2_) {
        if (!this.hasCapturedBlaze()) {
            return;
        }
        super.func_195946_a(p_195946_1_, p_195946_2_);
    }

    private BlazeBurnerBlockItem(Block block, Item.Properties properties, boolean capturedBlaze) {
        super(block, properties);
        this.capturedBlaze = capturedBlaze;
    }

    public void func_150895_a(ItemGroup p_150895_1_, NonNullList<ItemStack> p_150895_2_) {
        if (!this.hasCapturedBlaze()) {
            return;
        }
        super.func_150895_a(p_150895_1_, p_150895_2_);
    }

    public String func_77658_a() {
        return this.hasCapturedBlaze() ? super.func_77658_a() : "item.create." + this.getRegistryName().func_110623_a();
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (this.hasCapturedBlaze()) {
            return super.func_195939_a(context);
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        TileEntity te = world.func_175625_s(pos);
        PlayerEntity player = context.func_195999_j();
        if (!(te instanceof MobSpawnerTileEntity)) {
            return super.func_195939_a(context);
        }
        AbstractSpawner spawner = ((MobSpawnerTileEntity)te).func_145881_a();
        ArrayList<Object> possibleSpawns = (ArrayList<Object>)ObfuscationReflectionHelper.getPrivateValue(AbstractSpawner.class, (Object)spawner, (String)"field_98285_e");
        if (possibleSpawns.isEmpty()) {
            possibleSpawns = new ArrayList<Object>();
            possibleSpawns.add(ObfuscationReflectionHelper.getPrivateValue(AbstractSpawner.class, (Object)spawner, (String)"field_98282_f"));
        }
        ResourceLocation blazeId = EntityType.field_200792_f.getRegistryName();
        for (WeightedSpawnerEntity weightedSpawnerEntity : possibleSpawns) {
            ResourceLocation spawnerEntityId = new ResourceLocation(weightedSpawnerEntity.func_185277_b().func_74779_i("id"));
            if (!spawnerEntityId.equals((Object)blazeId)) continue;
            this.spawnCaptureEffects(world, VecHelper.getCenterOf((Vec3i)pos));
            if (world.field_72995_K || player == null) {
                return ActionResultType.SUCCESS;
            }
            this.giveBurnerItemTo(player, context.func_195996_i(), context.func_221531_n());
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    public boolean func_111207_a(ItemStack heldItem, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (this.hasCapturedBlaze()) {
            return false;
        }
        if (!(entity instanceof BlazeEntity)) {
            return false;
        }
        World world = player.field_70170_p;
        this.spawnCaptureEffects(world, entity.func_213303_ch());
        if (world.field_72995_K) {
            return true;
        }
        this.giveBurnerItemTo(player, heldItem, hand);
        entity.func_70106_y();
        return false;
    }

    protected void giveBurnerItemTo(PlayerEntity player, ItemStack heldItem, Hand hand) {
        ItemStack filled = AllBlocks.BLAZE_BURNER.asStack();
        if (!player.func_184812_l_()) {
            heldItem.func_190918_g(1);
        }
        if (heldItem.func_190926_b()) {
            player.func_184611_a(hand, filled);
            return;
        }
        player.field_71071_by.func_191975_a(player.field_70170_p, filled);
    }

    private void spawnCaptureEffects(World world, Vec3d vec) {
        if (world.field_72995_K) {
            for (int i = 0; i < 40; ++i) {
                Vec3d motion = VecHelper.offsetRandomly(Vec3d.field_186680_a, world.field_73012_v, 0.125f);
                world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
                Vec3d circle = motion.func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a(0.5);
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, circle.field_72450_a, vec.field_72448_b, circle.field_72449_c, 0.0, -0.125, 0.0);
            }
            return;
        }
        BlockPos soundPos = new BlockPos(vec);
        world.func_184133_a(null, soundPos, SoundEvents.field_187603_D, SoundCategory.HOSTILE, 0.25f, 0.75f);
        world.func_184133_a(null, soundPos, SoundEvents.field_187646_bt, SoundCategory.HOSTILE, 0.5f, 0.75f);
    }

    public boolean hasCapturedBlaze() {
        return this.capturedBlaze;
    }
}

