/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.elementary;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.relays.advanced.SpeedControllerBlock;
import com.simibubi.create.content.contraptions.relays.elementary.AbstractShaftBlock;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CogWheelBlock
extends AbstractShaftBlock {
    boolean isLarge;

    private CogWheelBlock(boolean large, Block.Properties properties) {
        super(properties);
        this.isLarge = large;
    }

    public static CogWheelBlock small(Block.Properties properties) {
        return new CogWheelBlock(false, properties);
    }

    public static CogWheelBlock large(Block.Properties properties) {
        return new CogWheelBlock(true, properties);
    }

    public static boolean isSmallCog(BlockState state) {
        return AllBlocks.COGWHEEL.has(state);
    }

    public static boolean isLargeCog(BlockState state) {
        return AllBlocks.LARGE_COGWHEEL.has(state);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (this.isLarge ? AllShapes.LARGE_GEAR : AllShapes.SMALL_GEAR).get((Direction.Axis)state.func_177229_b((IProperty)AXIS));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        for (Direction facing : Iterate.directions) {
            BlockState blockState;
            if (facing.func_176740_k() == state.func_177229_b((IProperty)AXIS) || (blockState = worldIn.func_180495_p(pos.func_177972_a(facing))).func_196959_b((IProperty)AXIS) && facing.func_176740_k() == blockState.func_177229_b((IProperty)AXIS) || !CogWheelBlock.isLargeCog(blockState) && (!this.isLarge || !CogWheelBlock.isSmallCog(blockState))) continue;
            return false;
        }
        return true;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos placedOnPos = context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d());
        World world = context.func_195991_k();
        BlockState placedAgainst = world.func_180495_p(placedOnPos);
        Block block = placedAgainst.func_177230_c();
        if (context.func_195999_j() != null && context.func_195999_j().func_225608_bj_()) {
            return (BlockState)this.func_176223_P().func_206870_a((IProperty)AXIS, (Comparable)context.func_196000_l().func_176740_k());
        }
        BlockState stateBelow = world.func_180495_p(context.func_195995_a().func_177977_b());
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        if (AllBlocks.ROTATION_SPEED_CONTROLLER.has(stateBelow) && this.isLarge) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a))).func_206870_a((IProperty)AXIS, (Comparable)(stateBelow.func_177229_b(SpeedControllerBlock.HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        if (!(block instanceof IRotate) || !((IRotate)block).hasIntegratedCogwheel((IWorldReader)world, placedOnPos, placedAgainst)) {
            Direction.Axis preferredAxis = CogWheelBlock.getPreferredAxis(context);
            if (preferredAxis != null) {
                return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)AXIS, (Comparable)preferredAxis)).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
            }
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)AXIS, (Comparable)context.func_196000_l().func_176740_k())).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
        }
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)AXIS, (Comparable)((IRotate)block).getRotationAxis(placedAgainst));
    }

    @Override
    public float getParticleTargetRadius() {
        return this.isLarge ? 1.125f : 0.65f;
    }

    @Override
    public float getParticleInitialRadius() {
        return this.isLarge ? 1.0f : 0.75f;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((IItemProvider)this));
    }

    @Override
    public boolean hasIntegratedCogwheel(IWorldReader world, BlockPos pos, BlockState state) {
        return !this.isLarge;
    }
}

