/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.gauge;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.relays.gauge.GaugeShaper;
import com.simibubi.create.content.contraptions.relays.gauge.GaugeTileEntity;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class GaugeBlock
extends DirectionalAxisKineticBlock {
    public static final GaugeShaper GAUGE = GaugeShaper.make();
    protected Type type;

    public static GaugeBlock speed(Block.Properties properties) {
        return new GaugeBlock(properties, Type.SPEED);
    }

    public static GaugeBlock stress(Block.Properties properties) {
        return new GaugeBlock(properties, Type.STRESS);
    }

    protected GaugeBlock(Block.Properties properties, Type type) {
        super(properties);
        this.type = type;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        switch (this.type) {
            case SPEED: {
                return AllTileEntities.SPEEDOMETER.create();
            }
            case STRESS: {
                return AllTileEntities.STRESSOMETER.create();
            }
        }
        return null;
    }

    public MaterialColor func_180659_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return Blocks.field_196664_o.func_180659_g(state, worldIn, pos);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        Direction face = context.func_196000_l();
        BlockPos placedOnPos = context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d());
        BlockState placedOnState = world.func_180495_p(placedOnPos);
        Block block = placedOnState.func_177230_c();
        if (block instanceof IRotate && ((IRotate)block).hasShaftTowards((IWorldReader)world, placedOnPos, placedOnState, face)) {
            boolean lookPositive;
            BlockState toPlace = this.func_176223_P();
            Direction horizontalFacing = context.func_195992_f();
            Direction nearestLookingDirection = context.func_196010_d();
            boolean bl = lookPositive = nearestLookingDirection.func_176743_c() == Direction.AxisDirection.POSITIVE;
            toPlace = face.func_176740_k() == Direction.Axis.X ? (BlockState)((BlockState)toPlace.func_206870_a((IProperty)FACING, (Comparable)(lookPositive ? Direction.NORTH : Direction.SOUTH))).func_206870_a((IProperty)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(true)) : (face.func_176740_k() == Direction.Axis.Y ? (BlockState)((BlockState)toPlace.func_206870_a((IProperty)FACING, (Comparable)horizontalFacing.func_176734_d())).func_206870_a((IProperty)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(horizontalFacing.func_176740_k() == Direction.Axis.X)) : (BlockState)((BlockState)toPlace.func_206870_a((IProperty)FACING, (Comparable)(lookPositive ? Direction.WEST : Direction.EAST))).func_206870_a((IProperty)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(false)));
            return toPlace;
        }
        return super.func_196258_a(context);
    }

    @Override
    protected Direction getFacingForPlacement(BlockItemUseContext context) {
        return context.func_196000_l();
    }

    @Override
    protected boolean getAxisAlignmentForPlacement(BlockItemUseContext context) {
        return context.func_195992_f().func_176740_k() != Direction.Axis.X;
    }

    public boolean shouldRenderHeadOnFace(World world, BlockPos pos, BlockState state, Direction face) {
        if (face.func_176740_k().func_200128_b()) {
            return false;
        }
        if (face == ((Direction)state.func_177229_b((IProperty)FACING)).func_176734_d()) {
            return false;
        }
        if (face.func_176740_k() == this.getRotationAxis(state)) {
            return false;
        }
        if (this.getRotationAxis(state) == Direction.Axis.Y && face != state.func_177229_b((IProperty)FACING)) {
            return false;
        }
        BlockState blockState = world.func_180495_p(pos.func_177972_a(face));
        return !Block.func_220056_d((BlockState)blockState, (IBlockReader)world, (BlockPos)pos, (Direction)face.func_176734_d()) || blockState.func_185904_a() == Material.field_151592_s || world instanceof WrappedWorld;
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null || !(te instanceof GaugeTileEntity)) {
            return;
        }
        GaugeTileEntity gaugeTE = (GaugeTileEntity)te;
        if (gaugeTE.dialTarget == 0.0f) {
            return;
        }
        int color = gaugeTE.color;
        for (Direction face : Iterate.directions) {
            int particleCount;
            if (!this.shouldRenderHeadOnFace(worldIn, pos, stateIn, face)) continue;
            Vec3d rgb = ColorHelper.getRGB(color);
            Vec3d faceVec = new Vec3d(face.func_176730_m());
            Direction positiveFacing = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)face.func_176740_k());
            Vec3d positiveFaceVec = new Vec3d(positiveFacing.func_176730_m());
            int n = particleCount = gaugeTE.dialTarget > 1.0f ? 4 : 1;
            if (particleCount == 1 && rand.nextFloat() > 0.25f) continue;
            for (int i = 0; i < particleCount; ++i) {
                Vec3d mul = VecHelper.offsetRandomly(Vec3d.field_186680_a, rand, 0.25f).func_216369_h(new Vec3d(1.0, 1.0, 1.0).func_178788_d(positiveFaceVec)).func_72432_b().func_186678_a((double)0.3f);
                Vec3d offset = VecHelper.getCenterOf((Vec3i)pos).func_178787_e(faceVec.func_186678_a(0.55)).func_178787_e(mul);
                worldIn.func_195594_a((IParticleData)new RedstoneParticleData((float)rgb.field_72450_a, (float)rgb.field_72448_b, (float)rgb.field_72449_c, 1.0f), offset.field_72450_a, offset.field_72448_b, offset.field_72449_c, mul.field_72450_a, mul.field_72448_b, mul.field_72449_c);
            }
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return GAUGE.get((Direction)state.func_177229_b((IProperty)FACING), (Boolean)state.func_177229_b((IProperty)AXIS_ALONG_FIRST_COORDINATE));
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof GaugeTileEntity) {
            GaugeTileEntity gaugeTileEntity = (GaugeTileEntity)te;
            return MathHelper.func_76123_f((float)MathHelper.func_76131_a((float)(gaugeTileEntity.dialTarget * 14.0f), (float)0.0f, (float)15.0f));
        }
        return 0;
    }

    public static enum Type implements IStringSerializable
    {
        SPEED,
        STRESS;


        public String func_176610_l() {
            return Lang.asId(this.name());
        }
    }
}

