/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.symmetry;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.content.curiosities.symmetry.SymmetryWandItem;
import com.simibubi.create.content.curiosities.symmetry.mirror.CrossPlaneMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.EmptyMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.PlaneMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.SymmetryMirror;
import com.simibubi.create.content.curiosities.symmetry.mirror.TriplePlaneMirror;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.Label;
import com.simibubi.create.foundation.gui.widgets.ScrollInput;
import com.simibubi.create.foundation.gui.widgets.SelectionScrollInput;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.NbtPacket;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.network.PacketDistributor;

public class SymmetryWandScreen
extends AbstractSimiScreen {
    private ScrollInput areaType;
    private Label labelType;
    private ScrollInput areaAlign;
    private Label labelAlign;
    private IconButton confirmButton;
    private final String mirrorType = Lang.translate("gui.symmetryWand.mirrorType", new Object[0]);
    private final String orientation = Lang.translate("gui.symmetryWand.orientation", new Object[0]);
    private SymmetryMirror currentElement;
    private ItemStack wand;
    private Hand hand;

    public SymmetryWandScreen(ItemStack wand, Hand hand) {
        this.currentElement = SymmetryWandItem.getMirror(wand);
        if (this.currentElement instanceof EmptyMirror) {
            this.currentElement = new PlaneMirror(Vec3d.field_186680_a);
        }
        this.hand = hand;
        this.wand = wand;
    }

    public void init() {
        super.init();
        AllGuiTextures background = AllGuiTextures.WAND_OF_SYMMETRY;
        this.setWindowSize(background.width + 50, background.height + 50);
        this.labelType = new Label(this.guiLeft + 49, this.guiTop + 26, "").colored(-1).withShadow();
        this.labelAlign = new Label(this.guiLeft + 49, this.guiTop + 48, "").colored(-1).withShadow();
        int state = this.currentElement instanceof TriplePlaneMirror ? 2 : (this.currentElement instanceof CrossPlaneMirror ? 1 : 0);
        this.areaType = new SelectionScrollInput(this.guiLeft + 45, this.guiTop + 21, 109, 18).forOptions(SymmetryMirror.getMirrors()).titled(this.mirrorType).writingTo(this.labelType).setState(state);
        this.areaType.calling(position -> {
            switch (position) {
                case 0: {
                    this.currentElement = new PlaneMirror(this.currentElement.getPosition());
                    break;
                }
                case 1: {
                    this.currentElement = new CrossPlaneMirror(this.currentElement.getPosition());
                    break;
                }
                case 2: {
                    this.currentElement = new TriplePlaneMirror(this.currentElement.getPosition());
                    break;
                }
            }
            this.initAlign(this.currentElement);
        });
        this.widgets.clear();
        this.initAlign(this.currentElement);
        this.widgets.add(this.labelAlign);
        this.widgets.add(this.areaType);
        this.widgets.add(this.labelType);
        this.confirmButton = new IconButton(this.guiLeft + background.width - 33, this.guiTop + background.height - 24, AllIcons.I_CONFIRM);
        this.widgets.add(this.confirmButton);
    }

    private void initAlign(SymmetryMirror element) {
        if (this.areaAlign != null) {
            this.widgets.remove((Object)this.areaAlign);
        }
        this.areaAlign = new SelectionScrollInput(this.guiLeft + 45, this.guiTop + 43, 109, 18).forOptions(element.getAlignToolTips()).titled(this.orientation).writingTo(this.labelAlign).setState(element.getOrientationIndex()).calling(element::setOrientation);
        this.widgets.add(this.areaAlign);
    }

    @Override
    protected void renderWindow(int mouseX, int mouseY, float partialTicks) {
        AllGuiTextures.WAND_OF_SYMMETRY.draw((AbstractGui)this, this.guiLeft, this.guiTop);
        this.font.func_175063_a(this.wand.func_200301_q().func_150254_d(), (float)(this.guiLeft + 11), (float)(this.guiTop + 3), 0xFFFFFF);
        this.renderBlock();
        GuiGameElement.of(this.wand).at(this.guiLeft + 170, this.guiTop + 200).scale(4.0).rotate(-70.0, 20.0, 20.0).render();
    }

    protected void renderBlock() {
        RenderSystem.pushMatrix();
        MatrixStack ms = new MatrixStack();
        ms.func_227861_a_((double)((float)this.guiLeft + 25.5f), (double)(this.guiTop + 21), 20.0);
        ms.func_227863_a_(new Vector3f(0.3f, 1.0f, 0.0f).func_229187_a_(-22.5f));
        ms.func_227862_a_(16.0f, -16.0f, 16.0f);
        this.currentElement.applyModelTransform(ms);
        RenderSystem.multMatrix((Matrix4f)ms.func_227866_c_().func_227870_a_());
        GuiGameElement.of(this.currentElement.getModel()).render();
        RenderSystem.popMatrix();
    }

    public void removed() {
        ItemStack heldItem = this.minecraft.field_71439_g.func_184586_b(this.hand);
        CompoundNBT compound = heldItem.func_77978_p();
        compound.func_218657_a("symmetry", (INBT)this.currentElement.writeToNbt());
        heldItem.func_77982_d(compound);
        AllPackets.channel.send(PacketDistributor.SERVER.noArg(), (Object)new NbtPacket(heldItem, this.hand));
        this.minecraft.field_71439_g.func_184611_a(this.hand, heldItem);
        super.removed();
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        if (this.confirmButton.isHovered()) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            return true;
        }
        return super.mouseClicked(x, y, button);
    }
}

