/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.ColorHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.BlastFurnaceTileEntity;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.SmokerTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class InWorldProcessing {
    public static SplashingInv splashingInv = new SplashingInv();

    public static boolean canProcess(ItemEntity entity, Type type) {
        CompoundNBT compound;
        if (entity.getPersistentData().func_74764_b("CreateData") && (compound = entity.getPersistentData().func_74775_l("CreateData")).func_74764_b("Processing")) {
            CompoundNBT processing = compound.func_74775_l("Processing");
            if (Type.valueOf(processing.func_74779_i("Type")) != type) {
                boolean canProcess = InWorldProcessing.canProcess(entity.func_92059_d(), type, entity.field_70170_p);
                processing.func_74778_a("Type", type.name());
                if (!canProcess) {
                    processing.func_74768_a("Time", -1);
                }
                return canProcess;
            }
            if (processing.func_74762_e("Time") >= 0) {
                return true;
            }
            if (processing.func_74762_e("Time") == -1) {
                return false;
            }
        }
        return InWorldProcessing.canProcess(entity.func_92059_d(), type, entity.field_70170_p);
    }

    private static boolean canProcess(ItemStack stack, Type type, World world) {
        if (type == Type.BLASTING) {
            return true;
        }
        if (type == Type.SMOKING) {
            SmokerTileEntity smoker = new SmokerTileEntity();
            smoker.func_226984_a_(world, BlockPos.field_177992_a);
            smoker.func_70299_a(0, stack);
            Optional recipe = world.func_199532_z().func_215371_a(IRecipeType.field_222152_d, (IInventory)smoker, world);
            return recipe.isPresent();
        }
        if (type == Type.SPLASHING) {
            return InWorldProcessing.isWashable(stack, world);
        }
        return false;
    }

    public static boolean isWashable(ItemStack stack, World world) {
        splashingInv.func_70299_a(0, stack);
        Optional recipe = AllRecipeTypes.SPLASHING.find(splashingInv, world);
        return recipe.isPresent();
    }

    public static void applyProcessing(ItemEntity entity, Type type) {
        if (InWorldProcessing.decrementProcessingTime(entity, type) != 0) {
            return;
        }
        List<ItemStack> stacks = InWorldProcessing.process(entity.func_92059_d(), type, entity.field_70170_p);
        if (stacks == null) {
            return;
        }
        if (stacks.isEmpty()) {
            entity.func_70106_y();
            return;
        }
        entity.func_92058_a(stacks.remove(0));
        for (ItemStack additional : stacks) {
            ItemEntity entityIn = new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), additional);
            entityIn.func_213317_d(entity.func_213322_ci());
            entity.field_70170_p.func_217376_c((Entity)entityIn);
        }
    }

    public static TransportedItemStackHandlerBehaviour.TransportedResult applyProcessing(TransportedItemStack transported, World world, Type type) {
        TransportedItemStackHandlerBehaviour.TransportedResult ignore = TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        if (transported.processedBy != type) {
            int processingTime;
            transported.processedBy = type;
            int timeModifierForStackSize = (transported.stack.func_190916_E() - 1) / 16 + 1;
            transported.processingTime = processingTime = (Integer)AllConfigs.SERVER.kinetics.inWorldProcessingTime.get() * timeModifierForStackSize + 1;
            if (!InWorldProcessing.canProcess(transported.stack, type, world)) {
                transported.processingTime = -1;
            }
            return ignore;
        }
        if (transported.processingTime == -1) {
            return ignore;
        }
        if (transported.processingTime-- > 0) {
            return ignore;
        }
        List<ItemStack> stacks = InWorldProcessing.process(transported.stack, type, world);
        if (stacks == null) {
            return ignore;
        }
        ArrayList<TransportedItemStack> transportedStacks = new ArrayList<TransportedItemStack>();
        for (ItemStack additional : stacks) {
            TransportedItemStack newTransported = transported.getSimilar();
            newTransported.stack = additional.func_77946_l();
            transportedStacks.add(newTransported);
        }
        return TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(transportedStacks);
    }

    private static List<ItemStack> process(ItemStack stack, Type type, World world) {
        if (type == Type.SPLASHING) {
            splashingInv.func_70299_a(0, stack);
            Optional recipe = AllRecipeTypes.SPLASHING.find(splashingInv, world);
            if (recipe.isPresent()) {
                return InWorldProcessing.applyRecipeOn(stack, (IRecipe)recipe.get());
            }
            return null;
        }
        SmokerTileEntity smoker = new SmokerTileEntity();
        smoker.func_226984_a_(world, BlockPos.field_177992_a);
        smoker.func_70299_a(0, stack);
        Optional smokingRecipe = world.func_199532_z().func_215371_a(IRecipeType.field_222152_d, (IInventory)smoker, world);
        if (type == Type.BLASTING) {
            FurnaceTileEntity furnace = new FurnaceTileEntity();
            furnace.func_226984_a_(world, BlockPos.field_177992_a);
            furnace.func_70299_a(0, stack);
            Optional smeltingRecipe = world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)furnace, world);
            if (!smokingRecipe.isPresent()) {
                if (smeltingRecipe.isPresent()) {
                    return InWorldProcessing.applyRecipeOn(stack, (IRecipe)smeltingRecipe.get());
                }
                BlastFurnaceTileEntity blastFurnace = new BlastFurnaceTileEntity();
                blastFurnace.func_226984_a_(world, BlockPos.field_177992_a);
                blastFurnace.func_70299_a(0, stack);
                Optional blastingRecipe = world.func_199532_z().func_215371_a(IRecipeType.field_222151_c, (IInventory)blastFurnace, world);
                if (blastingRecipe.isPresent()) {
                    return InWorldProcessing.applyRecipeOn(stack, (IRecipe)blastingRecipe.get());
                }
            }
            return Collections.emptyList();
        }
        if (type == Type.SMOKING && smokingRecipe.isPresent()) {
            return InWorldProcessing.applyRecipeOn(stack, (IRecipe)smokingRecipe.get());
        }
        return null;
    }

    private static int decrementProcessingTime(ItemEntity entity, Type type) {
        CompoundNBT processing;
        CompoundNBT createData;
        CompoundNBT nbt = entity.getPersistentData();
        if (!nbt.func_74764_b("CreateData")) {
            nbt.func_218657_a("CreateData", (INBT)new CompoundNBT());
        }
        if (!(createData = nbt.func_74775_l("CreateData")).func_74764_b("Processing")) {
            createData.func_218657_a("Processing", (INBT)new CompoundNBT());
        }
        if (!(processing = createData.func_74775_l("Processing")).func_74764_b("Type") || Type.valueOf(processing.func_74779_i("Type")) != type) {
            processing.func_74778_a("Type", type.name());
            int timeModifierForStackSize = (entity.func_92059_d().func_190916_E() - 1) / 16 + 1;
            int processingTime = (Integer)AllConfigs.SERVER.kinetics.inWorldProcessingTime.get() * timeModifierForStackSize + 1;
            processing.func_74768_a("Time", processingTime);
        }
        int value = processing.func_74762_e("Time") - 1;
        processing.func_74768_a("Time", value);
        return value;
    }

    public static void applyRecipeOn(ItemEntity entity, IRecipe<?> recipe) {
        List<ItemStack> stacks = InWorldProcessing.applyRecipeOn(entity.func_92059_d(), recipe);
        if (stacks == null) {
            return;
        }
        if (stacks.isEmpty()) {
            entity.func_70106_y();
            return;
        }
        entity.func_92058_a(stacks.remove(0));
        for (ItemStack additional : stacks) {
            ItemEntity entityIn = new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), additional);
            entityIn.func_213317_d(entity.func_213322_ci());
            entity.field_70170_p.func_217376_c((Entity)entityIn);
        }
    }

    private static List<ItemStack> applyRecipeOn(ItemStack stackIn, IRecipe<?> recipe) {
        ArrayList<ItemStack> stacks;
        if (recipe instanceof ProcessingRecipe) {
            stacks = new ArrayList();
            for (int i = 0; i < stackIn.func_190916_E(); ++i) {
                List<ItemStack> rollResults = ((ProcessingRecipe)recipe).rollResults();
                for (ItemStack stack : rollResults) {
                    for (ItemStack previouslyRolled : stacks) {
                        if (stack.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)previouslyRolled)) continue;
                        int amount = Math.min(previouslyRolled.func_77976_d() - previouslyRolled.func_190916_E(), stack.func_190916_E());
                        previouslyRolled.func_190917_f(amount);
                        stack.func_190918_g(amount);
                    }
                    if (stack.func_190926_b()) continue;
                    stacks.add(stack);
                }
            }
        } else {
            ItemStack out = recipe.func_77571_b().func_77946_l();
            stacks = ItemHelper.multipliedOutput(stackIn, out);
        }
        return stacks;
    }

    public static void spawnParticlesForProcessing(@Nullable World world, Vec3d vec, Type type) {
        if (world == null || !world.field_72995_K) {
            return;
        }
        if (world.field_73012_v.nextInt(8) != 0) {
            return;
        }
        switch (type) {
            case BLASTING: {
                world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, vec.field_72450_a, vec.field_72448_b + 0.25, vec.field_72449_c, 0.0, 0.0625, 0.0);
                break;
            }
            case SMOKING: {
                world.func_195594_a((IParticleData)ParticleTypes.field_197598_I, vec.field_72450_a, vec.field_72448_b + 0.25, vec.field_72449_c, 0.0, 0.0625, 0.0);
                break;
            }
            case SPLASHING: {
                Vec3d color = ColorHelper.getRGB(22015);
                world.func_195594_a((IParticleData)new RedstoneParticleData((float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c, 1.0f), vec.field_72450_a + (double)((world.field_73012_v.nextFloat() - 0.5f) * 0.5f), vec.field_72448_b + 0.5, vec.field_72449_c + (double)((world.field_73012_v.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197602_M, vec.field_72450_a + (double)((world.field_73012_v.nextFloat() - 0.5f) * 0.5f), vec.field_72448_b + 0.5, vec.field_72449_c + (double)((world.field_73012_v.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
                break;
            }
        }
    }

    public static enum Type {
        SMOKING,
        BLASTING,
        SPLASHING;


        public static Type byBlock(IBlockReader reader, BlockPos pos) {
            BlockState blockState = reader.func_180495_p(pos);
            IFluidState fluidState = reader.func_204610_c(pos);
            if (fluidState.func_206886_c() == Fluids.field_204546_a || fluidState.func_206886_c() == Fluids.field_207212_b) {
                return SPLASHING;
            }
            Block block = blockState.func_177230_c();
            if (block == Blocks.field_150480_ab || AllBlocks.LIT_BLAZE_BURNER.has(blockState) || block == Blocks.field_222433_lV && ((Boolean)blockState.func_177229_b((IProperty)CampfireBlock.field_220101_b)).booleanValue() || BlazeBurnerBlock.getHeatLevelOf(blockState) == BlazeBurnerBlock.HeatLevel.SMOULDERING) {
                return SMOKING;
            }
            if (block == Blocks.field_150353_l || BlazeBurnerBlock.getHeatLevelOf(blockState).isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
                return BLASTING;
            }
            return null;
        }
    }

    public static class SplashingInv
    extends RecipeWrapper {
        public SplashingInv() {
            super((IItemHandlerModifiable)new ItemStackHandler(1));
        }
    }
}

