/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.depot.DepotItemHandler;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.BeltProcessingBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.function.Function;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class DepotTileEntity
extends SmartTileEntity {
    TransportedItemStack heldItem;
    ItemStackHandler processingOutputBuffer;
    DepotItemHandler itemHandler = new DepotItemHandler(this);
    LazyOptional<DepotItemHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    private TransportedItemStackHandlerBehaviour transportedHandler;

    public DepotTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.processingOutputBuffer = new ItemStackHandler(8){

            protected void onContentsChanged(int slot) {
                DepotTileEntity.this.func_70296_d();
                DepotTileEntity.this.sendData();
            }
        };
    }

    @Override
    public void func_73660_a() {
        BeltProcessingBehaviour.ProcessingResult result;
        super.func_73660_a();
        if (this.heldItem == null) {
            return;
        }
        this.heldItem.prevBeltPosition = this.heldItem.beltPosition;
        this.heldItem.prevSideOffset = this.heldItem.sideOffset;
        float diff = 0.5f - this.heldItem.beltPosition;
        if (diff > 0.001953125f) {
            if (diff > 0.03125f && !BeltHelper.isItemUpright(this.heldItem.stack)) {
                ++this.heldItem.angle;
            }
            this.heldItem.beltPosition += diff / 4.0f;
        }
        if (diff > 0.0625f) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.handleBeltFunnelOutput()) {
            return;
        }
        BeltProcessingBehaviour processingBehaviour = TileEntityBehaviour.get((IBlockReader)this.field_145850_b, this.field_174879_c.func_177981_b(2), BeltProcessingBehaviour.TYPE);
        if (processingBehaviour == null) {
            return;
        }
        if (!this.heldItem.locked && BeltProcessingBehaviour.isBlocked((IBlockReader)this.field_145850_b, this.field_174879_c)) {
            return;
        }
        ItemStack previousItem = this.heldItem.stack;
        boolean wasLocked = this.heldItem.locked;
        BeltProcessingBehaviour.ProcessingResult processingResult = result = wasLocked ? processingBehaviour.handleHeldItem(this.heldItem, this.transportedHandler) : processingBehaviour.handleReceivedItem(this.heldItem, this.transportedHandler);
        if (result == BeltProcessingBehaviour.ProcessingResult.REMOVE) {
            this.heldItem = null;
            this.sendData();
            return;
        }
        boolean bl = this.heldItem.locked = result == BeltProcessingBehaviour.ProcessingResult.HOLD;
        if (this.heldItem.locked != wasLocked || !previousItem.equals(this.heldItem.stack, false)) {
            this.sendData();
        }
    }

    private boolean handleBeltFunnelOutput() {
        for (int slot = 0; slot < this.processingOutputBuffer.getSlots(); ++slot) {
            ItemStack previousItem = this.processingOutputBuffer.getStackInSlot(slot);
            if (previousItem.func_190926_b()) continue;
            ItemStack afterInsert = this.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(previousItem, null);
            if (previousItem.func_190916_E() == afterInsert.func_190916_E()) continue;
            this.processingOutputBuffer.setStackInSlot(slot, afterInsert);
            this.notifyUpdate();
            return true;
        }
        ItemStack previousItem = this.heldItem.stack;
        ItemStack afterInsert = this.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(previousItem, null);
        if (previousItem.func_190916_E() != afterInsert.func_190916_E()) {
            if (afterInsert.func_190926_b()) {
                this.heldItem = null;
            } else {
                this.heldItem.stack = afterInsert;
            }
            this.notifyUpdate();
            return true;
        }
        return false;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.lazyItemHandler != null) {
            this.lazyItemHandler.invalidate();
        }
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        if (this.heldItem != null) {
            compound.func_218657_a("HeldItem", (INBT)this.heldItem.serializeNBT());
        }
        compound.func_218657_a("OutputBuffer", (INBT)this.processingOutputBuffer.serializeNBT());
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundNBT compound, boolean clientPacket) {
        this.heldItem = null;
        if (compound.func_74764_b("HeldItem")) {
            this.heldItem = TransportedItemStack.read(compound.func_74775_l("HeldItem"));
        }
        this.processingOutputBuffer.deserializeNBT(compound.func_74775_l("OutputBuffer"));
        super.read(compound, clientPacket);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide));
        this.transportedHandler = new TransportedItemStackHandlerBehaviour(this, this::applyToAllItems).withStackPlacement(this::getWorldPositionOf);
        behaviours.add(this.transportedHandler);
    }

    public ItemStack getHeldItemStack() {
        return this.heldItem == null ? ItemStack.field_190927_a : this.heldItem.stack;
    }

    public void setHeldItem(TransportedItemStack heldItem) {
        this.heldItem = heldItem;
    }

    public void setCenteredHeldItem(TransportedItemStack heldItem) {
        this.heldItem = heldItem;
        this.heldItem.beltPosition = 0.5f;
        this.heldItem.prevBeltPosition = 0.5f;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private ItemStack tryInsertingFromSide(TransportedItemStack transportedStack, Direction side, boolean simulate) {
        ItemStack inserted = transportedStack.stack;
        ItemStack empty = ItemStack.field_190927_a;
        if (!this.getHeldItemStack().func_190926_b()) {
            return inserted;
        }
        if (!this.isOutputEmpty()) {
            return inserted;
        }
        if (simulate) {
            return empty;
        }
        transportedStack = transportedStack.copy();
        transportedStack.beltPosition = side.func_176740_k().func_200128_b() ? 0.5f : 0.0f;
        transportedStack.insertedFrom = side;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        this.setHeldItem(transportedStack);
        this.func_70296_d();
        this.sendData();
        return empty;
    }

    private void applyToAllItems(float maxDistanceFromCentre, Function<TransportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult> processFunction) {
        if (this.heldItem == null) {
            return;
        }
        if (0.5f - this.heldItem.beltPosition > maxDistanceFromCentre) {
            return;
        }
        boolean dirty = false;
        TransportedItemStack transportedItemStack = this.heldItem;
        ItemStack stackBefore = transportedItemStack.stack.func_77946_l();
        TransportedItemStackHandlerBehaviour.TransportedResult result = processFunction.apply(transportedItemStack);
        if (result == null || result.didntChangeFrom(stackBefore)) {
            return;
        }
        dirty = true;
        this.heldItem = null;
        if (result.hasHeldOutput()) {
            this.setCenteredHeldItem(result.getHeldOutput());
        }
        for (TransportedItemStack added : result.getOutputs()) {
            if (this.getHeldItemStack().func_190926_b()) {
                this.setCenteredHeldItem(added);
                continue;
            }
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)this.processingOutputBuffer, (ItemStack)added.stack, (boolean)false);
            Vec3d vec = VecHelper.getCenterOf((Vec3i)this.field_174879_c);
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)vec.field_72450_a, (double)(vec.field_72448_b + 0.5), (double)vec.field_72449_c, (ItemStack)remainder);
        }
        if (dirty) {
            this.func_70296_d();
            this.sendData();
        }
    }

    public boolean isOutputEmpty() {
        for (int i = 0; i < this.processingOutputBuffer.getSlots(); ++i) {
            if (this.processingOutputBuffer.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private Vec3d getWorldPositionOf(TransportedItemStack transported) {
        Vec3d offsetVec = new Vec3d(0.5, 0.875, 0.5);
        return offsetVec.func_178787_e(new Vec3d((Vec3i)this.field_174879_c));
    }
}

