/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.diodes;

import com.simibubi.create.content.logistics.block.diodes.AdjustableRepeaterBlock;
import com.simibubi.create.content.logistics.block.diodes.AdjustableRepeaterScrollSlot;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.MathHelper;

public class AdjustableRepeaterTileEntity
extends SmartTileEntity {
    public int state;
    public boolean charging;
    ScrollValueBehaviour maxState;

    public AdjustableRepeaterTileEntity(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.maxState = new ScrollValueBehaviour(Lang.translate("generic.delay", new Object[0]), this, new AdjustableRepeaterScrollSlot()).between(1, 36000);
        this.maxState.withStepFunction(this::step);
        this.maxState.withFormatter(this::format);
        this.maxState.withUnit(this::getUnit);
        this.maxState.withCallback(this::onMaxDelayChanged);
        behaviours.add(this.maxState);
    }

    private void onMaxDelayChanged(int newMax) {
        this.state = MathHelper.func_76125_a((int)this.state, (int)0, (int)newMax);
        this.sendData();
    }

    @Override
    protected void read(CompoundNBT compound, boolean clientPacket) {
        this.state = compound.func_74762_e("State");
        this.charging = compound.func_74767_n("Charging");
        super.read(compound, clientPacket);
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74768_a("State", this.state);
        compound.func_74757_a("Charging", this.charging);
        super.write(compound, clientPacket);
    }

    private int step(ScrollValueBehaviour.StepContext context) {
        int value = context.currentValue;
        if (!context.forward) {
            --value;
        }
        if (value < 20) {
            return 1;
        }
        if (value < 1200) {
            return 20;
        }
        return 1200;
    }

    private String format(int value) {
        if (value < 20) {
            return value + "t";
        }
        if (value < 1200) {
            return value / 20 + "s";
        }
        return value / 20 / 60 + "m";
    }

    private String getUnit(int value) {
        if (value < 20) {
            return Lang.translate("generic.unit.ticks", new Object[0]);
        }
        if (value < 1200) {
            return Lang.translate("generic.unit.seconds", new Object[0]);
        }
        return Lang.translate("generic.unit.minutes", new Object[0]);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        boolean powered = (Boolean)this.func_195044_w().func_177229_b((IProperty)RedstoneDiodeBlock.field_196348_c);
        boolean powering = (Boolean)this.func_195044_w().func_177229_b((IProperty)AdjustableRepeaterBlock.POWERING);
        boolean atMax = this.state >= this.maxState.getValue();
        boolean atMin = this.state <= 0;
        this.updateState(powered, powering, atMax, atMin);
    }

    public boolean hasFastRenderer() {
        return true;
    }

    protected void updateState(boolean powered, boolean powering, boolean atMax, boolean atMin) {
        if (!this.charging && powered) {
            this.charging = true;
        }
        if (this.charging && atMax) {
            if (!powering && !this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((IProperty)AdjustableRepeaterBlock.POWERING, (Comparable)Boolean.valueOf(true)));
            }
            if (!powered) {
                this.charging = false;
            }
            return;
        }
        if (!this.charging && atMin) {
            if (powering && !this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((IProperty)AdjustableRepeaterBlock.POWERING, (Comparable)Boolean.valueOf(false)));
            }
            return;
        }
        this.state += this.charging ? 1 : -1;
    }
}

