/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.saw.SawTileEntity;
import com.simibubi.create.content.contraptions.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.chute.ChuteTileEntity;
import com.simibubi.create.content.logistics.block.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelFilterSlotPositioning;
import com.simibubi.create.content.logistics.block.redstone.ContentObserverBlock;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingValue;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FunnelTileEntity
extends SmartTileEntity
implements IHaveHoveringInformation {
    private FilteringBehaviour filtering;
    private InvManipulationBehaviour invManipulation;
    private InvManipulationBehaviour autoExtractor;
    private int extractionCooldown = 0;
    int sendFlap;
    InterpolatedChasingValue flap = new InterpolatedChasingValue().start(0.25f).target(0.0f).withSpeed(0.05f);

    public FunnelTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public Mode determineCurrentMode() {
        BlockState state = this.func_195044_w();
        if (!FunnelBlock.isFunnel(state)) {
            return Mode.INVALID;
        }
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208194_u) && ((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u)).booleanValue()) {
            return Mode.PAUSED;
        }
        if (FunnelBlock.getFunnelFacing(state) == Direction.UP && this.autoExtractor.hasInventory()) {
            return Mode.HOPPER;
        }
        if (state.func_177230_c() instanceof BeltFunnelBlock) {
            BeltFunnelBlock.Shape shape = (BeltFunnelBlock.Shape)((Object)state.func_177229_b(BeltFunnelBlock.SHAPE));
            if (shape == BeltFunnelBlock.Shape.PULLING) {
                return Mode.TAKING_FROM_BELT;
            }
            if (shape == BeltFunnelBlock.Shape.PUSHING) {
                return Mode.PUSHING_TO_BELT;
            }
            BeltTileEntity belt = BeltHelper.getSegmentTE((IWorld)this.field_145850_b, this.field_174879_c.func_177977_b());
            if (belt != null) {
                return belt.getMovementFacing() == state.func_177229_b((IProperty)BeltFunnelBlock.field_185512_D) ? Mode.PUSHING_TO_BELT : Mode.TAKING_FROM_BELT;
            }
        }
        return Mode.COLLECT;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.flap.tick();
        Mode mode = this.determineCurrentMode();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (mode == Mode.PAUSED) {
            this.extractionCooldown = 0;
        }
        if (mode == Mode.TAKING_FROM_BELT) {
            return;
        }
        if (this.extractionCooldown > 0) {
            --this.extractionCooldown;
            return;
        }
        if (mode == Mode.PUSHING_TO_BELT) {
            this.activateExtractingBeltFunnel();
        }
        if (mode == Mode.HOPPER) {
            this.activateHopper();
        }
    }

    private void activateHopper() {
        if (!this.invManipulation.hasInventory()) {
            return;
        }
        int amountToExtract = this.autoExtractor.getAmountFromFilter();
        if (!this.filtering.isActive()) {
            amountToExtract = 1;
        }
        Predicate<ItemStack> filter = s -> !this.filtering.isActive() || this.filtering.test((ItemStack)s);
        Function<ItemStack, Integer> amountThreshold = s -> {
            int maxStackSize = s.func_77976_d();
            return maxStackSize - this.invManipulation.simulate().insert(ItemHandlerHelper.copyStackWithSize((ItemStack)s, (int)maxStackSize)).func_190916_E();
        };
        if (amountToExtract != -1 && !this.invManipulation.simulate().insert(this.autoExtractor.simulate().extract(amountToExtract, filter)).func_190926_b()) {
            return;
        }
        ItemStack stack = this.autoExtractor.extract(amountToExtract, filter, amountThreshold);
        if (stack.func_190926_b()) {
            return;
        }
        this.onTransfer(stack);
        this.invManipulation.insert(stack);
        this.startCooldown();
    }

    private void activateExtractingBeltFunnel() {
        BlockState blockState = this.func_195044_w();
        Direction facing = (Direction)blockState.func_177229_b((IProperty)BeltFunnelBlock.field_185512_D);
        DirectBeltInputBehaviour inputBehaviour = TileEntityBehaviour.get((IBlockReader)this.field_145850_b, this.field_174879_c.func_177977_b(), DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour == null) {
            return;
        }
        if (!inputBehaviour.canInsertFromSide(facing)) {
            return;
        }
        int amountToExtract = this.getAmountToExtract();
        ItemStack stack = this.invManipulation.extract(amountToExtract, s -> inputBehaviour.handleInsertion((ItemStack)s, facing, true).func_190926_b());
        if (stack.func_190926_b()) {
            return;
        }
        this.flap(false);
        this.onTransfer(stack);
        inputBehaviour.handleInsertion(stack, facing, false);
        this.startCooldown();
    }

    public int getAmountToExtract() {
        if (!this.supportsAmountOnFilter()) {
            return -1;
        }
        int amountToExtract = this.invManipulation.getAmountFromFilter();
        if (!this.filtering.isActive()) {
            amountToExtract = 1;
        }
        return amountToExtract;
    }

    private int startCooldown() {
        this.extractionCooldown = (Integer)AllConfigs.SERVER.logistics.defaultExtractionTimer.get();
        return this.extractionCooldown;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.invManipulation = new InvManipulationBehaviour(this, InvManipulationBehaviour.InterfaceProvider.oppositeOfBlockFacing());
        behaviours.add(this.invManipulation);
        this.autoExtractor = InvManipulationBehaviour.forExtraction(this, InvManipulationBehaviour.InterfaceProvider.towardBlockFacing());
        behaviours.add(this.autoExtractor);
        this.filtering = new FilteringBehaviour(this, new FunnelFilterSlotPositioning());
        this.filtering.showCountWhen(this::supportsAmountOnFilter);
        this.filtering.onlyActiveWhen(this::supportsFiltering);
        behaviours.add(this.filtering);
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(this::supportsDirectBeltInput).setInsertionHandler(this::handleDirectBeltInput));
    }

    private boolean supportsAmountOnFilter() {
        BlockState blockState = this.func_195044_w();
        boolean beltFunnelsupportsAmount = false;
        if (blockState.func_177230_c() instanceof BeltFunnelBlock) {
            BeltFunnelBlock.Shape shape = (BeltFunnelBlock.Shape)((Object)blockState.func_177229_b(BeltFunnelBlock.SHAPE));
            beltFunnelsupportsAmount = shape == BeltFunnelBlock.Shape.PUSHING ? true : BeltHelper.getSegmentTE((IWorld)this.field_145850_b, this.field_174879_c.func_177977_b()) != null;
        }
        boolean hopper = FunnelBlock.getFunnelFacing(blockState) == Direction.UP && !this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_185904_a().func_76222_j();
        return beltFunnelsupportsAmount || hopper;
    }

    private boolean supportsDirectBeltInput(Direction side) {
        BlockState blockState = this.func_195044_w();
        if (blockState == null) {
            return false;
        }
        if (!(blockState.func_177230_c() instanceof FunnelBlock)) {
            return false;
        }
        Direction direction = (Direction)blockState.func_177229_b((IProperty)FunnelBlock.field_176387_N);
        return direction == Direction.UP || direction == side.func_176734_d();
    }

    private boolean supportsFiltering() {
        BlockState blockState = this.func_195044_w();
        return AllBlocks.BRASS_BELT_FUNNEL.has(blockState) || AllBlocks.BRASS_FUNNEL.has(blockState);
    }

    private ItemStack handleDirectBeltInput(TransportedItemStack stack, Direction side, boolean simulate) {
        ItemStack inserted = stack.stack;
        if (!this.filtering.test(inserted)) {
            return inserted;
        }
        if (this.determineCurrentMode() == Mode.PAUSED) {
            return inserted;
        }
        if (simulate) {
            this.invManipulation.simulate();
        }
        if (!simulate) {
            this.onTransfer(inserted);
        }
        return this.invManipulation.insert(inserted);
    }

    public void flap(boolean inward) {
        this.sendFlap = inward ? 1 : -1;
        this.sendData();
    }

    public boolean hasFlap() {
        BlockState blockState = this.func_195044_w();
        return blockState.func_177230_c() instanceof BeltFunnelBlock;
    }

    public float getFlapOffset() {
        BlockState blockState = this.func_195044_w();
        if (!(blockState.func_177230_c() instanceof BeltFunnelBlock)) {
            return 0.0f;
        }
        switch ((BeltFunnelBlock.Shape)((Object)blockState.func_177229_b(BeltFunnelBlock.SHAPE))) {
            default: {
                return 0.0f;
            }
            case EXTENDED: {
                return 0.5f;
            }
            case PULLING: 
            case PUSHING: 
        }
        return -0.125f;
    }

    @Override
    protected void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.func_74768_a("TransferCooldown", this.extractionCooldown);
        if (clientPacket && this.sendFlap != 0) {
            compound.func_74768_a("Flap", this.sendFlap);
            this.sendFlap = 0;
        }
    }

    @Override
    protected void read(CompoundNBT compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.extractionCooldown = compound.func_74762_e("TransferCooldown");
        if (clientPacket && compound.func_74764_b("Flap")) {
            int direction = compound.func_74762_e("Flap");
            this.flap.set(direction);
        }
    }

    public double func_145833_n() {
        return this.hasFlap() ? super.func_145833_n() : 64.0;
    }

    public void onTransfer(ItemStack stack) {
        ((ContentObserverBlock)AllBlocks.CONTENT_OBSERVER.get()).onFunnelTransfer(this.field_145850_b, this.field_174879_c, stack);
    }

    @Override
    public boolean addToTooltip(List<String> tooltip, boolean isPlayerSneaking) {
        if (isPlayerSneaking) {
            return false;
        }
        BlockState state = this.func_195044_w();
        if (!(state.func_177230_c() instanceof FunnelBlock)) {
            return false;
        }
        Direction funnelFacing = FunnelBlock.getFunnelFacing(state);
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(funnelFacing.func_176734_d())).func_185904_a().func_76222_j()) {
            return false;
        }
        BlockPos inputPos = this.field_174879_c.func_177972_a(funnelFacing);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(inputPos);
        if (tileEntity == null) {
            return false;
        }
        if (tileEntity instanceof BeltTileEntity) {
            return false;
        }
        if (tileEntity instanceof SawTileEntity) {
            return false;
        }
        if (tileEntity instanceof ChuteTileEntity) {
            return false;
        }
        LazyOptional capability = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (!capability.isPresent()) {
            return false;
        }
        if (funnelFacing == Direction.DOWN) {
            TooltipHelper.addHint(tooltip, "hint.upward_funnel", new Object[0]);
            return true;
        }
        if (!funnelFacing.func_176740_k().func_176722_c()) {
            return false;
        }
        TooltipHelper.addHint(tooltip, "hint.horizontal_funnel", new Object[0]);
        return true;
    }

    static enum Mode {
        INVALID,
        PAUSED,
        COLLECT,
        PUSHING_TO_BELT,
        TAKING_FROM_BELT,
        HOPPER;

    }
}

