/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.mechanicalArm;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmBlock;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmTileEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ArmRenderer
extends KineticTileEntityRenderer {
    public ArmRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float pt, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        super.renderSafe(te, pt, ms, buffer, light, overlay);
        ArmTileEntity arm = (ArmTileEntity)te;
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228639_c_());
        BlockState blockState = te.func_195044_w();
        MatrixStacker msr = MatrixStacker.of(ms);
        int color = 0xFFFFFF;
        float baseAngle = arm.baseAngle.get(pt);
        float lowerArmAngle = arm.lowerArmAngle.get(pt) - 135.0f;
        float upperArmAngle = arm.upperArmAngle.get(pt) - 90.0f;
        float headAngle = arm.headAngle.get(pt);
        boolean rave = te instanceof ArmTileEntity && ((ArmTileEntity)te).phase == ArmTileEntity.Phase.DANCING;
        float renderTick = AnimationTickHolder.getRenderTick() + (float)(te.hashCode() % 64);
        if (rave) {
            baseAngle = renderTick * 10.0f % 360.0f;
            lowerArmAngle = MathHelper.func_219799_g((float)((MathHelper.func_76126_a((float)(renderTick / 4.0f)) + 1.0f) / 2.0f), (float)-45.0f, (float)15.0f);
            upperArmAngle = MathHelper.func_219799_g((float)((MathHelper.func_76126_a((float)(renderTick / 8.0f)) + 1.0f) / 4.0f), (float)-45.0f, (float)95.0f);
            headAngle = -lowerArmAngle;
            color = ColorHelper.rainbowColor(AnimationTickHolder.ticks * 100);
        }
        ms.func_227860_a_();
        SuperByteBuffer base = AllBlockPartials.ARM_BASE.renderOn(blockState).light(light);
        SuperByteBuffer lowerBody = AllBlockPartials.ARM_LOWER_BODY.renderOn(blockState).light(light);
        SuperByteBuffer upperBody = AllBlockPartials.ARM_UPPER_BODY.renderOn(blockState).light(light);
        SuperByteBuffer head = AllBlockPartials.ARM_HEAD.renderOn(blockState).light(light);
        SuperByteBuffer claw = AllBlockPartials.ARM_CLAW_BASE.renderOn(blockState).light(light);
        SuperByteBuffer clawGrip = AllBlockPartials.ARM_CLAW_GRIP.renderOn(blockState);
        msr.centre();
        if (((Boolean)blockState.func_177229_b((IProperty)ArmBlock.CEILING)).booleanValue()) {
            msr.rotateX(180.0);
        }
        ms.func_227861_a_(0.0, 0.25, 0.0);
        msr.rotateY(baseAngle);
        base.renderInto(ms, builder);
        ms.func_227861_a_(0.0, 0.0625, -0.125);
        msr.rotateX(lowerArmAngle);
        ms.func_227861_a_(0.0, -0.0625, 0.0);
        lowerBody.color(color).renderInto(ms, builder);
        ms.func_227861_a_(0.0, 0.75, 0.75);
        msr.rotateX(upperArmAngle);
        upperBody.color(color).renderInto(ms, builder);
        ms.func_227861_a_(0.0, 0.6875, -0.6875);
        msr.rotateX(headAngle);
        head.renderInto(ms, builder);
        ms.func_227861_a_(0.0, 0.0, -0.25);
        claw.renderInto(ms, builder);
        ItemStack item = arm.heldItem;
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        boolean hasItem = !item.func_190926_b();
        boolean isBlockItem = hasItem && item.func_77973_b() instanceof BlockItem && itemRenderer.func_184393_a(item, (World)Minecraft.func_71410_x().field_71441_e, null).func_177556_c();
        for (int flip : Iterate.positiveAndNegative) {
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, (double)(flip * 3) / 16.0, -0.0625);
            msr.rotateX(flip * (hasItem ? (isBlockItem ? 0 : -35) : 0));
            clawGrip.light(light).renderInto(ms, builder);
            ms.func_227865_b_();
        }
        if (hasItem) {
            float itemScale = isBlockItem ? 0.5f : 0.625f;
            msr.rotateX(90.0);
            ms.func_227861_a_(0.0, -0.25, 0.0);
            ms.func_227862_a_(itemScale, itemScale, itemScale);
            itemRenderer.func_229110_a_(item, ItemCameraTransforms.TransformType.FIXED, light, overlay, ms, buffer);
        }
        ms.func_227865_b_();
    }

    @Override
    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        return AllBlockPartials.ARM_COG.renderOn(te.func_195044_w());
    }
}

