/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.block.redstone.RedstoneLinkTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.block.ProperDirectionalBlock;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class RedstoneLinkBlock
extends ProperDirectionalBlock
implements ITE<RedstoneLinkTileEntity> {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty RECEIVER = BooleanProperty.func_177716_a((String)"receiver");

    public RedstoneLinkBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)RECEIVER, (Comparable)Boolean.valueOf(false)));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        Direction blockFacing = (Direction)state.func_177229_b((IProperty)field_176387_N);
        if (fromPos.equals((Object)pos.func_177972_a(blockFacing.func_176734_d())) && !this.func_196260_a(state, (IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
            return;
        }
        this.updateTransmittedSignal(state, worldIn, pos, blockFacing);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updateTransmittedSignal(state, worldIn, pos, (Direction)state.func_177229_b((IProperty)field_176387_N));
    }

    private void updateTransmittedSignal(BlockState state, World worldIn, BlockPos pos, Direction blockFacing) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (((Boolean)state.func_177229_b((IProperty)RECEIVER)).booleanValue()) {
            return;
        }
        int power = this.getPower(worldIn, pos);
        boolean previouslyPowered = (Boolean)state.func_177229_b((IProperty)POWERED);
        if (previouslyPowered != power > 0) {
            worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)POWERED), 2);
        }
        int transmit = power;
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> te.transmit(transmit));
    }

    private int getPower(World worldIn, BlockPos pos) {
        int power = 0;
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.func_175651_c(pos.func_177972_a(direction), direction), power);
        }
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.func_175651_c(pos.func_177972_a(direction), Direction.UP), power);
        }
        return power;
    }

    public boolean func_149744_f(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false && (Boolean)state.func_177229_b((IProperty)RECEIVER) != false;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (side != blockState.func_177229_b((IProperty)field_176387_N)) {
            return 0;
        }
        return this.func_180656_a(blockState, blockAccess, pos, side);
    }

    public int func_180656_a(BlockState state, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (!((Boolean)state.func_177229_b((IProperty)RECEIVER)).booleanValue()) {
            return 0;
        }
        try {
            RedstoneLinkTileEntity tileEntity = (RedstoneLinkTileEntity)this.getTileEntity(blockAccess, pos);
            return tileEntity.getReceivedSignal();
        }
        catch (ITE.TileEntityException tileEntityException) {
            return 0;
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{POWERED, RECEIVER});
        super.func_206840_a(builder);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.REDSTONE_LINK.create();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_225608_bj_()) {
            return this.toggleMode(state, worldIn, pos);
        }
        return ActionResultType.PASS;
    }

    public ActionResultType toggleMode(BlockState state, World worldIn, BlockPos pos) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        try {
            RedstoneLinkTileEntity te = (RedstoneLinkTileEntity)this.getTileEntity((IBlockReader)worldIn, pos);
            Boolean wasReceiver = (Boolean)state.func_177229_b((IProperty)RECEIVER);
            boolean blockPowered = worldIn.func_175640_z(pos);
            worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_177231_a((IProperty)RECEIVER)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(blockPowered)), 3);
            te.transmit(wasReceiver != false ? 0 : this.getPower(worldIn, pos));
            return ActionResultType.SUCCESS;
        }
        catch (ITE.TileEntityException tileEntityException) {
            return ActionResultType.PASS;
        }
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        if (this.toggleMode(state, context.func_195991_k(), context.func_195995_a()) == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        return super.onWrenched(state, context);
    }

    @Override
    public BlockState getRotatedBlockState(BlockState originalState, Direction _targetedFace) {
        return originalState;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return side != null;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos neighbourPos = pos.func_177972_a(((Direction)state.func_177229_b((IProperty)field_176387_N)).func_176734_d());
        BlockState neighbour = worldIn.func_180495_p(neighbourPos);
        if (FunnelBlock.isFunnel(neighbour)) {
            return true;
        }
        return Block.func_220056_d((BlockState)neighbour, (IBlockReader)worldIn, (BlockPos)neighbourPos, (Direction)((Direction)state.func_177229_b((IProperty)field_176387_N)));
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        state = (BlockState)state.func_206870_a((IProperty)field_176387_N, (Comparable)context.func_196000_l());
        return state;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AllShapes.REDSTONE_BRIDGE.get((Direction)state.func_177229_b((IProperty)field_176387_N));
    }

    @Override
    public Class<RedstoneLinkTileEntity> getTileEntityClass() {
        return RedstoneLinkTileEntity.class;
    }
}

