/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.logistics.block.redstone.StockpileSwitchScreen;
import com.simibubi.create.content.logistics.block.redstone.StockpileSwitchTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.CapabilityItemHandler;

public class StockpileSwitchBlock
extends HorizontalBlock
implements ITE<StockpileSwitchTileEntity>,
IWrenchable {
    public static final IntegerProperty INDICATOR = IntegerProperty.func_177719_a((String)"indicator", (int)0, (int)6);

    public StockpileSwitchBlock(Block.Properties p_i48377_1_) {
        super(p_i48377_1_);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updateObservedInventory(state, (IWorldReader)worldIn, pos);
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        if (world.func_201670_d()) {
            return;
        }
        if (!this.isObserving(state, pos, neighbor)) {
            return;
        }
        this.updateObservedInventory(state, world, pos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return AllShapes.STOCKPILE_SWITCH.get((Direction)state.func_177229_b((IProperty)field_185512_D));
    }

    private void updateObservedInventory(BlockState state, IWorldReader world, BlockPos pos) {
        this.withTileEntityDo((IBlockReader)world, pos, StockpileSwitchTileEntity::updateCurrentLevel);
    }

    private boolean isObserving(BlockState state, BlockPos pos, BlockPos observing) {
        return observing.equals((Object)pos.func_177972_a((Direction)state.func_177229_b((IProperty)field_185512_D)));
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return side != null && side.func_176734_d() != state.func_177229_b((IProperty)field_185512_D);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (side == ((Direction)blockState.func_177229_b((IProperty)field_185512_D)).func_176734_d()) {
            return 0;
        }
        try {
            return ((StockpileSwitchTileEntity)this.getTileEntity(blockAccess, pos)).isPowered() ? 15 : 0;
        }
        catch (ITE.TileEntityException tileEntityException) {
            return 0;
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, INDICATOR});
        super.func_206840_a(builder);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player != null && AllItems.WRENCH.isIn(player.func_184586_b(handIn))) {
            return ActionResultType.PASS;
        }
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.withTileEntityDo((IBlockReader)worldIn, pos, te -> this.displayScreen((StockpileSwitchTileEntity)((Object)((Object)((Object)te))), player)));
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayScreen(StockpileSwitchTileEntity te, PlayerEntity player) {
        if (player instanceof ClientPlayerEntity) {
            ScreenOpener.open(new StockpileSwitchScreen(te));
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        Direction preferredFacing = null;
        for (Direction face : Iterate.horizontalDirections) {
            TileEntity te = context.func_195991_k().func_175625_s(context.func_195995_a().func_177972_a(face));
            if (te == null || !te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) continue;
            if (preferredFacing == null) {
                preferredFacing = face;
                continue;
            }
            preferredFacing = null;
            break;
        }
        state = preferredFacing != null ? (BlockState)state.func_206870_a((IProperty)field_185512_D, preferredFacing) : (context.func_196000_l().func_176740_k().func_176722_c() ? (BlockState)state.func_206870_a((IProperty)field_185512_D, (Comparable)context.func_196000_l()) : (BlockState)state.func_206870_a((IProperty)field_185512_D, (Comparable)context.func_195992_f().func_176734_d()));
        return state;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.STOCKPILE_SWITCH.create();
    }

    @Override
    public Class<StockpileSwitchTileEntity> getTileEntityClass() {
        return StockpileSwitchTileEntity.class;
    }
}

