/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.palettes;

import com.simibubi.create.Create;
import com.simibubi.create.content.palettes.PaletteBlockPatterns;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.builders.ItemBuilder;
import com.simibubi.create.repack.registrate.providers.DataGenContext;
import com.simibubi.create.repack.registrate.providers.RegistrateBlockstateProvider;
import com.simibubi.create.repack.registrate.providers.RegistrateRecipeProvider;
import com.simibubi.create.repack.registrate.providers.loot.RegistrateBlockLootTables;
import com.simibubi.create.repack.registrate.util.DataIngredient;
import com.simibubi.create.repack.registrate.util.nullness.NonnullType;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public abstract class PaletteBlockPartial<B extends Block> {
    public static final PaletteBlockPartial<StairsBlock> STAIR = new Stairs();
    public static final PaletteBlockPartial<SlabBlock> SLAB = new Slab(false);
    public static final PaletteBlockPartial<SlabBlock> UNIQUE_SLAB = new Slab(true);
    public static final PaletteBlockPartial<WallBlock> WALL = new Wall();
    public static final PaletteBlockPartial<?>[] AllPartials = new PaletteBlockPartial[]{STAIR, SLAB, WALL};
    public static final PaletteBlockPartial<?>[] ForPolished = new PaletteBlockPartial[]{STAIR, UNIQUE_SLAB, WALL};
    private String name;

    private PaletteBlockPartial(String name) {
        this.name = name;
    }

    @NonnullType
    public BlockBuilder<B, CreateRegistrate> create(String variantName, PaletteBlockPatterns pattern, Supplier<? extends Block> block) {
        String patternName = pattern.createName(variantName);
        String blockName = patternName + "_" + this.name;
        return (BlockBuilder)Create.registrate().block(blockName, p -> this.createBlock(block)).blockstate((c, p) -> this.generateBlockState((DataGenContext<Block, B>)c, (RegistrateBlockstateProvider)p, variantName, pattern, block)).recipe((c, p) -> this.createRecipes(block, (DataGenContext<Block, ? extends Block>)c, (RegistrateRecipeProvider)p)).transform(b -> this.transformBlock((BlockBuilder<B, CreateRegistrate>)b, variantName, pattern)).item().transform(b -> this.transformItem((ItemBuilder<BlockItem, BlockBuilder<B, CreateRegistrate>>)b, variantName, pattern)).build();
    }

    protected ResourceLocation getMainTexture(String variantName, PaletteBlockPatterns pattern) {
        return pattern.toLocation(variantName, pattern.getTextureForPartials());
    }

    protected BlockBuilder<B, CreateRegistrate> transformBlock(BlockBuilder<B, CreateRegistrate> builder, String variantName, PaletteBlockPatterns pattern) {
        this.getBlockTags().forEach(xva$0 -> builder.tag((Tag<Block>)xva$0));
        return builder;
    }

    protected ItemBuilder<BlockItem, BlockBuilder<B, CreateRegistrate>> transformItem(ItemBuilder<BlockItem, BlockBuilder<B, CreateRegistrate>> builder, String variantName, PaletteBlockPatterns pattern) {
        this.getItemTags().forEach(xva$0 -> builder.tag((Tag<Item>)xva$0));
        return builder;
    }

    protected abstract Iterable<Tag<Block>> getBlockTags();

    protected abstract Iterable<Tag<Item>> getItemTags();

    protected abstract B createBlock(Supplier<? extends Block> var1);

    protected abstract void createRecipes(Supplier<? extends Block> var1, DataGenContext<Block, ? extends Block> var2, RegistrateRecipeProvider var3);

    protected abstract void generateBlockState(DataGenContext<Block, B> var1, RegistrateBlockstateProvider var2, String var3, PaletteBlockPatterns var4, Supplier<? extends Block> var5);

    private static class Wall
    extends PaletteBlockPartial<WallBlock> {
        public Wall() {
            super("wall");
        }

        @Override
        protected WallBlock createBlock(Supplier<? extends Block> block) {
            return new WallBlock(Block.Properties.func_200950_a((Block)block.get()));
        }

        @Override
        protected ItemBuilder<BlockItem, BlockBuilder<WallBlock, CreateRegistrate>> transformItem(ItemBuilder<BlockItem, BlockBuilder<WallBlock, CreateRegistrate>> builder, String variantName, PaletteBlockPatterns pattern) {
            builder.model((c, p) -> {
                ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)p.wallInventory(c.getName(), this.getMainTexture(variantName, pattern));
            });
            return super.transformItem(builder, variantName, pattern);
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, WallBlock> ctx, RegistrateBlockstateProvider prov, String variantName, PaletteBlockPatterns pattern, Supplier<? extends Block> block) {
            prov.wallBlock(ctx.get(), pattern.createName(variantName), this.getMainTexture(variantName, pattern));
        }

        @Override
        protected Iterable<Tag<Block>> getBlockTags() {
            return Arrays.asList(BlockTags.field_219757_z);
        }

        @Override
        protected Iterable<Tag<Item>> getItemTags() {
            return Arrays.asList(ItemTags.field_219778_z);
        }

        @Override
        protected void createRecipes(Supplier<? extends Block> block, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
            DataIngredient source = DataIngredient.items((IItemProvider)((IItemProvider)block.get()), (IItemProvider[])new Block[0]);
            Supplier<Block> result = c::get;
            p.wall(source, result);
        }
    }

    private static class Slab
    extends PaletteBlockPartial<SlabBlock> {
        private boolean customSide;

        public Slab(boolean customSide) {
            super("slab");
            this.customSide = customSide;
        }

        @Override
        protected SlabBlock createBlock(Supplier<? extends Block> block) {
            return new SlabBlock(Block.Properties.func_200950_a((Block)block.get()));
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, SlabBlock> ctx, RegistrateBlockstateProvider prov, String variantName, PaletteBlockPatterns pattern, Supplier<? extends Block> block) {
            String name = ctx.getName();
            ResourceLocation mainTexture = this.getMainTexture(variantName, pattern);
            ResourceLocation sideTexture = this.customSide ? new ResourceLocation(mainTexture.func_110624_b(), mainTexture.func_110623_a() + "_slab") : mainTexture;
            ModelBuilder bottom = prov.models().slab(name, sideTexture, mainTexture, mainTexture);
            ModelBuilder top = prov.models().slabTop(name + "_top", sideTexture, mainTexture, mainTexture);
            Object doubleSlab = this.customSide ? prov.models().cubeColumn(name + "_double", sideTexture, mainTexture) : prov.models().getExistingFile(prov.modLoc(name.replace("_slab", "")));
            prov.slabBlock(ctx.get(), (ModelFile)bottom, (ModelFile)top, (ModelFile)doubleSlab);
        }

        @Override
        protected Iterable<Tag<Block>> getBlockTags() {
            return Arrays.asList(BlockTags.field_203292_x);
        }

        @Override
        protected Iterable<Tag<Item>> getItemTags() {
            return Arrays.asList(ItemTags.field_203442_w);
        }

        @Override
        protected void createRecipes(Supplier<? extends Block> block, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
            DataIngredient source = DataIngredient.items((IItemProvider)((IItemProvider)block.get()), (IItemProvider[])new Block[0]);
            Supplier<Block> result = c::get;
            p.slab(source, result, c.getName(), true);
        }

        @Override
        protected BlockBuilder<SlabBlock, CreateRegistrate> transformBlock(BlockBuilder<SlabBlock, CreateRegistrate> builder, String variantName, PaletteBlockPatterns pattern) {
            builder.loot((lt, block) -> lt.func_218507_a((Block)block, RegistrateBlockLootTables.droppingSlab((Block)block)));
            return super.transformBlock(builder, variantName, pattern);
        }
    }

    private static class Stairs
    extends PaletteBlockPartial<StairsBlock> {
        public Stairs() {
            super("stairs");
        }

        @Override
        protected StairsBlock createBlock(Supplier<? extends Block> block) {
            return new StairsBlock(() -> ((Block)block.get()).func_176223_P(), Block.Properties.func_200950_a((Block)block.get()));
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, StairsBlock> ctx, RegistrateBlockstateProvider prov, String variantName, PaletteBlockPatterns pattern, Supplier<? extends Block> block) {
            prov.stairsBlock(ctx.get(), this.getMainTexture(variantName, pattern));
        }

        @Override
        protected Iterable<Tag<Block>> getBlockTags() {
            return Arrays.asList(BlockTags.field_203291_w);
        }

        @Override
        protected Iterable<Tag<Item>> getItemTags() {
            return Arrays.asList(ItemTags.field_203441_v);
        }

        @Override
        protected void createRecipes(Supplier<? extends Block> block, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
            DataIngredient source = DataIngredient.items((IItemProvider)((IItemProvider)block.get()), (IItemProvider[])new Block[0]);
            Supplier<Block> result = c::get;
            p.stairs(source, result, c.getName(), true);
        }
    }
}

