/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.events;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllFluids;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.KineticDebugger;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.ChassisRangeDisplay;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandlerClient;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingPhysics;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.components.turntable.TurntableHandler;
import com.simibubi.create.content.contraptions.relays.belt.item.BeltConnectorHandler;
import com.simibubi.create.content.curiosities.tools.ExtendoGripRenderHandler;
import com.simibubi.create.content.curiosities.zapper.ZapperItem;
import com.simibubi.create.content.curiosities.zapper.ZapperRenderHandler;
import com.simibubi.create.content.curiosities.zapper.blockzapper.BlockzapperRenderHandler;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.WorldshaperRenderHandler;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPointHandler;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.LeftClickPacket;
import com.simibubi.create.foundation.renderState.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.tileEntity.behaviour.edgeInteraction.EdgeInteractionRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.linked.LinkRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static final String itemPrefix = "item.create";
    private static final String blockPrefix = "block.create";

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        AnimationTickHolder.tick();
        if (!ClientEvents.isGameActive()) {
            return;
        }
        CreateClient.schematicSender.tick();
        CreateClient.schematicAndQuillHandler.tick();
        CreateClient.schematicHandler.tick();
        ContraptionHandler.tick((World)world);
        CapabilityMinecartController.tick((World)world);
        CouplingPhysics.tick((World)world);
        ScreenOpener.tick();
        ServerSpeedProvider.clientTick();
        BeltConnectorHandler.tick();
        FilteringRenderer.tick();
        LinkRenderer.tick();
        ScrollValueRenderer.tick();
        ChassisRangeDisplay.tick();
        EdgeInteractionRenderer.tick();
        WorldshaperRenderHandler.tick();
        BlockzapperRenderHandler.tick();
        CouplingHandlerClient.tick();
        CouplingRenderer.tickDebugModeRenders();
        KineticDebugger.tick();
        ZapperRenderHandler.tick();
        ExtendoGripRenderHandler.tick();
        ArmInteractionPointHandler.tick();
        PlacementHelpers.tick();
        CreateClient.outliner.tickOutlines();
    }

    @SubscribeEvent
    public static void onLoadWorld(WorldEvent.Load event) {
        CreateClient.bufferCache.invalidate();
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderWorldLastEvent event) {
        MatrixStack ms = event.getMatrixStack();
        ActiveRenderInfo info = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vec3d view = info.func_216785_c();
        ms.func_227860_a_();
        ms.func_227861_a_(-view.func_82615_a(), -view.func_82617_b(), -view.func_82616_c());
        SuperRenderTypeBuffer buffer = SuperRenderTypeBuffer.getInstance();
        CouplingRenderer.renderAll(ms, buffer);
        CreateClient.schematicHandler.render(ms, buffer);
        CreateClient.outliner.renderOutlines(ms, buffer);
        buffer.draw();
        ms.func_227865_b_();
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        ClientEvents.onRenderHotbar(new MatrixStack(), (IRenderTypeBuffer)Minecraft.func_71410_x().func_228019_au_().func_228487_b_(), 0xF000F0, OverlayTexture.field_229196_a_);
    }

    public static void onRenderHotbar(MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        CreateClient.schematicHandler.renderOverlay(ms, buffer, light, overlay);
    }

    @SubscribeEvent
    public static void addToItemTooltip(ItemTooltipEvent event) {
        if (!((Boolean)AllConfigs.CLIENT.tooltips.get()).booleanValue()) {
            return;
        }
        if (event.getPlayer() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        String translationKey = stack.func_77973_b().func_77667_c(stack);
        if (!translationKey.startsWith(itemPrefix) && !translationKey.startsWith(blockPrefix)) {
            return;
        }
        if (TooltipHelper.hasTooltip(stack, event.getPlayer())) {
            List itemTooltip = event.getToolTip();
            ArrayList<ITextComponent> toolTip = new ArrayList<ITextComponent>();
            toolTip.add((ITextComponent)itemTooltip.remove(0));
            TooltipHelper.getTooltip(stack).addInformation(toolTip);
            itemTooltip.addAll(0, toolTip);
        }
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!ClientEvents.isGameActive()) {
            return;
        }
        TurntableHandler.gameRenderTick();
    }

    protected static boolean isGameActive() {
        return Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null;
    }

    @SubscribeEvent
    public static void getFogDensity(EntityViewRenderEvent.FogDensity event) {
        ActiveRenderInfo info = event.getInfo();
        IFluidState fluidState = info.func_216771_k();
        if (fluidState.func_206888_e()) {
            return;
        }
        Fluid fluid = fluidState.func_206886_c();
        if (fluid.func_207187_a((Fluid)AllFluids.CHOCOLATE.get())) {
            event.setDensity(5.0f);
            event.setCanceled(true);
        }
        if (fluid.func_207187_a((Fluid)AllFluids.HONEY.get())) {
            event.setDensity(1.5f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void getFogColor(EntityViewRenderEvent.FogColors event) {
        ActiveRenderInfo info = event.getInfo();
        IFluidState fluidState = info.func_216771_k();
        if (fluidState.func_206888_e()) {
            return;
        }
        Fluid fluid = fluidState.func_206886_c();
        if (fluid.func_207187_a((Fluid)AllFluids.CHOCOLATE.get())) {
            event.setRed(0.3828125f);
            event.setGreen(0.125f);
            event.setBlue(0.125f);
        }
        if (fluid.func_207187_a((Fluid)AllFluids.HONEY.get())) {
            event.setRed(0.9140625f);
            event.setGreen(0.6796875f);
            event.setBlue(0.18359375f);
        }
    }

    @SubscribeEvent
    public static void leftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof ZapperItem) {
            AllPackets.channel.sendToServer((Object)new LeftClickPacket());
        }
    }
}

