/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.advancement;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.curiosities.zapper.blockzapper.BlockzapperItem;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.advancement.KineticBlockTrigger;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.PlacedBlockTrigger;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AllAdvancements
implements IDataProvider {
    static final String LANG = "advancement.create.";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public void register(Consumer<Advancement> t) {
        String id = "create";
        Advancement root = Advancement.Builder.func_200278_a().func_215092_a(AllItems.BRASS_HAND.asStack(), (ITextComponent)new TranslationTextComponent("advancement.create.root", new Object[0]), (ITextComponent)new TranslationTextComponent("advancement.create.root.desc", new Object[0]), new ResourceLocation("create", "textures/block/palettes/gabbro/bricks.png"), FrameType.TASK, false, false, false).func_200275_a("0", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[0])).func_203904_a(t, id + ":root");
        Advancement andesite_alloy = this.advancement("andesite_alloy", (IItemProvider)AllItems.ANDESITE_ALLOY.get(), TaskType.NORMAL).func_203905_a(root).func_200275_a("0", (ICriterionInstance)this.itemGathered((IItemProvider)AllItems.ANDESITE_ALLOY.get())).func_203904_a(t, id + ":andesite_alloy");
        this.kineticsBranch(t, andesite_alloy);
        Advancement aesthetics = this.advancement("aesthetics", (IItemProvider)AllBlocks.WOODEN_BRACKET.get(), TaskType.NORMAL).func_203905_a(andesite_alloy).func_200275_a("0", (ICriterionInstance)AllTriggers.BRACKET_SHAFT.instance()).func_200275_a("1", (ICriterionInstance)AllTriggers.BRACKET_COG.instance()).func_200275_a("2", (ICriterionInstance)AllTriggers.BRACKET_PIPE.instance()).func_203904_a(t, id + ":aesthetics");
        Advancement reinforced = this.advancement("reinforced", (IItemProvider)AllBlocks.ANDESITE_ENCASED_SHAFT.get(), TaskType.NORMAL).func_203905_a(aesthetics).func_200275_a("0", (ICriterionInstance)AllTriggers.CASING_SHAFT.instance()).func_200275_a("1", (ICriterionInstance)AllTriggers.CASING_BELT.instance()).func_200275_a("2", (ICriterionInstance)AllTriggers.CASING_PIPE.instance()).func_203904_a(t, id + ":reinforced");
        Advancement water_wheel = this.advancement("water_wheel", (IItemProvider)AllBlocks.WATER_WHEEL.get(), TaskType.NORMAL).func_203905_a(andesite_alloy).func_200275_a("0", (ICriterionInstance)this.placeBlock((Block)AllBlocks.WATER_WHEEL.get())).func_200275_a("1", (ICriterionInstance)AllTriggers.WATER_WHEEL.instance()).func_203904_a(t, id + ":water_wheel");
        Advancement lava_wheel = this.advancement("lava_wheel", (IItemProvider)Items.field_151129_at, TaskType.SECRET).func_203905_a(water_wheel).func_200275_a("0", (ICriterionInstance)AllTriggers.LAVA_WHEEL.instance()).func_203904_a(t, id + ":lava_wheel");
        Advancement chocolate_wheel = this.advancement("chocolate_wheel", (IItemProvider)AllFluids.CHOCOLATE.get().func_204524_b(), TaskType.SECRET).func_203905_a(water_wheel).func_200275_a("0", (ICriterionInstance)AllTriggers.CHOCOLATE_WHEEL.instance()).func_203904_a(t, id + ":chocolate_wheel");
        Advancement millstone = this.kinecticAdvancement("millstone", (Block)AllBlocks.MILLSTONE.get(), TaskType.NORMAL).func_203905_a(andesite_alloy).func_203904_a(t, id + ":millstone");
        Advancement cuckoo = this.advancement("cuckoo", (IItemProvider)AllBlocks.CUCKOO_CLOCK.get(), TaskType.NORMAL).func_203905_a(andesite_alloy).func_200275_a("0", (ICriterionInstance)AllTriggers.CUCKOO.instance()).func_203904_a(t, id + ":cuckoo");
        Advancement windmill = this.advancement("windmill", (IItemProvider)AllBlocks.WINDMILL_BEARING.get(), TaskType.NORMAL).func_203905_a(andesite_alloy).func_200275_a("0", (ICriterionInstance)AllTriggers.WINDMILL.instance()).func_203904_a(t, id + ":windmill");
        Advancement maxed_windmill = this.advancement("maxed_windmill", (IItemProvider)AllBlocks.WINDMILL_BEARING.get(), TaskType.GOAL).func_203905_a(windmill).func_200275_a("0", (ICriterionInstance)AllTriggers.MAXED_WINDMILL.instance()).func_203904_a(t, id + ":maxed_windmill");
        Advancement andesite_casing = this.advancement("andesite_casing", (IItemProvider)AllBlocks.ANDESITE_CASING.get(), TaskType.GOAL).func_203905_a(andesite_alloy).func_200275_a("0", (ICriterionInstance)this.itemGathered((IItemProvider)AllBlocks.ANDESITE_CASING.get())).func_203904_a(t, id + ":andesite_casing");
        Advancement drill = this.kinecticAdvancement("mechanical_drill", (Block)AllBlocks.MECHANICAL_DRILL.get(), TaskType.NORMAL).func_203905_a(andesite_casing).func_203904_a(t, id + ":mechanical_drill");
        Advancement press = this.advancement("press", (IItemProvider)AllBlocks.MECHANICAL_PRESS.get(), TaskType.MILESTONE).func_203905_a(andesite_casing).func_200275_a("0", (ICriterionInstance)AllTriggers.BONK.instance()).func_203904_a(t, id + ":press");
        Advancement fan = this.advancement("fan", (IItemProvider)AllBlocks.ENCASED_FAN.get(), TaskType.NORMAL).func_203905_a(press).func_200275_a("0", (ICriterionInstance)AllTriggers.FAN.instance()).func_203904_a(t, id + ":fan");
        Advancement fan_lava = this.advancement("fan_lava", (IItemProvider)Items.field_151129_at, TaskType.NORMAL).func_203905_a(fan).func_200275_a("0", (ICriterionInstance)AllTriggers.FAN_LAVA.instance()).func_203904_a(t, id + ":fan_lava");
        Advancement fan_smoke = this.advancement("fan_smoke", (IItemProvider)Items.field_222113_pS, TaskType.NORMAL).func_203905_a(fan).func_200275_a("0", (ICriterionInstance)AllTriggers.FAN_SMOKE.instance()).func_203904_a(t, id + ":fan_smoke");
        Advancement fan_water = this.advancement("fan_water", (IItemProvider)Items.field_151131_as, TaskType.NORMAL).func_203905_a(fan).func_200275_a("0", (ICriterionInstance)AllTriggers.FAN_WATER.instance()).func_203904_a(t, id + ":fan_water");
        Advancement rose_quartz = this.itemAdvancement("polished_rose_quartz", AllItems.POLISHED_ROSE_QUARTZ, TaskType.NORMAL).func_203905_a(andesite_casing).func_203904_a(t, id + ":polished_rose_quartz");
        Advancement electron_tube = this.itemAdvancement("electron_tube", AllItems.ELECTRON_TUBE, TaskType.NORMAL).func_203905_a(rose_quartz).func_203904_a(t, id + ":electron_tube");
        Advancement saw = this.kinecticAdvancement("mechanical_saw", (Block)AllBlocks.MECHANICAL_SAW.get(), TaskType.NORMAL).func_203905_a(press).func_203904_a(t, id + ":mechanical_saw");
        Advancement basin = this.advancement("basin", (IItemProvider)AllBlocks.BASIN.get(), TaskType.NORMAL).func_203905_a(press).func_200275_a("0", (ICriterionInstance)this.placeBlock((Block)AllBlocks.BASIN.get())).func_200275_a("1", (ICriterionInstance)AllTriggers.BASIN_THROW.instance()).func_203904_a(t, id + ":basin");
        Advancement mixer = this.advancement("mixer", (IItemProvider)AllBlocks.MECHANICAL_MIXER.get(), TaskType.MILESTONE).func_200275_a("0", (ICriterionInstance)this.placeBlock((Block)AllBlocks.MECHANICAL_MIXER.get())).func_200275_a("1", (ICriterionInstance)this.isPowered((Block)AllBlocks.MECHANICAL_MIXER.get())).func_200275_a("2", (ICriterionInstance)AllTriggers.MIXER_MIX.instance()).func_203905_a(basin).func_203904_a(t, id + ":mixer");
        Advancement compact = this.advancement("compact", (IItemProvider)Blocks.field_150339_S, TaskType.NORMAL).func_200275_a("0", (ICriterionInstance)AllTriggers.PRESS_COMPACT.instance()).func_203905_a(basin).func_203904_a(t, id + ":compact");
        Advancement blaze_burner = this.itemAdvancement("blaze_burner", AllBlocks.BLAZE_BURNER, TaskType.NORMAL).func_203905_a(mixer).func_203904_a(t, id + ":blaze_burner");
        Advancement brass = this.itemAdvancement("brass", AllItems.BRASS_INGOT, TaskType.NORMAL).func_203905_a(blaze_burner).func_203904_a(t, id + ":brass");
        this.brassAge(t, brass);
        this.copperAge(t, press);
    }

    void kineticsBranch(Consumer<Advancement> t, Advancement root) {
        String id = "create";
        Advancement its_alive = this.advancement("its_alive", (IItemProvider)AllBlocks.COGWHEEL.get(), TaskType.NORMAL).func_203905_a(root).func_200275_a("0", (ICriterionInstance)AllTriggers.ROTATION.instance()).func_203904_a(t, id + ":its_alive");
        Advancement belt = this.advancement("belt", (IItemProvider)AllItems.BELT_CONNECTOR.get(), TaskType.NORMAL).func_203905_a(its_alive).func_200275_a("0", (ICriterionInstance)AllTriggers.CONNECT_BELT.instance()).func_203904_a(t, id + ":belt");
        Advancement tunnel = this.advancement("tunnel", (IItemProvider)AllBlocks.ANDESITE_TUNNEL.get(), TaskType.NORMAL).func_203905_a(belt).func_200275_a("0", (ICriterionInstance)AllTriggers.PLACE_TUNNEL.instance()).func_203904_a(t, id + ":tunnel");
        Advancement splitter_tunnel = this.advancement("splitter_tunnel", (IItemProvider)AllBlocks.BRASS_TUNNEL.get(), TaskType.MILESTONE).func_203905_a(tunnel).func_200275_a("0", (ICriterionInstance)AllTriggers.CONNECT_TUNNEL.instance()).func_203904_a(t, id + ":splitter_tunnel");
        Advancement chute = this.advancement("chute", (IItemProvider)AllBlocks.CHUTE.get(), TaskType.NORMAL).func_203905_a(belt).func_200275_a("0", (ICriterionInstance)this.placeBlock((Block)AllBlocks.CHUTE.get())).func_203904_a(t, id + ":chute");
        Advancement upward_chute = this.advancement("upward_chute", (IItemProvider)AllBlocks.ENCASED_FAN.get(), TaskType.NORMAL).func_203905_a(chute).func_200275_a("0", (ICriterionInstance)AllTriggers.UPWARD_CHUTE.instance()).func_203904_a(t, id + ":upward_chute");
        Advancement belt_funnel = this.advancement("belt_funnel", (IItemProvider)AllBlocks.ANDESITE_FUNNEL.get(), TaskType.NORMAL).func_203905_a(belt).func_200275_a("0", (ICriterionInstance)AllTriggers.BELT_FUNNEL.instance()).func_203904_a(t, id + ":belt_funnel");
        Advancement belt_funnel_kiss = this.advancement("belt_funnel_kiss", (IItemProvider)AllBlocks.BRASS_FUNNEL.get(), TaskType.SECRET).func_203905_a(belt_funnel).func_200275_a("0", (ICriterionInstance)AllTriggers.BELT_FUNNEL_KISS.instance()).func_203904_a(t, id + ":belt_funnel_kiss");
        Advancement wrench = this.itemAdvancement("wrench", AllItems.WRENCH, TaskType.NORMAL).func_203905_a(its_alive).func_203904_a(t, id + ":wrench");
        Advancement goggles = this.itemAdvancement("goggles", AllItems.GOGGLES, TaskType.NORMAL).func_203905_a(its_alive).func_203904_a(t, id + ":goggles");
        Advancement speed_gauge = this.kinecticAdvancement("speedometer", (Block)AllBlocks.SPEEDOMETER.get(), TaskType.NORMAL).func_203905_a(goggles).func_203904_a(t, id + ":speedometer");
        Advancement stress_gauge = this.kinecticAdvancement("stressometer", (Block)AllBlocks.STRESSOMETER.get(), TaskType.NORMAL).func_203905_a(goggles).func_203904_a(t, id + ":stressometer");
        Advancement shifting_gears = this.advancement("shifting_gears", (IItemProvider)AllBlocks.LARGE_COGWHEEL.get(), TaskType.NORMAL).func_203905_a(its_alive).func_200275_a("0", (ICriterionInstance)AllTriggers.SHIFTING_GEARS.instance()).func_203904_a(t, id + ":shifting_gears");
        Advancement overstressed = this.advancement("overstressed", (IItemProvider)Items.field_221803_eL, TaskType.SECRET).func_203905_a(its_alive).func_200275_a("0", (ICriterionInstance)AllTriggers.OVERSTRESSED.instance()).func_203904_a(t, id + ":overstressed");
    }

    void copperAge(Consumer<Advancement> t, Advancement root) {
        String id = "create";
        Advancement copper_casing = this.advancement("copper_casing", (IItemProvider)AllBlocks.COPPER_CASING.get(), TaskType.GOAL).func_203905_a(root).func_200275_a("0", (ICriterionInstance)this.itemGathered((IItemProvider)AllBlocks.COPPER_CASING.get())).func_203904_a(t, id + ":copper_casing");
        Advancement item_drain = this.advancement("item_drain", (IItemProvider)AllBlocks.ITEM_DRAIN.get(), TaskType.NORMAL).func_203905_a(copper_casing).func_200275_a("0", (ICriterionInstance)AllTriggers.ITEM_DRAIN.instance()).func_203904_a(t, id + ":item_drain");
        Advancement chained_item_drain = this.advancement("chained_item_drain", (IItemProvider)AllBlocks.ITEM_DRAIN.get(), TaskType.SECRET).func_203905_a(item_drain).func_200275_a("0", (ICriterionInstance)AllTriggers.CHAINED_ITEM_DRAIN.instance()).func_203904_a(t, id + ":chained_item_drain");
        Advancement spout = this.advancement("spout", (IItemProvider)AllBlocks.SPOUT.get(), TaskType.NORMAL).func_203905_a(copper_casing).func_200275_a("0", (ICriterionInstance)AllTriggers.SPOUT.instance()).func_203904_a(t, id + ":spout");
        Advancement spout_potion = this.advancement("spout_potion", (IItemProvider)Items.field_151068_bn, TaskType.GOAL).func_203905_a(spout).func_200275_a("0", (ICriterionInstance)AllTriggers.SPOUT_POTION.instance()).func_203904_a(t, id + ":spout_potion");
        Advancement chocolate = this.itemAdvancement("chocolate", () -> AllFluids.CHOCOLATE.get().func_204524_b(), TaskType.GOAL).func_203905_a(spout).func_203904_a(t, id + ":chocolate");
        Advancement glass_pipe = this.advancement("glass_pipe", (IItemProvider)AllBlocks.FLUID_PIPE.get(), TaskType.NORMAL).func_203905_a(copper_casing).func_200275_a("0", (ICriterionInstance)AllTriggers.GLASS_PIPE.instance()).func_203904_a(t, id + ":glass_pipe");
        Advancement pipe_collision = this.advancement("pipe_collision", (IItemProvider)AllBlocks.FLUID_VALVE.get(), TaskType.NORMAL).func_203905_a(glass_pipe).func_200275_a("0", (ICriterionInstance)AllTriggers.PIPE_COLLISION.instance()).func_203904_a(t, id + ":pipe_collision");
        Advancement pipe_spill = this.advancement("pipe_spill", (IItemProvider)Items.field_151133_ar, TaskType.NORMAL).func_203905_a(glass_pipe).func_200275_a("0", (ICriterionInstance)AllTriggers.PIPE_SPILL.instance()).func_203904_a(t, id + ":pipe_spill");
        Advancement hose_pulley = this.advancement("hose_pulley", (IItemProvider)AllBlocks.HOSE_PULLEY.get(), TaskType.NORMAL).func_203905_a(pipe_spill).func_200275_a("0", (ICriterionInstance)AllTriggers.HOSE_PULLEY.instance()).func_203904_a(t, id + ":hose_pulley");
        Advancement infinite_water = this.advancement("infinite_water", (IItemProvider)Items.field_151131_as, TaskType.NORMAL).func_203905_a(hose_pulley).func_200275_a("0", (ICriterionInstance)AllTriggers.INFINITE_WATER.instance()).func_203904_a(t, id + ":infinite_water");
        Advancement infinite_lava = this.advancement("infinite_lava", (IItemProvider)Items.field_151129_at, TaskType.GOAL).func_203905_a(hose_pulley).func_200275_a("0", (ICriterionInstance)AllTriggers.INFINITE_LAVA.instance()).func_203904_a(t, id + ":infinite_lava");
        Advancement infinite_chocolate = this.advancement("infinite_chocolate", (IItemProvider)AllFluids.CHOCOLATE.get().func_204524_b(), TaskType.CHALLENGE).func_203905_a(hose_pulley).func_200275_a("0", (ICriterionInstance)AllTriggers.INFINITE_CHOCOLATE.instance()).func_203904_a(t, id + ":infinite_chocolate");
    }

    void brassAge(Consumer<Advancement> t, Advancement root) {
        String id = "create";
        Advancement brass_casing = this.advancement("brass_casing", (IItemProvider)AllBlocks.BRASS_CASING.get(), TaskType.GOAL).func_203905_a(root).func_200275_a("0", (ICriterionInstance)this.itemGathered((IItemProvider)AllBlocks.BRASS_CASING.get())).func_203904_a(t, id + ":brass_casing");
        Advancement nixie_tube = this.advancement("nixie_tube", (IItemProvider)AllBlocks.NIXIE_TUBE.get(), TaskType.NORMAL).func_203905_a(brass_casing).func_200275_a("0", (ICriterionInstance)this.placeBlock((Block)AllBlocks.NIXIE_TUBE.get())).func_203904_a(t, id + ":nixie_tube");
        Advancement crafter = this.kinecticAdvancement("crafter", (Block)AllBlocks.MECHANICAL_CRAFTER.get(), TaskType.MILESTONE).func_203905_a(brass_casing).func_203904_a(t, id + ":crafter");
        Advancement flywheel = this.advancement("flywheel", (IItemProvider)AllBlocks.FLYWHEEL.get(), TaskType.NORMAL).func_203905_a(crafter).func_200275_a("0", (ICriterionInstance)AllTriggers.FLYWHEEL.instance()).func_203904_a(t, id + ":flywheel");
        Advancement overstress_flywheel = this.advancement("overstress_flywheel", (IItemProvider)AllBlocks.FURNACE_ENGINE.get(), TaskType.CHALLENGE).func_203905_a(flywheel).func_200275_a("0", (ICriterionInstance)AllTriggers.OVERSTRESS_FLYWHEEL.instance()).func_203904_a(t, id + ":overstress_flywheel");
        Advancement integrated_circuit = this.itemAdvancement("integrated_circuit", AllItems.INTEGRATED_CIRCUIT, TaskType.NORMAL).func_203905_a(crafter).func_203904_a(t, id + ":integrated_circuit");
        Advancement integrated_circuit_eob = this.deadEnd().func_203905_a(integrated_circuit).func_200275_a("0", (ICriterionInstance)this.itemGathered((IItemProvider)AllItems.INTEGRATED_CIRCUIT.get())).func_203904_a(t, id + ":integrated_circuit_eob");
        Advancement speed_controller = this.kinecticAdvancement("speed_controller", (Block)AllBlocks.ROTATION_SPEED_CONTROLLER.get(), TaskType.NORMAL).func_203905_a(integrated_circuit).func_203904_a(t, id + ":speed_controller");
        Advancement clockwork_bearing = this.advancement("clockwork_bearing", (IItemProvider)AllBlocks.CLOCKWORK_BEARING.get(), TaskType.NORMAL).func_203905_a(brass_casing).func_200275_a("0", (ICriterionInstance)AllTriggers.CLOCKWORK_BEARING.instance()).func_203904_a(t, id + ":clockwork_bearing");
        Advancement extendo_grip = this.advancement("extendo_grip", (IItemProvider)AllItems.EXTENDO_GRIP.get(), TaskType.NORMAL).func_203905_a(crafter).func_200275_a("0", (ICriterionInstance)AllTriggers.EXTENDO.instance()).func_203904_a(t, id + ":extendo_grip");
        Advancement dual_extendo_grip = this.advancement("dual_extendo_grip", (IItemProvider)AllItems.EXTENDO_GRIP.get(), TaskType.SECRET).func_203905_a(extendo_grip).func_200275_a("0", (ICriterionInstance)AllTriggers.GIGA_EXTENDO.instance()).func_203904_a(t, id + ":dual_extendo_grip");
        Advancement mechanical_arm = this.advancement("mechanical_arm", (IItemProvider)AllBlocks.MECHANICAL_ARM.get(), TaskType.MILESTONE).func_200275_a("0", (ICriterionInstance)AllTriggers.MECHANICAL_ARM.instance()).func_203905_a(brass_casing).func_203904_a(t, id + ":mechanical_arm");
        Advancement musical_arm = this.advancement("musical_arm", (IItemProvider)Items.field_196156_dS, TaskType.MILESTONE).func_200275_a("0", (ICriterionInstance)AllTriggers.MUSICAL_ARM.instance()).func_203905_a(mechanical_arm).func_203904_a(t, id + ":musical_arm");
        Advancement arm_many_targets = this.advancement("arm_many_targets", (IItemProvider)AllBlocks.BRASS_FUNNEL.get(), TaskType.MILESTONE).func_200275_a("0", (ICriterionInstance)AllTriggers.ARM_MANY_TARGETS.instance()).func_203905_a(mechanical_arm).func_203904_a(t, id + ":arm_many_targets");
        Advancement arm_blaze_burner = this.advancement("arm_blaze_burner", (IItemProvider)AllBlocks.BLAZE_BURNER.get(), TaskType.NORMAL).func_200275_a("0", (ICriterionInstance)AllTriggers.ARM_BLAZE_BURNER.instance()).func_203905_a(mechanical_arm).func_203904_a(t, id + ":arm_blaze_burner");
        Advancement deployer = this.kinecticAdvancement("deployer", (Block)AllBlocks.DEPLOYER.get(), TaskType.MILESTONE).func_203905_a(brass_casing).func_203904_a(t, id + ":deployer");
        Advancement fist_bump = this.advancement("fist_bump", (IItemProvider)AllBlocks.DEPLOYER.get(), TaskType.SECRET).func_203905_a(deployer).func_200275_a("0", (ICriterionInstance)AllTriggers.DEPLOYER_BOOP.instance()).func_203904_a(t, id + ":fist_bump");
        Advancement crushing_wheel = this.advancement("crushing_wheel", (IItemProvider)AllBlocks.CRUSHING_WHEEL.get(), TaskType.MILESTONE).func_203905_a(crafter).func_200275_a("0", (ICriterionInstance)this.itemGathered((IItemProvider)AllBlocks.CRUSHING_WHEEL.get())).func_203904_a(t, id + ":crushing_wheel");
        Advancement blaze_cake = this.itemAdvancement("blaze_cake", AllItems.BLAZE_CAKE, TaskType.NORMAL).func_203905_a(crushing_wheel).func_203904_a(t, id + ":blaze_cake");
        Advancement chromatic_compound = this.itemAdvancement("chromatic_compound", AllItems.CHROMATIC_COMPOUND, TaskType.NORMAL).func_203905_a(blaze_cake).func_203904_a(t, id + ":chromatic_compound");
        Advancement shadow_steel = this.itemAdvancement("shadow_steel", AllItems.SHADOW_STEEL, TaskType.GOAL).func_203905_a(chromatic_compound).func_203904_a(t, id + ":shadow_steel");
        Advancement refined_radiance = this.itemAdvancement("refined_radiance", AllItems.REFINED_RADIANCE, TaskType.GOAL).func_203905_a(chromatic_compound).func_203904_a(t, id + ":refined_radiance");
        Advancement chromatic_age = this.advancement("chromatic_age", (IItemProvider)AllBlocks.REFINED_RADIANCE_CASING.get(), TaskType.GOAL).func_203905_a(chromatic_compound).func_200275_a("0", (ICriterionInstance)this.itemGathered((IItemProvider)AllBlocks.SHADOW_STEEL_CASING.get())).func_200275_a("1", (ICriterionInstance)this.itemGathered((IItemProvider)AllBlocks.REFINED_RADIANCE_CASING.get())).func_203904_a(t, id + "chromatic_age");
        Advancement chromatic_eob = this.deadEnd().func_203905_a(chromatic_age).func_200275_a("0", (ICriterionInstance)this.itemGathered((IItemProvider)AllBlocks.SHADOW_STEEL_CASING.get())).func_200275_a("1", (ICriterionInstance)this.itemGathered((IItemProvider)AllBlocks.REFINED_RADIANCE_CASING.get())).func_203904_a(t, id + ":chromatic_eob");
        Advancement deforester = this.itemAdvancement("deforester", AllItems.DEFORESTER, TaskType.NORMAL).func_203905_a(refined_radiance).func_203904_a(t, id + ":deforester");
        Advancement zapper = this.itemAdvancement("zapper", AllItems.BLOCKZAPPER, TaskType.NORMAL).func_203905_a(refined_radiance).func_203904_a(t, id + ":zapper");
        ItemStack gunWithPurpurStuff = AllItems.BLOCKZAPPER.asStack();
        for (BlockzapperItem.Components c : BlockzapperItem.Components.values()) {
            BlockzapperItem.setTier(c, BlockzapperItem.ComponentTier.Chromatic, gunWithPurpurStuff);
        }
        Advancement upgraded_zapper = this.advancement("upgraded_zapper", gunWithPurpurStuff, TaskType.CHALLENGE).func_200275_a("0", (ICriterionInstance)AllTriggers.UPGRADED_ZAPPER.instance()).func_203905_a(zapper).func_203904_a(t, id + ":upgraded_zapper");
        Advancement symmetry_wand = this.itemAdvancement("wand_of_symmetry", AllItems.WAND_OF_SYMMETRY, TaskType.NORMAL).func_203905_a(refined_radiance).func_203904_a(t, id + ":wand_of_symmetry");
    }

    public AllAdvancements(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = p_204017_3_ -> {
            if (!set.add(p_204017_3_.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + p_204017_3_.func_192067_g());
            }
            Path path1 = AllAdvancements.getPath(path, p_204017_3_);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)p_204017_3_.func_192075_a().func_200273_b(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        this.register(consumer);
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.func_192067_g().func_110624_b() + "/advancements/" + advancementIn.func_192067_g().func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "Create's Advancements";
    }

    public PlacedBlockTrigger.Instance placeBlock(Block block) {
        return PlacedBlockTrigger.Instance.func_203934_a((Block)block);
    }

    public KineticBlockTrigger.Instance isPowered(Block block) {
        return AllTriggers.KINETIC_BLOCK.forBlock(block);
    }

    public InventoryChangeTrigger.Instance itemGathered(IItemProvider itemprovider) {
        return InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{itemprovider});
    }

    public Advancement.Builder kinecticAdvancement(String name, Block block, TaskType type) {
        return this.advancement(name, (IItemProvider)block, type).func_200275_a("0", (ICriterionInstance)this.placeBlock(block));
    }

    public Advancement.Builder advancement(String name, IItemProvider icon, TaskType type) {
        return this.advancement(name, new ItemStack(icon), type);
    }

    public Advancement.Builder deadEnd() {
        return this.advancement("eob", (IItemProvider)Items.field_221592_t, TaskType.SILENT_GATE);
    }

    public Advancement.Builder advancement(String name, ItemStack icon, TaskType type) {
        return Advancement.Builder.func_200278_a().func_215092_a(icon, (ITextComponent)new TranslationTextComponent(LANG + name, new Object[0]), (ITextComponent)new TranslationTextComponent(LANG + name + ".desc", new Object[0]), null, type.frame, type.toast, type.announce, type.hide);
    }

    public Advancement.Builder itemAdvancement(String name, Supplier<? extends IItemProvider> item, TaskType type) {
        return this.advancement(name, item.get(), type).func_200275_a("0", (ICriterionInstance)this.itemGathered(item.get()));
    }

    static enum TaskType {
        NORMAL(FrameType.TASK, true, false, false),
        MILESTONE(FrameType.TASK, true, true, false),
        GOAL(FrameType.GOAL, true, true, false),
        SECRET(FrameType.GOAL, true, true, true),
        SILENT_GATE(FrameType.CHALLENGE, false, false, false),
        CHALLENGE(FrameType.CHALLENGE, true, true, false);

        private FrameType frame;
        private boolean toast;
        private boolean announce;
        private boolean hide;

        private TaskType(FrameType frame, boolean toast, boolean announce, boolean hide) {
            this.frame = frame;
            this.toast = toast;
            this.announce = announce;
            this.hide = hide;
        }
    }
}

