/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.config.AllConfigs;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;

public interface ITE<T extends TileEntity> {
    public Class<T> getTileEntityClass();

    default public void withTileEntityDo(IBlockReader world, BlockPos pos, Consumer<T> action) {
        try {
            action.accept(this.getTileEntity(world, pos));
        }
        catch (TileEntityException tileEntityException) {
            // empty catch block
        }
    }

    default public Optional<T> getTileEntityOptional(IBlockReader world, BlockPos pos) {
        try {
            return Optional.of(this.getTileEntity(world, pos));
        }
        catch (TileEntityException tileEntityException) {
            return Optional.empty();
        }
    }

    default public T getTileEntity(IBlockReader worldIn, BlockPos pos) throws TileEntityException {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        Class<T> expectedClass = this.getTileEntityClass();
        IWorld world = null;
        if (worldIn instanceof IWorld) {
            world = (IWorld)worldIn;
        }
        if (tileEntity == null) {
            throw new MissingTileEntityException(world, pos, expectedClass);
        }
        if (!expectedClass.isInstance(tileEntity)) {
            throw new InvalidTileEntityException(world, pos, expectedClass, tileEntity.getClass());
        }
        return (T)tileEntity;
    }

    public static void report(TileEntityException e) {
        if (((Boolean)AllConfigs.COMMON.logTeErrors.get()).booleanValue()) {
            Create.logger.debug("TileEntityException thrown!", (Throwable)e);
        }
    }

    public static class InvalidTileEntityException
    extends TileEntityException {
        private static final long serialVersionUID = 1L;

        public InvalidTileEntityException(IWorld world, BlockPos pos, Class<?> expectedTeClass, Class<?> foundTeClass) {
            super("Wrong TileEntity: " + InvalidTileEntityException.makeBaseMessage(world, pos, expectedTeClass) + ", found " + foundTeClass.getSimpleName());
        }
    }

    public static class MissingTileEntityException
    extends TileEntityException {
        private static final long serialVersionUID = 1L;

        public MissingTileEntityException(IWorld world, BlockPos pos, Class<?> teClass) {
            super("Missing TileEntity: " + MissingTileEntityException.makeBaseMessage(world, pos, teClass));
        }
    }

    public static class TileEntityException
    extends Throwable {
        private static final long serialVersionUID = 1L;

        public TileEntityException(IWorld world, BlockPos pos, Class<?> teClass) {
            super(TileEntityException.makeBaseMessage(world, pos, teClass));
        }

        public TileEntityException(String message) {
            super(message);
            ITE.report(this);
        }

        static String makeBaseMessage(IWorld world, BlockPos pos, Class<?> expectedTeClass) {
            return String.format("[%s] @(%d, %d, %d), expecting a %s", TileEntityException.getDimensionName(world), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), expectedTeClass.getSimpleName());
        }

        static String getDimensionName(IWorld world) {
            String notAvailable = "Dim N/A";
            if (world == null) {
                return notAvailable;
            }
            Dimension dimension = world.func_201675_m();
            if (dimension == null) {
                return notAvailable;
            }
            DimensionType type = dimension.func_186058_p();
            if (type == null) {
                return notAvailable;
            }
            ResourceLocation registryName = type.getRegistryName();
            if (registryName == null) {
                return notAvailable;
            }
            return registryName.toString();
        }
    }
}

