/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block.connected;

import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;

public abstract class ConnectedTextureBehaviour {
    public abstract CTSpriteShiftEntry get(BlockState var1, Direction var2);

    protected boolean reverseUVs(BlockState state, Direction face) {
        return false;
    }

    protected boolean reverseUVsHorizontally(BlockState state, Direction face) {
        return this.reverseUVs(state, face);
    }

    protected boolean reverseUVsVertically(BlockState state, Direction face) {
        return this.reverseUVs(state, face);
    }

    public boolean buildContextForOccludedDirections() {
        return false;
    }

    public boolean connectsTo(BlockState state, BlockState other, ILightReader reader, BlockPos pos, BlockPos otherPos, Direction face) {
        return !this.isBeingBlocked(state, reader, pos, otherPos, face) && state.func_177230_c() == other.func_177230_c();
    }

    protected boolean isBeingBlocked(BlockState state, ILightReader reader, BlockPos pos, BlockPos otherPos, Direction face) {
        BlockPos blockingPos = otherPos.func_177972_a(face);
        return face.func_176740_k().func_196052_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) == face.func_176740_k().func_196052_a(otherPos.func_177958_n(), otherPos.func_177956_o(), otherPos.func_177952_p()) && this.connectsTo(state, reader.func_180495_p(blockingPos), reader, pos, blockingPos, face);
    }

    public CTContext buildContext(ILightReader reader, BlockPos pos, BlockState state, Direction face) {
        CTContext context = new CTContext();
        CTSpriteShiftEntry textureEntry = this.get(state, face);
        if (textureEntry == null) {
            return context;
        }
        Direction.Axis axis = face.func_176740_k();
        boolean positive = face.func_176743_c() == Direction.AxisDirection.POSITIVE;
        Direction h = axis == Direction.Axis.X ? Direction.SOUTH : Direction.WEST;
        Direction v = axis.func_176722_c() ? Direction.UP : Direction.NORTH;
        Direction direction = h = positive ? h.func_176734_d() : h;
        if (face == Direction.DOWN) {
            v = v.func_176734_d();
            h = h.func_176734_d();
        }
        Direction horizontal = h;
        Direction vertical = v;
        boolean flipH = this.reverseUVsHorizontally(state, face);
        boolean flipV = this.reverseUVsVertically(state, face);
        int sh = flipH ? -1 : 1;
        int sv = flipV ? -1 : 1;
        CTSpriteShifter.CTType type = textureEntry.getType();
        if (type != CTSpriteShifter.CTType.HORIZONTAL) {
            context.up = this.testConnection(reader, pos, state, face, horizontal, vertical, 0, sv);
            context.down = this.testConnection(reader, pos, state, face, horizontal, vertical, 0, -sv);
        }
        if (type != CTSpriteShifter.CTType.VERTICAL) {
            context.left = this.testConnection(reader, pos, state, face, horizontal, vertical, -sh, 0);
            context.right = this.testConnection(reader, pos, state, face, horizontal, vertical, sh, 0);
        }
        if (type == CTSpriteShifter.CTType.OMNIDIRECTIONAL) {
            context.topLeft = this.testConnection(reader, pos, state, face, horizontal, vertical, -sh, sv);
            context.topRight = this.testConnection(reader, pos, state, face, horizontal, vertical, sh, sv);
            context.bottomLeft = this.testConnection(reader, pos, state, face, horizontal, vertical, -sh, -sv);
            context.bottomRight = this.testConnection(reader, pos, state, face, horizontal, vertical, sh, -sv);
        }
        return context;
    }

    private boolean testConnection(ILightReader reader, BlockPos pos, BlockState state, Direction face, Direction horizontal, Direction vertical, int sh, int sv) {
        BlockPos p = pos.func_177967_a(horizontal, sh).func_177967_a(vertical, sv);
        boolean test = this.connectsTo(state, reader.func_180495_p(p), reader, pos, p, face);
        return test;
    }

    public class CTContext {
        boolean up;
        boolean down;
        boolean left;
        boolean right;
        boolean topLeft;
        boolean topRight;
        boolean bottomLeft;
        boolean bottomRight;
    }
}

