/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.base.CasingBlock;
import com.simibubi.create.content.contraptions.components.crank.ValveHandleBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonGenerator;
import com.simibubi.create.content.contraptions.relays.encased.EncasedCTBehaviour;
import com.simibubi.create.content.contraptions.relays.encased.EncasedShaftBlock;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelItem;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelItem;
import com.simibubi.create.content.logistics.block.inventories.CrateBlock;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.config.StressConfigDefaults;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.util.nullness.NonNullUnaryOperator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.PistonType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class BuilderTransformers {
    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> cuckooClock() {
        return b -> (BlockBuilder)((BlockBuilder)b.initialProperties(SharedProperties::wooden).blockstate((c, p) -> p.horizontalBlock((Block)c.get(), (ModelFile)p.models().getExistingFile(p.modLoc("block/cuckoo_clock/block")))).addLayer(() -> RenderType::func_228641_d_).transform(StressConfigDefaults.setImpact(1.0))).item().transform(ModelGen.customItemModel("cuckoo_clock", "item"));
    }

    public static <B extends EncasedShaftBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> encasedShaft(String casing, CTSpriteShiftEntry casingShift) {
        return builder -> (BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)builder.initialProperties(SharedProperties::stone).properties(Block.Properties::func_226896_b_).onRegister(CreateRegistrate.connectedTextures(new EncasedCTBehaviour(casingShift)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, casingShift, (s, f) -> f.func_176740_k() != s.func_177229_b((IProperty)EncasedShaftBlock.AXIS))))).blockstate((c, p) -> BlockStateGen.axisBlock(c, p, blockState -> p.models().getExistingFile(p.modLoc("block/encased_shaft/block_" + casing)), true)).transform(StressConfigDefaults.setNoImpact())).loot((p, b) -> p.func_218493_a(b, (IItemProvider)AllBlocks.SHAFT.get())).item().model(AssetLookup.customItemModel("encased_shaft", "item_" + casing)).build();
    }

    public static <B extends ValveHandleBlock> NonNullUnaryOperator<BlockBuilder<B, CreateRegistrate>> valveHandle(@Nullable DyeColor color) {
        return b -> (BlockBuilder)((BlockBuilder)b.initialProperties(SharedProperties::softMetal).blockstate((c, p) -> {
            String variant = color == null ? "copper" : color.func_176610_l();
            p.directionalBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)p.models().withExistingParent(variant + "_valve_handle", p.modLoc("block/valve_handle"))).texture("3", p.modLoc("block/valve_handle/valve_handle_" + variant)));
        }).onRegisterAfter(Item.class, v -> {
            if (color != null) {
                TooltipHelper.referTo((IItemProvider)v, AllBlocks.COPPER_VALVE_HANDLE);
            }
        })).tag(AllTags.AllBlockTags.BRITTLE.tag, AllTags.AllBlockTags.VALVE_HANDLES.tag).item().tag(AllTags.AllItemTags.VALVE_HANDLES.tag).build();
    }

    public static <B extends CasingBlock> NonNullUnaryOperator<BlockBuilder<B, CreateRegistrate>> casing(CTSpriteShiftEntry ct) {
        return b -> ((BlockBuilder)((BlockBuilder)b.initialProperties(SharedProperties::stone).blockstate((c, p) -> p.simpleBlock((Block)c.get())).onRegister(CreateRegistrate.connectedTextures(new EncasedCTBehaviour(ct)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.makeCasing((Block)block, ct)))).simpleItem();
    }

    public static <B extends FunnelBlock> NonNullUnaryOperator<BlockBuilder<B, CreateRegistrate>> funnel(String type, ResourceLocation particleTexture) {
        return b -> (BlockBuilder)b.blockstate((c, p) -> {
            Function<BlockState, ModelFile> model = s -> {
                String powered = s.func_196959_b((IProperty)BlockStateProperties.field_208194_u) && (Boolean)s.func_177229_b((IProperty)BlockStateProperties.field_208194_u) != false ? "_powered" : "";
                return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent("block/" + type + "_funnel" + powered, p.modLoc("block/funnel/block"))).texture("0", p.modLoc("block/" + type + "_funnel_plating"))).texture("1", particleTexture)).texture("2", p.modLoc("block/" + type + "_funnel" + powered))).texture("3", p.modLoc("block/" + type + "_funnel_back"));
            };
            p.directionalBlock((Block)c.get(), model);
        }).item(FunnelItem::new).model((c, p) -> ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.withExistingParent("item/" + type + "_funnel", p.modLoc("block/funnel/item"))).texture("0", p.modLoc("block/" + type + "_funnel_plating"))).texture("1", particleTexture)).texture("2", p.modLoc("block/" + type + "_funnel"))).texture("3", p.modLoc("block/" + type + "_funnel_back"))).build();
    }

    public static <B extends BeltTunnelBlock> NonNullUnaryOperator<BlockBuilder<B, CreateRegistrate>> beltTunnel(String type, ResourceLocation particleTexture) {
        return b -> (BlockBuilder)b.initialProperties(SharedProperties::stone).addLayer(() -> RenderType::func_228641_d_).properties(Block.Properties::func_226896_b_).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> {
            String id = "block/" + type + "_tunnel";
            BeltTunnelBlock.Shape shape = (BeltTunnelBlock.Shape)((Object)((Object)((Object)((Object)state.func_177229_b(BeltTunnelBlock.SHAPE)))));
            if (shape == BeltTunnelBlock.Shape.CLOSED) {
                shape = BeltTunnelBlock.Shape.STRAIGHT;
            }
            String shapeName = shape.func_176610_l();
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(id + "/" + shapeName, p.modLoc("block/belt_tunnel/" + shapeName))).texture("1", p.modLoc(id + "_top"))).texture("2", p.modLoc(id))).texture("3", p.modLoc(id + "_top_window"))).texture("particle", particleTexture)).rotationY(state.func_177229_b(BeltTunnelBlock.HORIZONTAL_AXIS) == Direction.Axis.X ? 0 : 90).build();
        })).item(BeltTunnelItem::new).model((c, p) -> {
            String id = type + "_tunnel";
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.withExistingParent("item/" + id, p.modLoc("block/belt_tunnel/item"))).texture("1", p.modLoc("block/" + id + "_top"))).texture("2", p.modLoc("block/" + id))).texture("particle", particleTexture);
        }).build();
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> mechanicalPiston(PistonType type) {
        return b -> (BlockBuilder)((BlockBuilder)((BlockBuilder)b.initialProperties(SharedProperties::stone).properties(p -> p.func_226896_b_()).blockstate(new MechanicalPistonGenerator(type)::generate).addLayer(() -> RenderType::func_228641_d_).transform(StressConfigDefaults.setImpact(4.0))).onRegisterAfter(Item.class, v -> TooltipHelper.referTo((IItemProvider)v, "block.create.mechanical_piston"))).item().transform(ModelGen.customItemModel("mechanical_piston", type.func_176610_l(), "item"));
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> bearing(String prefix, String backTexture, boolean woodenTop) {
        ResourceLocation baseBlockModelLocation = Create.asResource("block/bearing/block");
        ResourceLocation baseItemModelLocation = Create.asResource("block/bearing/item");
        ResourceLocation topTextureLocation = Create.asResource("block/bearing_top" + (woodenTop ? "_wooden" : ""));
        ResourceLocation nookTextureLocation = Create.asResource("block/" + (woodenTop ? "andesite" : "brass") + "_casing");
        ResourceLocation sideTextureLocation = Create.asResource("block/" + prefix + "_bearing_side");
        ResourceLocation backTextureLocation = Create.asResource("block/" + backTexture);
        return b -> (BlockBuilder)b.initialProperties(SharedProperties::stone).properties(p -> p.func_226896_b_()).blockstate((c, p) -> p.directionalBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName(), baseBlockModelLocation)).texture("side", sideTextureLocation)).texture("nook", nookTextureLocation)).texture("back", backTextureLocation))).item().model((c, p) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.withExistingParent(c.getName(), baseItemModelLocation)).texture("top", topTextureLocation)).texture("side", sideTextureLocation)).texture("back", backTextureLocation);
        }).build();
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> crate(String type) {
        return b -> (BlockBuilder)b.initialProperties(SharedProperties::stone).blockstate((c, p) -> {
            String[] variants = new String[]{"single", "top", "bottom", "left", "right"};
            HashMap<String, ModelBuilder> models = new HashMap<String, ModelBuilder>();
            ResourceLocation crate = p.modLoc("block/crate_" + type);
            ResourceLocation side = p.modLoc("block/crate_" + type + "_side");
            ResourceLocation casing = p.modLoc("block/" + type + "_casing");
            for (String variant : variants) {
                models.put(variant, ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent("block/crate/" + type + "/" + variant, p.modLoc("block/crate/" + variant))).texture("crate", crate)).texture("side", side)).texture("casing", casing));
            }
            p.getVariantBuilder((Block)c.get()).forAllStates(state -> {
                String variant = "single";
                int yRot = 0;
                if (((Boolean)state.func_177229_b((IProperty)CrateBlock.DOUBLE)).booleanValue()) {
                    Direction direction = (Direction)state.func_177229_b((IProperty)CrateBlock.field_176387_N);
                    if (direction.func_176740_k() == Direction.Axis.X) {
                        yRot = 90;
                    }
                    switch (direction) {
                        case DOWN: {
                            variant = "top";
                            break;
                        }
                        case NORTH: 
                        case EAST: {
                            variant = "right";
                            break;
                        }
                        case UP: {
                            variant = "bottom";
                            break;
                        }
                        default: {
                            variant = "left";
                        }
                    }
                }
                return ConfiguredModel.builder().modelFile((ModelFile)models.get(variant)).rotationY(yRot).build();
            });
        }).item().transform(ModelGen.customItemModel("crate", type, "single"));
    }
}

