/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractSimiScreen
extends Screen {
    protected int sWidth;
    protected int sHeight;
    protected int guiLeft;
    protected int guiTop;
    protected List<Widget> widgets = new ArrayList<Widget>();

    protected AbstractSimiScreen() {
        super((ITextComponent)new StringTextComponent(""));
    }

    protected void setWindowSize(int width, int height) {
        this.sWidth = width;
        this.sHeight = height;
        this.guiLeft = (this.width - this.sWidth) / 2;
        this.guiTop = (this.height - this.sHeight) / 2;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.renderWindow(mouseX, mouseY, partialTicks);
        for (Widget widget : this.widgets) {
            widget.render(mouseX, mouseY, partialTicks);
        }
        this.renderWindowForeground(mouseX, mouseY, partialTicks);
        for (Widget widget : this.widgets) {
            widget.renderToolTip(mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double x, double y, int button) {
        boolean result = false;
        for (Widget widget : this.widgets) {
            if (!widget.mouseClicked(x, y, button)) continue;
            result = true;
        }
        return result;
    }

    public boolean keyPressed(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        for (Widget widget : this.widgets) {
            if (!widget.keyPressed(code, p_keyPressed_2_, p_keyPressed_3_)) continue;
            return true;
        }
        return super.keyPressed(code, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean charTyped(char character, int code) {
        for (Widget widget : this.widgets) {
            if (!widget.charTyped(character, code)) continue;
            return true;
        }
        if (character == 'e') {
            this.onClose();
        }
        return super.charTyped(character, code);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        for (Widget widget : this.widgets) {
            if (!widget.mouseScrolled(mouseX, mouseY, delta)) continue;
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, delta);
    }

    public boolean mouseReleased(double x, double y, int button) {
        boolean result = false;
        for (Widget widget : this.widgets) {
            if (!widget.mouseReleased(x, y, button)) continue;
            result = true;
        }
        return result | super.mouseReleased(x, y, button);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected abstract void renderWindow(int var1, int var2, float var3);

    protected void renderWindowForeground(int mouseX, int mouseY, float partialTicks) {
        for (Widget widget : this.widgets) {
            if (!widget.isHovered() || !(widget instanceof AbstractSimiWidget) || ((AbstractSimiWidget)widget).getToolTip().isEmpty()) continue;
            this.renderTooltip(((AbstractSimiWidget)widget).getToolTip(), mouseX, mouseY);
        }
    }
}

