/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.filtering;

import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class SidedFilteringBehaviour
extends FilteringBehaviour {
    Map<Direction, FilteringBehaviour> sidedFilters;
    private BiFunction<Direction, FilteringBehaviour, FilteringBehaviour> filterFactory;
    private Predicate<Direction> validDirections;

    public SidedFilteringBehaviour(SmartTileEntity te, ValueBoxTransform.Sided sidedSlot, BiFunction<Direction, FilteringBehaviour, FilteringBehaviour> filterFactory, Predicate<Direction> validDirections) {
        super(te, sidedSlot);
        this.filterFactory = filterFactory;
        this.validDirections = validDirections;
        this.sidedFilters = new IdentityHashMap<Direction, FilteringBehaviour>();
        this.updateFilterPresence();
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public FilteringBehaviour get(Direction side) {
        return this.sidedFilters.get(side);
    }

    public void updateFilterPresence() {
        HashSet<Direction> valid = new HashSet<Direction>();
        for (Direction d : Iterate.directions) {
            if (!this.validDirections.test(d)) continue;
            valid.add(d);
        }
        for (Direction d : Iterate.directions) {
            if (valid.contains(d)) {
                if (this.sidedFilters.containsKey(d)) continue;
                this.sidedFilters.put(d, this.filterFactory.apply(d, new FilteringBehaviour(this.tileEntity, this.slotPositioning)));
                continue;
            }
            if (!this.sidedFilters.containsKey(d)) continue;
            this.removeFilter(d);
        }
    }

    @Override
    public void write(CompoundNBT nbt, boolean clientPacket) {
        nbt.func_218657_a("Filters", (INBT)NBTHelper.writeCompoundList(this.sidedFilters.entrySet(), entry -> {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74768_a("Side", ((Direction)entry.getKey()).func_176745_a());
            ((FilteringBehaviour)entry.getValue()).write(compound, clientPacket);
            return compound;
        }));
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(CompoundNBT nbt, boolean clientPacket) {
        NBTHelper.iterateCompoundList(nbt.func_150295_c("Filters", 10), compound -> {
            Direction face = Direction.func_82600_a((int)compound.func_74762_e("Side"));
            if (this.sidedFilters.containsKey(face)) {
                this.sidedFilters.get(face).read((CompoundNBT)compound, clientPacket);
            }
        });
        super.read(nbt, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        this.sidedFilters.values().forEach(FilteringBehaviour::tick);
    }

    @Override
    public void setFilter(Direction side, ItemStack stack) {
        if (!this.sidedFilters.containsKey(side)) {
            return;
        }
        this.sidedFilters.get(side).setFilter(stack);
    }

    @Override
    public ItemStack getFilter(Direction side) {
        if (!this.sidedFilters.containsKey(side)) {
            return ItemStack.field_190927_a;
        }
        return this.sidedFilters.get(side).getFilter();
    }

    public boolean test(Direction side, ItemStack stack) {
        if (!this.sidedFilters.containsKey(side)) {
            return true;
        }
        return this.sidedFilters.get(side).test(stack);
    }

    @Override
    public void destroy() {
        this.sidedFilters.values().forEach(FilteringBehaviour::destroy);
        super.destroy();
    }

    public void removeFilter(Direction side) {
        if (!this.sidedFilters.containsKey(side)) {
            return;
        }
        this.sidedFilters.remove(side).destroy();
    }

    public boolean testHit(Direction direction, Vec3d hit) {
        ValueBoxTransform.Sided sidedPositioning = (ValueBoxTransform.Sided)this.slotPositioning;
        BlockState state = this.tileEntity.func_195044_w();
        Vec3d localHit = hit.func_178788_d(new Vec3d((Vec3i)this.tileEntity.func_174877_v()));
        return sidedPositioning.fromSide(direction).testHit(state, localHit);
    }
}

