/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.placement;

import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class PlacementOffset {
    private final boolean success;
    private final Vec3i pos;
    private final Function<BlockState, BlockState> stateTransform;

    private PlacementOffset(boolean success, Vec3i pos, Function<BlockState, BlockState> transform) {
        this.success = success;
        this.pos = pos;
        this.stateTransform = transform == null ? Function.identity() : transform;
    }

    public static PlacementOffset fail() {
        return new PlacementOffset(false, Vec3i.field_177959_e, null);
    }

    public static PlacementOffset success(Vec3i pos) {
        return new PlacementOffset(true, pos, null);
    }

    public static PlacementOffset success(Vec3i pos, Function<BlockState, BlockState> transform) {
        return new PlacementOffset(true, pos, transform);
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public Vec3i getPos() {
        return this.pos;
    }

    public Function<BlockState, BlockState> getTransform() {
        return this.stateTransform;
    }

    public boolean isReplaceable(World world) {
        if (!this.success) {
            return false;
        }
        return world.func_180495_p(new BlockPos(this.pos)).func_185904_a().func_76222_j();
    }

    public void placeInWorld(World world, BlockItem blockItem, PlayerEntity player, ItemStack item) {
        this.placeInWorld(world, blockItem.func_179223_d().func_176223_P(), player, item);
    }

    public void placeInWorld(World world, BlockState defaultState, PlayerEntity player, ItemStack item) {
        if (world.field_72995_K) {
            return;
        }
        BlockPos newPos = new BlockPos(this.pos);
        BlockState state = this.stateTransform.apply(defaultState);
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208198_y)) {
            IFluidState fluidState = world.func_204610_c(newPos);
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
        }
        world.func_175656_a(newPos, state);
        if (!player.func_184812_l_()) {
            item.func_190918_g(1);
        }
    }
}

