/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;

@JeiPlugin
public class IntegrationJEI
implements IModPlugin {
    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("tombstone");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        jeiRuntime.getIngredientManager().addIngredientsAtRuntime(VanillaTypes.ITEM, Collections.singleton(new ItemStack((IItemProvider)ModItems.grave_key)));
    }

    public void registerRecipes(IRecipeRegistration registry) {
        ImmutableList.Builder builder = ImmutableList.builder();
        IVanillaRecipeFactory factory = registry.getVanillaRecipeFactory();
        this.addAnvilRecipeToGrave((ImmutableList.Builder<Object>)builder, factory, GraveModel.GRAVE_SIMPLE, "Corail31", "Gegy1000");
        this.addAnvilRecipeToGrave((ImmutableList.Builder<Object>)builder, factory, GraveModel.GRAVE_NORMAL, "Barteks2x", "Runemoro");
        this.addAnvilRecipeToGrave((ImmutableList.Builder<Object>)builder, factory, GraveModel.GRAVE_CROSS, "Goshen", "Paul Fulham");
        this.addAnvilRecipeToGrave((ImmutableList.Builder<Object>)builder, factory, GraveModel.TOMBSTONE, "Darkhax");
        this.addAnvilRecipeToGrave((ImmutableList.Builder<Object>)builder, factory, GraveModel.SUBARAKI_GRAVE, "Subaraki");
        this.addAnvilRecipeToGrave((ImmutableList.Builder<Object>)builder, factory, GraveModel.GRAVE_ORIGINAL, "Raycoms");
        ItemStack tablet = NBTStackHelper.setBoolean(new ItemStack((IItemProvider)ModItems.tablet_of_assistance), "enchant", true);
        builder.add(registry.getVanillaRecipeFactory().createAnvilRecipe(tablet, Collections.singletonList(new ItemStack((IItemProvider)ModItems.grave_dust)), Collections.singletonList(NBTStackHelper.setString(tablet.func_77946_l(), "engraved_name", "Corail31"))));
        registry.addRecipes((Collection)builder.build(), VanillaRecipeCategoryUid.ANVIL);
    }

    private void addAnvilRecipeToGrave(ImmutableList.Builder<Object> builder, IVanillaRecipeFactory factory, GraveModel model, String ... engravedName) {
        builder.addAll((Iterable)IntStream.rangeClosed(0, 1).mapToObj(modelId -> factory.createAnvilRecipe(ItemBlockGrave.createDecorativeStack(model, modelId), Collections.singletonList(new ItemStack((IItemProvider)Items.field_151042_j)), Collections.singletonList(ItemBlockGrave.createDecorativeStack(model, modelId, engravedName[Math.min(modelId, engravedName.length - 1)])))).collect(Collectors.toList()));
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        for (Block block : ModBlocks.decorative_graves.values()) {
            registration.registerSubtypeInterpreter(block.func_199767_j(), (ISubtypeInterpreter)new DecorativeGraveInterpreter());
        }
        registration.registerSubtypeInterpreter((Item)ModItems.tablet_of_home, (ISubtypeInterpreter)new AncientTabletInterpreter());
        registration.registerSubtypeInterpreter((Item)ModItems.tablet_of_recall, (ISubtypeInterpreter)new AncientTabletInterpreter());
    }

    private static class AncientTabletInterpreter
    implements ISubtypeInterpreter {
        private AncientTabletInterpreter() {
        }

        public String apply(ItemStack stack) {
            if (stack.func_77973_b() == ModItems.tablet_of_home || stack.func_77973_b() == ModItems.tablet_of_recall) {
                return String.valueOf(((ItemTablet)stack.func_77973_b()).isAncient(stack));
            }
            return "0";
        }
    }

    private static class DecorativeGraveInterpreter
    implements ISubtypeInterpreter {
        private DecorativeGraveInterpreter() {
        }

        public String apply(ItemStack stack) {
            return String.valueOf(ItemBlockGrave.getModelTexture(stack));
        }
    }
}

