/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;

public class EffectMessage {
    private int entityId;
    private EffectInstance effectInstance;

    public EffectMessage(int entityId, EffectInstance effectInstance) {
        this.entityId = entityId;
        this.effectInstance = effectInstance;
    }

    static EffectMessage fromBytes(PacketBuffer buf) {
        int id = buf.readInt();
        CompoundNBT effect = buf.func_150793_b();
        return new EffectMessage(id, effect == null ? new EffectInstance(Effects.field_76443_y) : EffectInstance.func_82722_b((CompoundNBT)effect));
    }

    static void toBytes(EffectMessage msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.func_150786_a(msg.effectInstance.func_82719_a(new CompoundNBT()));
    }

    public static class Handler {
        static void handle(final EffectMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        Entity entity;
                        Entity entity2 = entity = Minecraft.func_71410_x().field_71441_e != null ? Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.entityId) : null;
                        if (entity instanceof LivingEntity) {
                            EffectHelper.addEffect((LivingEntity)entity, msg.effectInstance);
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

