/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.block;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.DyeColor;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import nomadictents.block.BlockTentDoor;
import nomadictents.block.BlockUnbreakable;
import nomadictents.block.Categories;
import nomadictents.block.TileEntityTentDoor;
import nomadictents.dimension.TentDimensionManager;
import nomadictents.init.Content;

public class BlockShamianaWall
extends BlockUnbreakable
implements Categories.IShamianaBlock {
    public static final BooleanProperty PATTERN = BooleanProperty.func_177716_a((String)"pattern");
    private final DyeColor color;
    private static final Block[] blockColors = new Block[16];
    private static final Block[] blockColorsCosmetic = new Block[16];

    public BlockShamianaWall(DyeColor colorIn, String name, boolean cosmetic) {
        super(Block.Properties.func_200952_a((Material)Material.field_151580_n, (DyeColor)colorIn).func_208770_d(), cosmetic);
        this.color = colorIn;
        this.setRegistryName("nomadictents", name);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)PATTERN, (Comparable)Boolean.valueOf(false)));
        if (cosmetic) {
            BlockShamianaWall.blockColorsCosmetic[colorIn.ordinal()] = this;
        } else {
            BlockShamianaWall.blockColors[colorIn.ordinal()] = this;
        }
    }

    public BlockShamianaWall(DyeColor colorIn, boolean cosmetic) {
        this(colorIn, (cosmetic ? "cos_shamiana_" : "shamiana_").concat(colorIn.func_176610_l()), cosmetic);
    }

    public DyeColor getColor() {
        return this.color;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{PATTERN});
    }

    public void func_220082_b(BlockState stateIn, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(stateIn, worldIn, pos, oldState, isMoving);
        if (!TentDimensionManager.isTent((IWorld)worldIn) && stateIn.func_177230_c() == Content.SHAMIANA_WALL_WHITE) {
            BlockPos doorPos = BlockShamianaWall.traceToDoorNearby(worldIn, pos);
            BlockState state = null;
            if (doorPos != null && worldIn.func_175625_s(doorPos) instanceof TileEntityTentDoor) {
                DyeColor colorCur = ((TileEntityTentDoor)worldIn.func_175625_s(doorPos)).getTentData().getColor();
                state = BlockShamianaWall.getShamianaState(colorCur, BlockShamianaWall.shouldBePattern(pos, doorPos), true);
            }
            if (state != null) {
                worldIn.func_180501_a(pos, state, 2);
            }
        }
    }

    public static boolean shouldBePattern(BlockPos myPos, BlockPos doorPos) {
        return (myPos.func_177956_o() - doorPos.func_177956_o()) % 3 == 0;
    }

    private static BlockPos traceToDoorNearby(World world, BlockPos posIn) {
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        BlockPos pos = posIn;
        while (pos != null && !(world.func_180495_p(pos).func_177230_c() instanceof BlockTentDoor)) {
            pos = BlockShamianaWall.traceNextShamianaBlock(world, checked, pos);
        }
        if (pos == null) {
            return null;
        }
        boolean isLower = world.func_180495_p(pos).func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.LOWER;
        return isLower ? pos : pos.func_177979_c(1);
    }

    private static BlockPos traceNextShamianaBlock(World worldIn, Set<BlockPos> exclude, BlockPos pos) {
        int radius = 1;
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos checkPos = pos.func_177982_a(x, y, z);
                    BlockState stateAt = worldIn.func_180495_p(checkPos);
                    if (exclude.contains(checkPos) || !(stateAt.func_177230_c() instanceof Categories.IShamianaBlock) && !(stateAt.func_177230_c() instanceof Categories.IFrameBlock)) continue;
                    exclude.add(checkPos);
                    return checkPos;
                }
            }
        }
        return null;
    }

    public static Block getShamianaBlock(DyeColor color, boolean indestructible) {
        if (color == null) {
            return Content.SHAMIANA_WALL_WHITE;
        }
        if (indestructible) {
            return blockColors[color.ordinal()] != null ? blockColors[color.ordinal()] : Content.SHAMIANA_WALL_WHITE;
        }
        return blockColorsCosmetic[color.ordinal()] != null ? blockColorsCosmetic[color.ordinal()] : Content.COS_SHAMIANA_WALL_WHITE;
    }

    public static BlockState getShamianaState(DyeColor color, boolean pattern, boolean indestructible) {
        return (BlockState)BlockShamianaWall.getShamianaBlock(color, indestructible).func_176223_P().func_206870_a((IProperty)PATTERN, (Comparable)Boolean.valueOf(pattern));
    }
}

