/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import nomadictents.block.BlockUnbreakable;
import nomadictents.block.Categories;
import nomadictents.block.TileEntityTentDoor;
import nomadictents.dimension.TentDimension;
import nomadictents.dimension.TentDimensionManager;
import nomadictents.event.TentEvent;
import nomadictents.init.Content;
import nomadictents.init.NomadicTents;
import nomadictents.init.TentConfig;
import nomadictents.item.ItemMallet;
import nomadictents.structure.StructureBase;
import nomadictents.structure.util.TentData;

public abstract class BlockTentDoor
extends BlockUnbreakable
implements Categories.ITepeeBlock,
Categories.IYurtBlock,
Categories.IBedouinBlock,
Categories.IIndluBlock,
Categories.IShamianaBlock {
    public static final EnumProperty<Direction.Axis> AXIS = EnumProperty.func_177706_a((String)"axis", Direction.Axis.class, (Enum[])new Direction.Axis[]{Direction.Axis.X, Direction.Axis.Z});
    public static final int DECONSTRUCT_DAMAGE = 5;
    protected static final double aabbDis = 0.375;
    protected static final VoxelShape AABB_X = VoxelShapes.func_197873_a((double)0.375, (double)0.0, (double)0.0, (double)0.625, (double)1.0, (double)1.0);
    protected static final VoxelShape AABB_Z = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.375, (double)1.0, (double)1.0, (double)0.625);

    public BlockTentDoor(String name) {
        super(Block.Properties.func_200945_a((Material)Material.field_151580_n).func_208770_d());
        this.setRegistryName("nomadictents", name);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a(AXIS, (Comparable)Direction.Axis.X));
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult raytrace) {
        if (worldIn.field_72995_K) return ActionResultType.PASS;
        BlockPos base = state.func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.LOWER ? pos : pos.func_177979_c(1);
        TileEntity te = worldIn.func_175625_s(base);
        if (te instanceof TileEntityTentDoor) {
            Direction dir;
            TileEntityTentDoor teyd = (TileEntityTentDoor)te;
            TentData dataOverworld = teyd.getTentData().copyForOverworld();
            StructureBase struct = dataOverworld.getStructure();
            ItemStack held = player.func_184586_b(hand);
            if ((player.func_184812_l_() || !((Boolean)TentConfig.CONFIG.COPY_CREATIVE_ONLY.get()).booleanValue()) && held != null && held.func_77942_o() && held.func_77978_p().func_74764_b("TentCopyTool") && held.func_77978_p().func_74767_n("TentCopyTool")) {
                ItemStack copyStack = teyd.getTentData().getDropStack();
                if (copyStack == null) return ActionResultType.PASS;
                ItemEntity dropItem = new ItemEntity(worldIn, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), copyStack);
                dropItem.func_174867_a(0);
                worldIn.func_217376_c((Entity)dropItem);
                player.field_71088_bW = player.func_82147_ab();
                return ActionResultType.PASS;
            }
            Direction direction = dir = TentDimensionManager.isTent((IWorld)worldIn) ? TentDimension.STRUCTURE_DIR : struct.getValidFacing(worldIn, base, dataOverworld);
            if (dir == null) {
                return ActionResultType.FAIL;
            }
            if (held == null || !(held.func_77973_b() instanceof ItemMallet) || TentDimensionManager.isTent((IWorld)worldIn)) return ((TileEntityTentDoor)te).onPlayerActivate(player) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
            if (((Boolean)TentConfig.CONFIG.OWNER_PICKUP.get()).booleanValue() && teyd.hasOwner() && !teyd.isOwner(player)) {
                return ActionResultType.FAIL;
            }
            TentEvent.Deconstruct event = new TentEvent.Deconstruct(teyd, player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            ItemStack toDrop = event.getTentStack();
            if (toDrop == null) return ActionResultType.PASS;
            ItemEntity dropItem = new ItemEntity(worldIn, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), toDrop);
            dropItem.func_174867_a(0);
            worldIn.func_217376_c((Entity)dropItem);
            if (((Boolean)TentConfig.CONFIG.ALLOW_OVERWORLD_SETSPAWN.get()).booleanValue()) {
                teyd.onPlayerRemove(player);
            }
            struct.remove(worldIn, base, dataOverworld, dir);
            held.func_222118_a(5, (LivingEntity)player, c -> c.func_213334_d(hand));
            return ActionResultType.SUCCESS;
        }
        NomadicTents.LOGGER.error("Error! Failed to retrieve TileEntityTentDoor at " + pos);
        return ActionResultType.PASS;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.func_196262_a(worldIn.func_180495_p(pos), worldIn, pos, entityIn);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        TileEntity te;
        BlockPos lowerPos;
        BlockPos blockPos = lowerPos = state.func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER ? pos.func_177979_c(1) : pos;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(lowerPos)) instanceof TileEntityTentDoor) {
            Direction dir;
            TileEntityTentDoor teDoor = (TileEntityTentDoor)te;
            TentData dataOverworld = teDoor.getTentData().copyForOverworld();
            StructureBase struct = dataOverworld.getStructure();
            Direction direction = dir = TentDimensionManager.isTent((IWorld)worldIn) ? TentDimension.STRUCTURE_DIR : struct.getValidFacing(worldIn, lowerPos, dataOverworld);
            if (dir != null) {
                teDoor.onEntityCollide(entityIn, dir);
            }
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.LOWER) {
            worldIn.func_180501_a(pos.func_177984_a(), (BlockState)state.func_206870_a((IProperty)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER), 3);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext cxt) {
        switch ((Direction.Axis)state.func_177229_b(AXIS)) {
            case Z: {
                return AABB_Z;
            }
            case X: {
                return AABB_X;
            }
        }
        return VoxelShapes.func_197868_b();
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, BlockState state) {
        if (state.func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.LOWER) {
            worldIn.func_217377_a(pos.func_177981_b(1), false);
        } else {
            worldIn.func_217377_a(pos.func_177979_c(1), false);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{DoorBlock.field_176523_O, AXIS});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return Content.TE_DOOR.func_200968_a();
    }
}

