/*
 * Decompiled with CFR 0.152.
 */
package nomadictents.block;

import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import nomadictents.block.BlockUnbreakable;
import nomadictents.block.Categories;
import nomadictents.init.Content;
import nomadictents.init.TentConfig;
import nomadictents.item.ItemMallet;

public class BlockTentFrame
extends BlockUnbreakable
implements Categories.IFrameBlock {
    public static final int MAX_META = 7;
    public static final int CONSTRUCT_DAMAGE = 1;
    public static final int BASE_EFFECTIVENESS = 2;
    public static final IntegerProperty PROGRESS = IntegerProperty.func_177719_a((String)"progress", (int)0, (int)7);
    public static final VoxelShape AABB_PROGRESS_0 = BlockTentFrame.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.25, (double)1.0);
    public static final VoxelShape AABB_PROGRESS_1 = BlockTentFrame.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
    public static final VoxelShape AABB_PROGRESS_2 = BlockTentFrame.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private final Supplier<BlockState> blockToBecome;

    public BlockTentFrame(Supplier<BlockState> become, String name) {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200942_a().func_226896_b_());
        this.blockToBecome = become;
        this.setRegistryName("nomadictents", name);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)PROGRESS, (Comparable)Integer.valueOf(0)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult result) {
        ItemStack heldItem;
        ItemStack itemStack = heldItem = hand != null && playerIn != null ? playerIn.func_184586_b(hand) : null;
        if (!worldIn.field_72995_K && heldItem != null && heldItem.func_77973_b() instanceof ItemMallet) {
            if (heldItem.func_77973_b() == Content.ITEM_SUPER_MALLET) {
                return this.onSuperMalletUsed(worldIn, pos, state, heldItem, playerIn, hand) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
            }
            return this.onMalletUsed(worldIn, pos, state, heldItem, playerIn, hand) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        int meta = 0;
        if (state.func_196959_b((IProperty)PROGRESS)) {
            meta = (Integer)state.func_177229_b((IProperty)PROGRESS);
        }
        if (meta <= 1) {
            return AABB_PROGRESS_0;
        }
        if (meta <= 3) {
            return AABB_PROGRESS_1;
        }
        return AABB_PROGRESS_2;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext cxt) {
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.func_196247_c(state, worldIn, pos);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{PROGRESS});
    }

    public int getEffectiveness(World worldIn, BlockPos pos, ItemStack mallet, PlayerEntity player) {
        return 2;
    }

    public boolean becomeReal(World worldIn, BlockPos pos, ItemStack mallet, PlayerEntity player, Hand hand) {
        if (!worldIn.field_72995_K && worldIn.func_180501_a(pos, this.getBlockToBecome(), 3)) {
            mallet.func_222118_a(1, (LivingEntity)player, c -> c.func_213334_d(hand));
            return true;
        }
        return false;
    }

    public BlockState getBlockToBecome() {
        return this.blockToBecome.get();
    }

    public boolean onMalletUsed(World worldIn, BlockPos pos, BlockState state, ItemStack mallet, PlayerEntity player, Hand hand) {
        int meta = (Integer)state.func_177229_b((IProperty)PROGRESS);
        int nextMeta = meta + this.getEffectiveness(worldIn, pos, mallet, player);
        worldIn.func_180501_a(pos, (BlockState)this.func_176223_P().func_206870_a((IProperty)PROGRESS, (Comparable)Integer.valueOf(Math.min(nextMeta, 7))), 3);
        if (nextMeta >= 7) {
            this.becomeReal(worldIn, pos, mallet, player, hand);
        }
        return true;
    }

    public boolean onSuperMalletUsed(World worldIn, BlockPos pos, BlockState state, ItemStack mallet, PlayerEntity player, Hand hand) {
        if (((Boolean)TentConfig.CONFIG.SUPER_MALLET_CREATIVE_ONLY.get()).booleanValue() && !player.func_184812_l_()) {
            return false;
        }
        this.becomeReal(worldIn, pos, mallet, player, hand);
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    BlockPos curPos = new BlockPos(pos.func_177958_n() + i, pos.func_177956_o() + j, pos.func_177952_p() + k);
                    Block current = worldIn.func_180495_p(curPos).func_177230_c();
                    if (!(current instanceof BlockTentFrame)) continue;
                    ((BlockTentFrame)current).onSuperMalletUsed(worldIn, curPos, state, mallet, player, hand);
                }
            }
        }
        return true;
    }
}

